/**************************************************************************
TITLE:  vgr_sfdu.C

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:		Solaris 2.10
Modified:	Ray Bambery - 11-18-2020
		removed debug print statements
		Ray Bambery - 2-28-2021
		added comments
		Ray Bambery - 4-6-2021
		implemented debug_on == 1 or 2
		Ray Bambery - 5-17-2021
                added debug_on lines where necessary
                Ray Bambery - 6-8-2021
                checked out all if (debug_on == 1) statements for non printf statements
                due to failures in read_sclk.c when not in debug mode.
                Get abort msg at varying points when reading SCLK_SCET.31 or
                SCLK_SCET.32
                Msg: 
                sclkentry = 2031072
                sclkentry = 2031112 sclk_erows = 19
                read_sclk: START  sclk_rSegmentation Fault (core dumped)
		Ray Bambery - 11-18-2021
		changed some debug_on = 1 to 3
		fixed "Segmentation Fault (core dumped)" on debug_on == 2 when debug_on =1
		by moving indicated code statement
		Ray Bambery - 11-09-2021
		check for byte reversal on input data set
		Ray Bambery - 01-07-2022
    		final debug printfs removed (//#)	
                Ray Bambery - 04-08-2022
                put in debug= 10 option

**********************************************************************************8
References:
1) 618-306_Rev. D, CHG 4 Voyager Experiment Data Record Format - 1 May 1986
2) 618-306_RevD_ch5 - 1 May 1989       CR5A format 
3) 618-609_RevB_chg6_VGR_swreq_edr - 2 June 1986
4) 820-013_0171-telecomm-VGR-NJPL-Rev G Appendix_L5 - 9-29-2009
5) 820-013_0161-Telecomm_RevB-L5 - 19 Nov 2014
6) 820-013_0172-Telecomm-CHDO_RevI-L5-1 - 10-03-2019

 This routine extracts the data from the sfdu2 file datafile. 
**********************************************************************
Components of vgr_edr include 2 types of sfdu's
Type 2 was used for Voyager telemetry
Type 3 is used for scet file

Type 2 has the magic file ID of NJPL2I00C220
Tyep 3 has the magic file ID of CCSD3ZS00001

This module vgr_sfdu.C addresses Type 2
The module sfdu.c addresses Type 3

For a complete description of a SFDU type 2 file see:
 JPL Doc. 820-013 DSN External
 Interface Specification (D-16765) "Telemetry Standard Format
 Data Unit (SFDU) Interface" - Rev A - Aug 29, 2008

 Section 3 describes the Detailed Interface Description and physical
 layout of the telemetry SFDU.

 Also the CHDO descriptions are detailed in JPL Doc 820-013-0172
 Telecom CHDO Structures - Rev E - Jul 30, 2010

For an example of the Voyager structure see vgr_edr_sfdu.h

This module includes:			CALLED BY:
vgr_sfdu::load_data_from_buf		vgr_edrgen
vgr_sfdu::get_prim_labl_hdr		vgr_sfdu::load_data_from_buf,vgr_sfdu::load_first_MF_from_file
					vgr_sfdu::load_data_from_file
vgr_sfdu::ddp_to_data_mode		vgr_sfdu::get_prim_labl_hdr
vgr_sfdu::get_bit_rate_index		vgr_edr::store_hdrs_of_first_MF
vgr_sfdu::get_reed_golay		vgr_edr::store_hdrs_of_first_MF
vgr_sfdu::get_data_source_status	vgr_edr::store_hdrs_of_first_MF
vgr_sfdu::get_data_bits			vgr_edr::set_subhdr
vgr_sfdu::get_field_by_hdrmap		vgr_sfdu::get_bit_rate_index,vgr_sfdu::get_reed_golay,
					vgr_sfdu::get_data_source_status,vgr_sfdu::get_dqsw_status,
					vgr_sfdu::get_sclk,vgr_sfdu::get_ert,vgr_sfdu::get_scet
vgr_sfdu::convert_sfdu_to_edr		vgr_sfdu::get_field_by_hdrmap
vgr_sfdu::get_bits_given_byt		vgr_sfdu::get_data_bits,vgr_sfdu::get_field_by_hdrmap
vgr_sfdu::get_dqsw_status		vgr_edr::set_dqi_dqsw
vgr_sfdu::get_sclk			vgr_edrgen
vgr_sfdu::get_ert			vgr_edr::store_hdrs_of_first_MF
vgr_sfdu::get_scet			vgr_edr::store_scet

routines disabled:
vgr_sfdu::load_file                     NOT USED
vgr_sfdu::load_first_MF_from_file       NOT USED
vgr_sfdu::load_data_from_file           NOT USED
int vgr_sfdu::get_prim_labl_hdr(void)   
vgr_sfdu::get_byte_val                  NOT USED
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <math.h>

#include "type_conv.H"
#include "vgr_sfdu.H"
#include "vgr_sfdu.h"
#include "vgr_edr_sfdu.H"
#include "vgr_edr_sfdu.h"

#define  DATA_TRANSFER_SIZE 10
//FILE*    fd;
U8*        fd;

//---------------------------------------------------------------------
vgr_sfdu::vgr_sfdu()
{
  fflush(stdout);
}
//---------------------------------------------------------------------
int vgr_sfdu::load_data_from_buf( U8* sfdu_pointer)
{
  int i, buf_len;
  int type, len;
   char buffer[358];		//changed from 400
/*
* Goes thru 1st record of datafile.a or datafile.b 
* 
* sfdu_pointer - datafile.a or datafile.b
*
* load the data from the file and process  
* fd is a pointer normally used for files
*/
// D-18
	if (debug_on == 1) {
		printf ("vgr_sfdu::load_data_from_buf sfdu_pointer = %x\n",sfdu_pointer);
	}
//
  fd = sfdu_pointer;     // think abount use &   and  const

  buf_len = 0;			//init 
  char* sf = (char*)&fd;

// load in primary header & aggreg chdo - returns offset to 8-byte primary CHDO
  buf_len= get_prim_labl_hdr(sfdu_pointer);
//   		if (debug_on == 2)
//                   {
//                        printf(" buf_len of prim = %d \n",buf_len);
//                    }

  if (buf_len > 0)

  {
/* step thru all header records  -  addresses are examples
* buf_len      address
*     0       	22e7600   	start of SFDU header 
*    32		22e761c   	end of HDR+AggregCHDO+primaryCHDO
*    116	22e7624		end of secondary CHDO
*    146        22e7678		30 bytes into TLM CHDO
*    162        22e7696		46 bytes into TLM CHDO
*    358	22e76a6   	end of SFDU record
*/
//	printf ("fd data sf[12] = %X sf[28] = %X, sf[34] = %X, sf[85] = %X, sf[124] = %X, sf[144] = %X\n",
//	sf[12],sf[28],sf[34],sf[85],sf[124],sf[144]);	  
// prints out Primary CHDO contents of datafile.
	memcpy(&buffer[0],fd,358);		//cp sfdu2 record char by char from beginning of primary CHDO

	if (debug_on == 3) {
		printf ("  buf_len = %d   buffer[i] fd data\n",buf_len);
		printf ("load_data_from_buf:  datafile HDR read in\n");
	}
	if (debug_on == 2) {
		for (i=buf_len;i<8+buf_len;i++) {
			printf ("%x ",buffer[i]&0xff);        //sf[i]&0xff);   // (char*)prim_labl_hdr_ptr
		}
		printf ("\n\n");
        }
//
// This loop yields buf_lens of 32, 116, 146, 162 and 358 at end of each loop
   for (i = 0; i < MAX_HDRS; i++)		//MAX_HDRS = 5
   {

      memcpy(&sfoc_hdr[i].chdo_type[0], fd + buf_len, 2); 
//	printf ("&sfoc_hdr[i].chdo_type[0] = %d\n",sfoc_hdr[i].chdo_type[0]); 
      buf_len +=  2;
      memcpy(&sfoc_hdr[i].chdo_len[0], fd + buf_len, 2);
      buf_len +=2;

                if (debug_on == 3) {
                      type = C16_TO_I16(sfoc_hdr[i].chdo_type);
                      len  = C16_TO_I16(sfoc_hdr[i].chdo_len);
			printf ("vgr_sfdu::load_data_from_buf: sfox_hdr #%d chdo_type = %d  hdr_len = %d\n",i,type,len);
		}
/* when following statement was inside above debug_on snippet it crashed with "Segmentation Fault (core dumped)" */
      sfoc_hdr[i].data_ptr = fd + buf_len ;           //store address to beginning of primary CHDO
      sfoc_hdr[i].sfdu_pointer = fd; 
      buf_len += C16_TO_I16(sfoc_hdr[i].chdo_len) ;	//now add offset to secondary CHDO

//        printf ("vgr_sfdu::load_data_from_buf:  %d   chdo_type = %d  chdo_len = %d\n",i,sfoc_hdr[i].chdo_type,sfoc_hdr[i].chdo_len);

                 if (debug_on == 2) {
                      printf(" buf_len = %d \n", buf_len);
			fflush(stdout);
             	 }
   }
       if (debug_on == 3) {
		printf ("vgr_sfdu:: load_data_from_buf buf_len = %d\n",buf_len);
		printf ("          value of 358 means read 1st record of datafile\n");
	}
   return(buf_len);
// at end it puts to 358, the beginning of the next record
  }
  else {
   return(FALSE);
  }
}
//---------------------------------------------------------------------
int vgr_sfdu::get_prim_labl_hdr(U8* sfdu_ptr)
{
  int done;
  int total, i;


// this reading of 20-byte HDR lead by NJPL2I00C220 + AGGREG_CHDO 
// C220 = data mode CR_5A    If C221 then UV_5A
// returns offset to 8-byte primary CHDO

//sfdu_pointer is renamed sfdu_ptr
  U8 lable[5] = "NJPL";
  U8 rev_lable[5] = "JNLP";
//	printf ("vgr_sfdu::get_prim_labl_hdr\n");
  prim_labl_hdr_ptr = sfdu_ptr;
  done = FALSE;
// D-19
  if (debug_on == 1) {
	printf ("vgr_sfdu:: check for byte reversal\n");
  }
//
  if (strncmp((char*)prim_labl_hdr_ptr, (char*)rev_lable, 4) == 0) {
	printf ("vgr_sfdu::get_prime_lbl_hdr: DATA SET is Byte reversed\n");
	printf ("                             PLEASE run byteswap program\n");	
	exit;
  }
  if (strncmp((char*)prim_labl_hdr_ptr, (char*)lable, 4)) {
	printf("vgr_sfdu::get_prime_lbl_hdr:  reading one wrong sfdu record !!!");
	fflush(stdout);
	return(FAIL);
  }
// this points to sfdu HDR
	char* sf = (char*)prim_labl_hdr_ptr;
//	for (i=0;i<20;i++) {
//		printf ("vgr_sfdu::get_prim_labl_ptr: sf[i=%d] = sf[i] = %X\n",i,sf[i]&0xff);
//	}
  total= PRIM_LABL_LEN + AGGR_CHDO_LEN;				//20 bytes + 4 bytes
		if (debug_on == 2){
			printf("vgr_sfdu: total_len before ddp =%d\n", total);
			fflush(stdout);
		}
  vgr_sfdu::ddp_to_data_mode();
 //                       printf("total_len before ddp =%d\n", total);
               if (debug_on == 2) {
			fflush(stdout);
		}
  return (total);
}
//---------------------------------------------------------------------
// ? variable # of parms ?
int vgr_sfdu::ddp_to_data_mode( unsigned char* ddp_id_tmp, int *maj,
             int *min, int *fmt_id, int *msn_id)
{
  int ii;
// D-20
	if (debug_on == 1)  {
		printf ("vgr_sfdu::ddp_to_data_mode\n");
	}
//
  for (ii = 0; ii < MAX_DDP; ii++) {
      if (!strncmp((char*)&ddp_map[ii].ddp_id[0], (char*)ddp_id_tmp,
                   strlen(&ddp_map[ii].ddp_id[0])))  {

         break;
      }
  }
  if (ii < MAX_DDP) {
     *maj = ddp_map[ii].maj;
     *min = ddp_map[ii].min;
     *fmt_id = ddp_map[ii].fmt_id;
     *msn_id = ddp_map[ii].msn_id;
// D-21
     if (debug_on == 1) {
	printf ("ddp_to_data_mode: %d  maj = %d min = %d fmt_id = %d data_mode = %s\n",ii,
	ddp_map[ii].maj,ddp_map[ii].min,ddp_map[ii].fmt_id,ddp_map[ii].msn_id,ddp_map[ii].data_mode); 
     }
//
     return (ddp_map[ii].data_mode);
  }
  else {
     return (FALSE);
  }
}
//---------------------------------------------------------------------
int vgr_sfdu::ddp_to_data_mode()
{
    int ii;
    char maj[2], min[2], msn_id[2], fmt_id[2];

/* reads data in structure: DDP_DATA_MODE_STRUCT ddp_map[MAX_DDP] in in vgr_sfdu.h 
 * returns either 0 (ddp_id = CR_5A) or 1 (ddp_id = UV_5A) data modes 
 * MAX_DDP = 2
 * data_mode 1 = C220 = CR_5A
 * data mode 2 = C221 = UV_5A
 *  Notice: that &ddp_map[ii].ddp_id,ddp_map[ii].maj,ddp_map[ii].min, 
 *  ddp_map[ii].msn_id,  ddp_map[ii].fmt_id
 *  corresepond to entries in primary CHDO (10,11,12,13)
 *  ddp_map[ii].data_mode is from sfdu2 HDR Data_Description ID.
 *  entries 8-11.
 *
 */
  for (ii = 0; ii < MAX_DDP; ii++) {
      if (!strncmp((char*) &ddp_map[ii].ddp_id[0],
                   (char*)&prim_labl_hdr_ptr[PRIM_DDP_ID_LOC],
                   strlen(&ddp_map[ii].ddp_id[0])))  {

         break;
      }
  }
  if (ii < MAX_DDP) {

/* ?
  this has to be after sfoc_hdr[PRIM_HDR_ID] allocated


    memcpy(&maj[0], sfoc_hdr[PRIM_HDR_ID].data_ptr, 2);
    memcpy(&min[0], sfoc_hdr[PRIM_HDR_ID].data_ptr+2, 2);
    memcpy(&msn_id[0], sfoc_hdr[PRIM_HDR_ID].data_ptr+4, 2);
    memcpy(&fmt_id[0], sfoc_hdr[PRIM_HDR_ID].data_ptr+6, 2);


    if ((C16_TO_I16(maj)==ddp_map[ii].maj) && 
       (C16_TO_I16(min)==ddp_map[ii].min) &&
       (C16_TO_I16(msn_id)==ddp_map[ii].msn_id) &&
       (C16_TO_I16(fmt_id)==ddp_map[ii].fmt_id))

     {

// 			if (debug_on)
//			printf("maj=%d min=%d msn=%d fmt=%d data_mode=%d\n",
//			 maj,min, msn_id, fmt_id, ddp_map[ii].data_mode);
         return (ddp_map[ii].data_mode);
     }
     else return (FALSE);
*/
//			if (debug_on)
//			printf("ddp.data_mode= %x \n", ddp_map[ii].data_mode);
//        printf ("ddp_to_data_mode: %d  maj = %d min = %d fmt_id = %d data_mode = %s\n",ii,
//        ddp_map[ii].maj,ddp_map[ii].min,ddp_map[ii].fmt_id,ddp_map[ii].msn_id,ddp_map[ii].data_mode);

     return (ddp_map[ii].data_mode);
  } 
  else 
  {
	if (debug_on == 2) { 
		printf ("vgr_sfdu::ddp_to_data_mode:  ddp_map.ddp_id = %s \n", 
		    (char*)&prim_labl_hdr_ptr[PRIM_DDP_ID_LOC]);
	}
        return (FALSE);
  }
}

//---------------------------------------------------------------------
U8 vgr_sfdu::get_bit_rate_index()
{
// get value from sfdu location in HDRs using the table sfdu_edr_hdr_map
// in vgr_sfdu.h and transfer to edr
  U32 rate;
  int i;

  rate = C32_TO_U32( (get_field_by_hdrmap( item_32_BIT_RATE))->buf);
//  			if (debug_on == 2)
//			printf("bit_rate= %0x   ", rate);
  
  for (i = 1; i < MAX_BIT_RATE_NO; i++)
  {
      if (rate == bit_rate_tbl[i]) {
//			if (debug_on == 2)
//			      printf ("bit_rate_index = %d \n", i);
         return ( (U8)( i ));
      }
  }
  return ( FALSE );
}
//---------------------------------------------------------------------
U8 vgr_sfdu::get_reed_golay()
{
  U8 reed_golay[2];

  memcpy (reed_golay, get_field_by_hdrmap(item_14_GOLAY), 2);
 
//				if (debug_on)
//	 			printf("reed: %02x golay: %02x\n",reed_golay[0],
//					reed_golay[1]); 
//if ((int)(reed_golay[0] & 0xff) >= 3)
  if ((int)(reed_golay[0] & 0xff) > 0)
     return( 0x40);
//if ((int)(reed_golay[1] & 0xff) >= 3)
  if ((int)(reed_golay[1] & 0xff) > 0)
     return (0x80);

  return (0);
}
//---------------------------------------------------------------------
U8 vgr_sfdu::get_data_source_status() 
{
 
   U8 replay_flg, org_src;
   static U8 src_status;

   replay_flg = (get_field_by_hdrmap( item_60_REPLY_F))->buf[0];
   org_src    = (get_field_by_hdrmap( item_61_ORG_SRC))->buf[0];

   src_status = 0;

   if ( replay_flg == 4) 
	src_status = 0x80;
   if ( org_src > 0) 
	src_status = 0xc0;  //?? reverse order ?
   else
	src_status = 0x40;

   return(src_status);
}   
//---------------------------------------------------------------------

//???  shift works only on int

// parameters are one_based
// copy by char type & shift by integral type
//unsigned char* vgr_sfdu::get_data_bits( int start_bit, int bit_len )
TRANS_BUF_STRUCT* vgr_sfdu::get_data_bits( int start_bit, int bit_len )
{
  int start_byte, first_bit_in_byte;

  start_byte = (start_bit - 1) / 8;
  first_bit_in_byte  = (int) fmod((start_bit - 1), 8);
  return( get_bits_given_byt( DATA_SEG_ID, start_byte, first_bit_in_byte, 
                              bit_len)); 
}
//---------------------------------------------------------------------
//unsigned char* sfdu::get_field_by_hdrmap( int def_item_id)
TRANS_BUF_STRUCT* vgr_sfdu::get_field_by_hdrmap( int def_item_id)
{
/*   go thru all items in sfdu_edr_hdr_map and extract item_id,
 *   from sfdu HDR ID shown in vgr_sfdu.h and get ready to pass to edr
 *   HeaderID, start_byt, start_bit
 *   and bit_len as shown in sfdu.h
 */
  int i;

  // U8* test_ptr;

  TRANS_BUF_STRUCT* test_ptr;
// test_ptr elements are:
//       typedef struct trans_buf_struct {
//           unsigned char buf[DATA_TRANSFER_SIZE]; 		test_ptr->buf
//           int buf_len;					test_ptr->len
//       } TRANS_BUF_STRUCT;


                 if (debug_on == 2)
                        printf("vgr_sfdu::get_field_by_hdrmap: def_item_id == %d  \n  ", def_item_id);

  for (i = 0; sfdu_edr_hdr_map[i].item_id < ITEM_99; i++) {
//	printf (" i = %d: def_item_id = %d\n",i,def_item_id);
      if (sfdu_edr_hdr_map[i].item_id == def_item_id)
         break;     
 }


  if (sfdu_edr_hdr_map[i].item_id == ITEM_99)
     {
        printf("vgr_sfdu::get_field_by_hdrmap:  item_id %d not defined!! \n", def_item_id);
        exit(0);
     }
  if (sfdu_edr_hdr_map[i].item_id < ITEM_99)
  {

            test_ptr = get_bits_given_byt(sfdu_edr_hdr_map[i].hdr_no,
            sfdu_edr_hdr_map[i].start_byt - 4, sfdu_edr_hdr_map[i].start_bit,
            sfdu_edr_hdr_map[i].bit_len);
// D-22
	if (debug_on == 1) { 
		printf ("vgr_sfdu::get_field_by_hdrmap:  sfdu_edr_hdr_map buf_len = %d test_ptr = %x \n",test_ptr->buf_len,test_ptr);
		printf ("          i=%d, item_id=%d,  HDR_NO=%d,  start_byt=%d  start_bit=%d, bit_len = %d\n",
		    i,sfdu_edr_hdr_map[i].item_id,sfdu_edr_hdr_map[i].hdr_no,sfdu_edr_hdr_map[i].start_byt,
		    sfdu_edr_hdr_map[i].start_bit,sfdu_edr_hdr_map[i].bit_len);
	}
//
//		for(i=0;i<DATA_TRANSFER_SIZE;i++) {
//			printf ("    test_ptr->buf[i=%d] = %x = %c\n",i,test_ptr->buf[i],test_ptr->buf[i]); 
//		} 
  	    if (debug_on == 2) {
//    points to tertiary CHDO - items 27,28,29 or secondary CHDO item 3
		printf(" buffer:  ");
	        for (i = 0; i < 4;i++) {
	           printf(" %X ", test_ptr->buf[i]);
	        }
		printf ("\n");
	    }
	    convert_sfdu_to_edr(def_item_id, test_ptr->buf);
			
		if (debug_on == 2)  {
		     printf(" after conv=  ");
		     printf(" def_item_id = %d   ", def_item_id);
	             for (i = 0; i < 4; i++) {
          	         printf("%x ", test_ptr->buf[i]);
		   	 fflush(stdout);
            	     }
		} 
/*
     return(get_bits_given_byt(sfdu_edr_hdr_map[i].hdr_no,
            sfdu_edr_hdr_map[i].start_byt - 4, sfdu_edr_hdr_map[i].start_bit,
            sfdu_edr_hdr_map[i].bit_len));
*/
	    return(test_ptr);
  }
  else {
       return(NULL);
  }
}  
  
//---------------------------------------------------------------------
void vgr_sfdu::convert_sfdu_to_edr(int sfdu_item_id, U8* sfdu_val_ptr)
{
/* value_map 31 = 1, 32 =2
 * check to see if vgr_edr_sfdu.H
 *
 * sub_map_ptr
 * typedef struct sfdu_edr_map_struc {
 *         U8  sfdu_val;			//sub_map_ptr->sfdu_val
 *         U8  edr_val;				//sub_map_ptr->edr_val
 * } VGR_SFDU_EDR_MAP;
 *
 * value_map is:
 * typedef struct sfdu_edr_conv_struc {
 *        int                     item_id;
 *        int                     mem_size;	//value_map.mem_size
 *        VGR_SFDU_EDR_MAP*       map_ptr;	//value_map.map_ptr
 * } MAIN_SFDU_EDR_MAP;
 *
 */
   int i, j;
   VGR_SFDU_EDR_MAP* sub_map_ptr;

         if (debug_on == 2) {
		printf ("vgr_sfdu::comvert_sfdu_to_edr\n");
         }
   for (i = 0; value_map[i].item_id < ITEM_99; i++)
   {
   		if (debug_on == 3) {
			printf("           map %d, item_id=%d\n   ", 
				i, value_map[i].item_id );
  		}

       if ((value_map[i].item_id == sfdu_item_id)&&
           (value_map[i].map_ptr > NULL))
       {
		if (debug_on == 2) {
			printf(" sub_map_ptr not null ! \n");
		}

	   sub_map_ptr = value_map[i].map_ptr;
	   for (j = 0; j < value_map[i].mem_size; j++)
	   {
                 if (debug_on == 3) {
                          printf("      j= %d, (sub_map_ptr+j)->sfdu_val = %d  sfdu_val_ptr = %x \n", 
			  	j,(sub_map_ptr+j)->sfdu_val,*sfdu_val_ptr);
		}

	      if ((sub_map_ptr+j)->sfdu_val == *sfdu_val_ptr) 
	      {
		 *sfdu_val_ptr = (sub_map_ptr+j)->edr_val;
		if (debug_on == 3) {
			  printf("    j= %d, (sub_map_ptr+j)->edr_val= %d sfdu_val_ptr = %x \n",
			   j,(sub_map_ptr+j)->edr_val,*sfdu_val_ptr );
//			  fflush(stdout); 
 		}
		 break; 
	      }
	   }
	}
    }
}

//---------------------------------------------------------------------
//unsigned char* vgr_sfdu::get_bits_given_byt (int hdr_no, int start_byte, 
TRANS_BUF_STRUCT* vgr_sfdu::get_bits_given_byt (int hdr_no, int start_byte, 
                                         int start_bit, int bit_len) 
{
  int i, byte_len;

  static TRANS_BUF_STRUCT data_buf = 
                {0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; //????
  unsigned char R_mask, L_mask ;


  memset(&data_buf.buf[0], 0, DATA_TRANSFER_SIZE);

  if (bit_len > (DATA_TRANSFER_SIZE * 8)) {
     printf ("vgr_sfdu::get_bits_given_byt: data transfer buffer size is bigger that %d \n", 
              DATA_TRANSFER_SIZE);
     exit(0);
  }
 
  R_mask = L_mask = 0xFF;

  R_mask >> start_bit;
  L_mask << (8 - start_bit);

  byte_len   = (start_bit + bit_len + 7) / 8;


                if (debug_on == 2)
			{
                        printf(" sfdu: hdr_no=%d, start_byte=%d, start_bit=%d,bit_len=%d, byt-len=%d\n ",
                        hdr_no, start_byte, start_bit, bit_len, byte_len);

		       }
  memcpy((unsigned char*)&data_buf.buf[0], sfoc_hdr[hdr_no].data_ptr
          +start_byte, byte_len);

			if (debug_on == 2)
			{
                            for (i = 0; i< byte_len; i++) {
                                 printf(" %02x", data_buf.buf[i]);
                            }
                            printf(" \n");
			}
  if (start_bit > 0) { 
     for (i = 0; i < byte_len; i++) {
         data_buf.buf[i] = ((data_buf.buf[i]   & R_mask) << start_bit)       |
                           ((data_buf.buf[i+1] & L_mask) >> (8 - start_bit));
     } 
  }
  data_buf.buf_len = byte_len;

		if (debug_on == 2)
		{
			  printf("sfdu: ");
			  for (i = 0; i< byte_len; i++) {
				  printf(" %02x", data_buf.buf[i]);
			  }
			  printf(" \n");
	 	}	
  return (&data_buf);
   
}

//---------------------------------------------------------------------
//???  TPA not solved
U8 vgr_sfdu::get_dqsw_status()
{
 U8* lock_data; 
 U8 lock_mask_1, lock_mask_2,  ret_mask;
// U8 tpa_mask;
    lock_mask_1 = 0x38; 
    lock_mask_2 = 0x02;
    lock_data = (get_field_by_hdrmap(item_44_LOCK_ST))->buf;
    ret_mask  = ((lock_mask_1 & *lock_data) >> 1) | 
                (lock_mask_2 & *lock_data);

		if (debug_on == 2) {
			printf("lock_data= %02x  ret_mask= %02x\n",
				*lock_data, ret_mask);
		}
    return(ret_mask);
}

//---------------------------------------------------------------------
// how to connect position parameters & subroutine ptrs together????
// ? need to modify
//---------------------------------------------------------------------
SFOC_SCLK_TIME vgr_sfdu::get_sclk()
{
/*   item_27 and item_28 are from tertiary CHDO of datafile at
 *   locations byte 10 (16-bits) and byte 12 (16-bits)
 *   ln_cnt is from byte 14 (16 bits)
 */
  static SFOC_SCLK_TIME sfoc_time;
 
  memcpy (&sfoc_time.m16, (get_field_by_hdrmap(item_27_M16))->buf,       
	  sizeof(sfoc_time.m16));
  memcpy (&sfoc_time.m60, (get_field_by_hdrmap(item_28_M60))->buf,
 	  sizeof(sfoc_time.m60));
  memcpy (&sfoc_time.ln_cnt, (get_field_by_hdrmap(item_29_LN_CNT))->buf,
	  sizeof(sfoc_time.ln_cnt));
             if (debug_on == 2)
                {
                 printf("vgr_sfdu::get_sclk:    m16= %02x %02x, m60= %02x %02x, ln=%02x %02x \n",
	                 sfoc_time.m16[0], sfoc_time.m16[1],
        	         sfoc_time.m60[0], sfoc_time.m60[1],
                	 sfoc_time.ln_cnt[0], sfoc_time.ln_cnt[1]);
//		 fflush(stdout);
                }

  return (sfoc_time); 
}
//---------------------------------------------------------------------------
SFOC_ERT_TIME vgr_sfdu::get_ert()
{
  static SFOC_ERT_TIME sfoc_ert;

  memcpy(&sfoc_ert.ds1958, (get_field_by_hdrmap(item_9_SERT_DAY))->buf,
	 sizeof(sfoc_ert.ds1958));
  memcpy(&sfoc_ert.msec, (get_field_by_hdrmap(item_10_SERT_SEC))->buf,
	 sizeof(sfoc_ert.msec));

	if (debug_on == 2)
	{
		printf("sfdu::ds1958= %02x %02x, msec= %02x %02x %02x %02x \n",
		sfoc_ert.ds1958[0], sfoc_ert.ds1958[1],
		sfoc_ert.msec[0], sfoc_ert.msec[1],
		sfoc_ert.msec[2], sfoc_ert.msec[3]);
	}

  return (sfoc_ert);
}
//------------------------------------------------------------------------
SFOC_ERT_TIME vgr_sfdu::get_scet()
{
  static SFOC_ERT_TIME sfoc_scet;

  memcpy(&sfoc_scet.ds1958, (get_field_by_hdrmap(item_21_SCET_DAY))->buf,
         sizeof(sfoc_scet.ds1958));
  memcpy(&sfoc_scet.msec, (get_field_by_hdrmap(item_22_SCET_SEC))->buf,
         sizeof(sfoc_scet.msec));

         if (debug_on == 2)
                {
                printf("sfdu::ds1958= %02x %02x, msec= %02x %02x %02x %02x \n",
                sfoc_scet.ds1958[0], sfoc_scet.ds1958[1],
                sfoc_scet.msec[0], sfoc_scet.msec[1],
                sfoc_scet.msec[2], sfoc_scet.msec[3]);
                }

  return (sfoc_scet);
}
/***********************************************************************
 *                   DELETED ROUTINES
 */
/*
int vgr_sfdu::load_file(char* file_name)
{

  if ((fd = fopen(file_name,"r")) == NULL) {
      system("inform 'can't open input file'");
      return(FALSE);
  }
  else
      return(TRUE);
}
*/
//---------------------------------------------------------------------
/*
 int vgr_sfdu::load_first_MF_from_file()
{
  int i, total_len;
  int type, len;

  total_len = 0;

  if (get_prim_labl_hdr())

  {

   for (i = 0; i < MAX_HDRS; i++) 
   {
        printf (vgr_sfdu::load_first_MF_from_file fread:  i = %d\n",i);
      fread(&sfoc_hdr[i].chdo_type[0], 1, 2, fd);
      fread(&sfoc_hdr[i].chdo_len[0], 1, 2, fd);

                        if (debug_on) {
                        type = C16_TO_I16(sfoc_hdr[i].chdo_type);
                        len  = C16_TO_I16(sfoc_hdr[i].chdo_len);
                        printf(" i = %d:: chdo_type = %d,  chdo_len = %d \n", i, type, len);                        }

      if (C16_TO_I16(sfoc_hdr[i].chdo_len) > 0) {
      sfoc_hdr[i].data_ptr = new (unsigned char[ C16_TO_I16(
                                  sfoc_hdr[i].chdo_len)]);
      fread(sfoc_hdr[i].data_ptr, 1, C16_TO_I16(sfoc_hdr[i].chdo_len), fd);
                printf (vgr_sfdu::load_first_MF_from_file fread i = %d\n",i);
      total_len = C16_TO_I16(sfoc_hdr[i].chdo_len) ;
      }

                        if (debug_on)
                        printf(" total_len = %d \n", total_len);
   }
   return(total_len);

  }
  else {
   return(FALSE);
  }
}
*/
//---------------------------------------------------------------------------------
/*
int vgr_sfdu::load_data_from_file()
{
  int i, total_len;
  int type, len;
  U8 chdo_type[2];
  U8 chdo_len[2];


  if (get_prim_labl_hdr() > 0)
  {

   for (i = 0; i < MAX_HDRS; i++) 
   {
      total_len = 0;
        printf (vgr_sfdu::load_data_from_file fread: i = %d\n",i);
      fread(&chdo_type[0], 1, 2, fd);
      fread(&chdo_len[0], 1, 2, fd);

                        if (debug_on) {
                        printf("chdo_type= %x %x, chdo_len=%x %x \n",
                        chdo_type[0],chdo_type[1], chdo_len[0],chdo_len[1]);

                        type = C16_TO_I16(chdo_type);
                        len  = C16_TO_I16(chdo_len);
                        printf(" chdo_type = %d,  chdo_len = %d \n", type, len);
                        }


      if (!strncmp((char *)&sfoc_hdr[i].chdo_type[0], 
                   (char *)&chdo_type[0], 2) &&
          !strncmp((char *)&sfoc_hdr[i].chdo_len[0],(char*) &chdo_len[0], 2) ) {

        if (C16_TO_I16(chdo_len) > 0) {      
           fread(sfoc_hdr[i].data_ptr, 1, C16_TO_I16(sfoc_hdr[i].chdo_len), fd);
           total_len = C16_TO_I16(sfoc_hdr[i].chdo_len) ;
                printf (vgr_sfdu::load_data_from_file frad:  i = %d\n",i);
                        if (debug_on)
                        printf(" !!! read %d  ", total_len);
        }
        else 
           break;
      }
      else
        break;  
   }
                        if (debug_on)
                        printf(" total_len = %d \n", total_len);
   return(total_len);

  }
  else {
   return(FAIL);
  }
}
*/

//--------------------------------------------------------------------------------------
/*
int vgr_sfdu::get_prim_labl_hdr(void)
{

  int status;
  int i, done;

  U8 lable[5] = "NJPL";

  done = FALSE;
  prim_labl_hdr_ptr = &prim_labl_hdr[0];

  while (!done) {

      for (i = 0; i < 4; i++) {
          if (fread(&prim_labl_hdr[i], 1, 1, fd) <= FALSE)
             return(FAIL);

                        if (debug_on) {
                        printf("vgr_sfdu::get_prim_labl_hdr:   fread: #[%d]=%x", i, prim_labl_hdr[i]);
                        }

          if (prim_labl_hdr[i] != lable[i]) 
             break;
      }
      if (i == 4)
         done = TRUE;
  }
  
  if (done) {       
      status = fread(&prim_labl_hdr[4], 1, sizeof(prim_labl_hdr) - 4, fd);

                        if (debug_on) {
                        printf("\nvgr_sfdu::get_prim_labl_hdr: fread:  prim_labl_hdr size = %d\n",
                                sizeof(prim_labl_hdr));
                        printf("  status = %d  ", status);
                        printf("&prim_labl_hdr= %d  [0]=%x ",&prim_labl_hdr[0],
                        prim_labl_hdr[0]);
                        printf(" prim_lab: %s\n", prim_labl_hdr);
                        }

      if (!status)
         return (FALSE);

      if (!strncmp((char*)&prim_labl_hdr[PRIM_AUTH_ID_LOC], "NJPL", 4) &&
          ddp_to_data_mode(prim_labl_hdr))
      return( TRUE);

//  add check maj, min, ms_id, fmt against ddp_map

    }
    return( FALSE);
}
*/
//------------------------------------------------------------------------------------------
/*
unsigned char vgr_sfdu::get_byte_val(int hdr_no, int offset, int start_bit, int bit_len)
{
    unsigned char return_val;
    unsigned char mask_val = 0xff;

    mask_val >> (8 - start_bit - bit_len) << (8 - start_bit - bit_len);
    mask_val << start_bit >> start_bit; 
    
    return_val = ((*(sfoc_hdr[hdr_no].data_ptr+ offset)) & mask_val) >> 
                 (8 - bit_len);
    return (return_val);
}
*/
