/*    @(#)$Id$      */
#ifdef _TED_INIT_
#define INIT(x) x
#define ALLOC
#else
#define INIT(x)
#define ALLOC extern
#endif

typedef	unsigned char	ubyte;

/* size of SFDU label in bytes */
#define LABEL_LENGTH			20
#define MAX_SFDU_LENGTH   		32768+LABEL_LENGTH
#define PRIMARY_SIZE                    4
#define CHDO_SIZE                       4
#define PRIMARY_HDR_DATA_OFFSET 	LABEL_LENGTH+(2*CHDO_SIZE)
#define SC_ID_OFFSET   	PRIMARY_HDR_DATA_OFFSET+CHDO_SIZE+PRIMARY_SIZE+2
#define NJPL				"NJPL"
#define STAT_ERR			"STAT/ERR"
#define TDSQUERY			"TDSQUERY"
#define QUERYSPC			"QUERYSPC"
#define TDSQDATA			"TDSQDATA"
#define K_HEADER			"NJPL3KS0L009"
#define K_HEADER_LENGTH			12
#define END_OBJECT_LABEL		"END_OBJECT"
#define END_OBJECT_LENGTH		28
#define OBJECT_LABEL			"OBJECT"
#define OBJECT_LENGTH			24
#define STATUS				"Status Message"
#define TDS_STATUS			0
#define ERROR				"Error Message"
#define TDS_ERROR			1
ALLOC   char*    MESSAGE_TYPE_LABEL INIT(= {"MESSAGE_TYPE"});
#define MESSAGE_TYPE_LENGTH		12
ALLOC	char*   MESSAGE_NUM_LABEL INIT(= {"MESSAGE_NUM"});
#define MESSAGE_NUM_LENGTH		11
ALLOC	char*   MESSAGE_LABEL	INIT(= {"MESSAGE "});
#define MESSAGE_LENGTH			7

/* SFDU length in label can be ascii or binary, this field */
/* contains the value that determines the length type      */
#define SFDU_LENGTH_TYPE_OFFSET 	4
/* ASCII length type value */
#define ASCII_LENGTH_TYPE		'1'
/* offset to start of ASCII length field */
#define ASCII_LENGTH_OFFSET		12
/* Binary length type value */
#define BINARY_LENGTH_TYPE		'2'
/* offset to start of Binary length field */
#define BINARY_LENGTH_OFFSET		9
/* Variable length type value */
#define VARIABLE_LENGTH_TYPE		'3'

/*******************************************************/
/*** PVL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   PVL_LABEL INIT(= {"CCSD3ZS00001QUERYSPC"});
ALLOC	char*   PVL_TRAILER INIT(= {"CCSD3RE00000QUERYSPC"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   SFDU_LABEL INIT(= {"NJPL3IS0L009TDSQUERY"});
ALLOC	char*   SFDU_TRAILER INIT(= {"CCSD3RE00000TDSQUERY"});

/******************************/
/*** TDS END OF DATA LABEL  ***/
/******************************/
ALLOC	char*   SFDU_EOD_LABEL INIT(= {"CCSD3RE00000TDSQDATA"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER INDICATING A TDS MESSAGE ***/
/*******************************************************/
ALLOC	char*   TDS_MESSAGE_LABEL INIT(= {"NJPL3KS0L009STAT/ERR"});
ALLOC	char*   TDS_MESSAGE_TRAILER INIT(= {"CCSD3RE00000STAT/ERR"});

/*******************************************************/
/*** NJPL LABEL SIGNIFYING QUERY ECHO FROM TDS       ***/
/*******************************************************/
ALLOC	char*   QUERY_ECHO_LABEL INIT(= {"CCSD3ZS00001TDSQDATA"});

/*******************************************************/
/* PVL parameters used to build TDS query              */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
enum    {PVL_OBJECT,
	 PVL_DESCRIPTION,
	 PVL_NAME,
	 PVL_MISSION,
	 PVL_SC_NAME,
	 PVL_TIME_TYPE,
	 PVL_START_TIME,
	 PVL_STOP_TIME,
	 PVL_TIME_ORDER,
	 PVL_DSS_ID,
	 PVL_SOURCE,
	 PVL_LOADER,
	 PVL_PROTOCOL,
	 PVL_GROUP,
	 MAX_PVL_FIELDS};
ALLOC int pvl_indicators[MAX_PVL_FIELDS];
ALLOC char 	object[35];
ALLOC char* DESCRIPTION_LABEL INIT(={"DESCRIPTION = \"VGR_PROJECT_SERVER\""});
ALLOC char*     EO_LABEL INIT(= {"END_OBJECT = VGR_DATA_RECORDS"});
ALLOC char*     O_LABEL INIT(= {"OBJECT = VGR_DATA_RECORDS"});
ALLOC char* 	MISSION_LABEL INIT(= {"MISSION_NAME = "});
ALLOC char*	NAME_LABEL INIT(= {"REQUESTER_NAME = "});
ALLOC char*     SC_LABEL INIT(= {"SPACECRAFT_NAME = "});
ALLOC char	mission[25];
ALLOC char	sc_name[30];
/***********************************************************/
/* store the spacecraft ID for possible verification       */
/* of SFDUs from TDS(This is mostly to prevent GLL         */
/* Testbed data from getting confused with spacecraft data */
/***********************************************************/
ALLOC int       sc_num;
ALLOC int       sc_id_test_enabled INIT(=FALSE);

/* TIME TYPE CONSTANTS */
enum	{ERT,
	 SCLK,
	 RCT,
	 SCET,
	 MAX_TIME_TYPES};

ALLOC int	time_type_index;
ALLOC char*   	TIME_TYPE_LABEL INIT(= {"TIME_TYPE = "});
static char	*time_type_names[MAX_TIME_TYPES] 
				= {"ERT","SCLK","RCT","SCET"};

ALLOC char*   	START_TIME_LABEL INIT(= {"START_TIME = "});
ALLOC char*   	STOP_TIME_LABEL INIT(= {"STOP_TIME = "});
/* the only time order parameters are ERT or SCLK */
#define MAX_ORDER_TYPES         2
ALLOC int       time_order_index;
ALLOC char*   	TIME_ORDER_LABEL INIT(= {"TIME_ORDER = "});

enum		{NERT,RT,MAX_SOURCE_TYPES};
ALLOC char*   	DATA_SOURCE_LABEL INIT(= {"SFOC_DATA_SOURCE = "});
static char*  	tds_data_source_names[MAX_SOURCE_TYPES] = {"NERT","RT"};
ALLOC int     	tds_data_source[MAX_SOURCE_TYPES];

ALLOC char*   	DSS_ID_LABEL INIT(= {"DSS_ID = ALL;"});

/* group indicies */
enum	{FRAME_GROUP,CHANNEL_GROUP,MAX_GROUPS};
ALLOC int	group_index;
ALLOC char*   	GROUP_LABEL INIT(= {"GROUP = "});
static char	*group_names[MAX_GROUPS]={"FRAME","CHANNEL"};
ALLOC char*   	END_GROUP_LABEL INIT(= {"END_GROUP = "});

ALLOC char	end_object[40];

/*******************************************************/
/* parameters used by frame or packet group query      */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Packet/Frame Group Offsets */
enum		{ENG_DATA,
	 	CHENG_DATA,
	 	SCI_DATA,
	 	CHSCI_DATA,
	 	MON_DATA,
	 	CHMON_DATA,
	 	QQC_DATA,
	 	CHQQC_DATA,
	 	IMG_DATA,
	 	TP_DATA,
	 	CHCCS_DATA,
	 	MRO_DATA,
	 	PFG_BUS_CODE,
	 	PFG_ADDRESS_RANGE,
	 	PFG_TLM_MODE,
	 	PFG_WSE_FILTER,
	 	PFG_SAMPLE_MODE,
	 	MAX_PFG_FIELDS};
/* Packet/Frame Group Flags */
ALLOC short	pfg_indicators[MAX_PFG_FIELDS];
/* DATA TYPES  = last data type + 1 */
#define  MAX_DATA_TYPES MRO_DATA+1
ALLOC short	data_types[MAX_DATA_TYPES];
ALLOC char*   	DT_NAME_LABEL INIT(= {"DATA_TYPE = "});
static char	*data_type_names[MAX_DATA_TYPES]
		 = {"ENG","CHENG","SCI","CHSCI","MON","CHMON",
				"QQC","CHQQC","IMG","TP","CHCCS","MRO"};
ALLOC char*   	BUS_CODE_LABEL INIT(= {"BUS_CODE = "});
ALLOC char*   	ADDRESS_RANGE_LABEL INIT(= {"ADDRESS_RANGE = "});
ALLOC char*   	QQC_MSG_TYPE_LABEL INIT(= {"QQC_MSG_TYPE = "});

/*****************************************************************/
/* All data types are separated into 2 catagories.  The enum     */
/* variables that end in MAX_*_TYPES(where * is a wildcard) are  */
/* TDS specific.  They are used in PVL queries to TDS.           */
/* The enum variables that end in MAX_*_SFDUS(where * is a wild- */
/* card) are created by TIS and defined in SFOC-5-SYS-*DU-NJPL   */
/*****************************************************************/

enum	{ALL_QQC_MSGS,
	HBEAT_IN_SYNC,
	HBEAT_OUT_SYNC,
	HBEAT_NO_DATA,
	TDM_FAIL_ACQ,
	IN_SYNC,
	OUT_SYNC,
	QQC_NO_DATA,
	SCLK_CHANGE,
	FID_CHANGE,
	DECOM,
	EXTR_BEGIN,
	EXTR_END,
	QQC_SUMMARY,
	QQC_DATA_SUMMARY,
	MAX_QQC_TYPES};
static char*  qqc_msg_types[MAX_QQC_TYPES] =
			{"ALL QQC MSGS","HBEAT IN SYNC","HBEAT OUT SYNC",\
			 "HBEAT NO DATA", "TDM FAIL ACQ",\
				"IN SYNC","OUT_SYNC","NO DATA","SCLK CHANGE",\
				"FID CHANGE","DECOM","EXTR BEGIN","EXTR END",\
				"QQC_SUMMARY","QQC_DATA SUMMARY"};
static char*	qqc_types[MAX_QQC_TYPES] = {
		"qqc","qqc_hbeat_in_sync", "qqc_hbeat_out_sync",\
                "qqc_hbeat_no_data", "qqc_tdm_fail_acq",\
                "qqc_in_sync", "qqc_out_sync", "qqc_no_data",\
                "qqc_sclk_change","qqc_fid_change","qqc_decom",\
                "qqc_extr_begin", "qqc_extr_end", "qqc_summary",\
                "qqc_data_summary"};

ALLOC int	qqc_selected[MAX_QQC_TYPES];

enum    {QQC_HBEAT_IN_SYNC_SFDU,
        QQC_HBEAT_OUT_SYNC_SFDU,
        QQC_HBEAT_NO_DATA_SFDU,
        QQC_TDM_FAIL_SFDU,
        QQC_IN_SYNC_SFDU,
        QQC_OUT_SYNC_SFDU,
        QQC_NO_DATA_SFDU,
        QQC_SCLK_CHANGE_SFDU,
        QQC_FID_CHANGE_SFDU,
        QQC_DECOM_SFDU,
        QQC_EXTR_BEGIN_SFDU,
        QQC_EXTR_END_SFDU,
        QQC_SUMMARY_SFDU,
        QQC_DATA_SUMMARY_SFDU,
        MAX_QQC_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into qqc_types */
	char*		ddp_id;
        } qqc_sfdus[MAX_QQC_SFDUS] = {
        {13,0,0,21,0,1,"C414"},
        {13,0,0,22,0,2,"C501"},
        {13,0,0,23,0,3,"C502"},
        {13,0,0,24,0,4,"C419"},
        {13,0,0,26,0,5,"C420"},
        {13,0,0,27,0,6,"C421"},
        {13,0,0,28,0,7,"C422"},
        {13,0,0,29,0,8,"C423"},
        {13,0,0,30,0,9,"C505"},
        {13,0,0,31,0,10,"C506"},
        {13,0,0,32,0,11,"C919"},
        {13,0,0,33,0,12,"C920"},
        {13,0,0,34,0,13,"C921"},
        {13,0,0,35,0,14,"C922"}};

static char*  	ch_qqc_types[MAX_QQC_TYPES] =
		 {"ch_qqc","ch_qqc_hbeat_in_sync","ch_qqc_hbeat_out_sync",
                  "ch_qqc_hbeat_no_data","ch_qqc_tdm_fail_acq",
                  "ch_qqc_in_sync", "ch_qqc_out_sync",
                  "ch_qqc_no_data", "ch_qqc_sclk_change",
                  "ch_qqc_fid_change", "ch_qqc_decom",
                  "ch_qqc_extr_begin", "ch_qqc_extr_end",
                  "ch_qqc_summary", "ch_qqc_data_summary"};
ALLOC int	ch_qqc_selected[MAX_QQC_TYPES];

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into ch_qqc_types */
	char*		ddp_id;
        } ch_qqc_sfdus[MAX_QQC_SFDUS] = {
        {11,0,0,21,0,1,"C414"},
        {11,0,0,22,0,2,"C501"},
        {11,0,0,23,0,3,"C502"},
        {11,0,0,24,0,4,"C419"},
        {11,0,0,26,0,5,"C420"},
        {11,0,0,27,0,6,"C421"},
        {11,0,0,28,0,7,"C422"},
        {11,0,0,29,0,8,"C423"},
        {11,0,0,30,0,9,"C505"},
        {11,0,0,31,0,10,"C506"},
        {11,0,0,32,0,11,"C919"},
        {11,0,0,33,0,12,"C920"},
        {11,0,0,34,0,13,"C921"},
        {11,0,0,35,0,14,"C922"}};

/* Telemetry Mode Offsets */
enum	{MERGED_MODE,
	 REALTIME_MODE,
	 PLAYBACK_MODE,
	 MAX_TLM_MODES};
ALLOC int			tlm_mode_index;
ALLOC char*   TELEMETRY_MODE_LABEL INIT(= {"TELEMETRY_MODE = "});
static char	*tlm_mode_names[MAX_TLM_MODES] 
			= {"MERGED","REALTIME","PLAYBACK"};
ALLOC char*   WSE_FILTER_LABEL INIT(= {"WSE_FILTER = "});
/*******************************************************/
/* parameters used by channel group query 	       */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Channel Group Offsets */
enum	{CG_CHANNEL_SET,
	 CG_SAMPLE_MODE,
	 CG_COMPRESS_HEADER,
	 CG_DELTA_TIME,
	 CG_FREQUENCY,
	 MAX_CG_FIELDS};
ALLOC   short			cg_indicators[MAX_CG_FIELDS];
ALLOC char*   CHANNEL_SET_LABEL INIT(= {"CHANNEL_SET = "});
/* sample mode indicies */
enum	{SAMPLE_ON_SAMPLE,
	 SAMPLE_ON_CHANGE,
	 SAMPLE_CHANGE_ONLY,
	 SAMPLE_DELTA_TIME,
	 SAMPLE_FREQUENCY,
	 MAX_SAMPLE_MODES};
ALLOC char*   SAMPLE_MODE_LABEL INIT(= {"SAMPLE_MODE = "});
ALLOC int       		sample_mode_index;
static char	*sample_mode_names[MAX_SAMPLE_MODES] =
			{"ON_SAMPLE","ON_CHANGE","CHANGES_ONLY",
				"DELTA_TIME","FREQUENCY"};
ALLOC char 			compress_headers[5];
ALLOC char*   TIME_DELTA_LABEL INIT(= {"TIME_DELTA = "});
ALLOC char*   FREQUENCY_LABEL INIT(= {"FREQUENCY = "});

#define COMMA                   ","
#define SEMI_COLON              ";"
#define OPEN_BRACE              "{"
#define CLOSE_BRACE             "}"
#define NEW_LINE		0x0a
ALLOC char	new_line;

/* TDS Query Buffer */
#define MAX_TDS_QUERY_LENGTH	800
ALLOC char 			tds_query_buffer[MAX_TDS_QUERY_LENGTH];
ALLOC int  			tds_query_length;
ALLOC int  			tds_query_sent;
ALLOC int  			tds_query_ready;

/* pointer to SFDU received from TDS */
ALLOC char			*sfdu_pointer;

/* buffer for data received from TDS */
union data_rcvd{
		ubyte		byte_buffer[MAX_SFDU_LENGTH];
		unsigned short	short_buffer[MAX_SFDU_LENGTH/2];
	      };
ALLOC union data_rcvd 		input_data;

ALLOC int 			record_count;

enum  {ALL_ENG,CE10,CE40,SM10,SM40,SM12,CA10,CA40,SA10,SA40,SA12,CC10,
       CC40,CC12,FD10,FD40,FD12,FD72,MN40,MAX_ENG_TYPES};
static char* eng_types[MAX_ENG_TYPES] = {"eng",
                            "eng_ce10", "eng_ce40", "eng_sm10", "eng_sm40",
                            "eng_sm12", "eng_ca10", "eng_ca40", "eng_sa10",
                            "eng_sa40", "eng_sa12", "eng_cc10", "eng_cc40",
                            "eng_cc12", "eng_fd10", "eng_fd40", "eng_fd12",
                            "eng_fd72", "eng_mn40"};
ALLOC int eng_selected[MAX_ENG_TYPES];

enum   {ALL_ENG_SFDUS,CE10_SFDUS,CE40_SFDUS,SM10_SFDUS,SM40_SFDUS,
        SM12_SFDUS,CA10_SFDUS,CA40_SFDUS,SA10_SFDUS,SA40_SFDUS,SA12_SFDUS,
        CC10_SFDUS,CC40_SFDUS,CC12_SFDUS,FD10_SFDUS,FD40_SFDUS,FD12_SFDUS,
	FD72_SFDUS,MN40_SFDUS,MAX_ENG_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into eng_types */
	char*		ddp_id;
        } eng_sfdus[MAX_ENG_SFDUS] = {
        {2,128,0,128,0,1,"C200"},
        {2,129,0,128,0,2,"C200"},
        {2,128,0,129,0,3,"C201"},
        {2,129,0,129,0,4,"C201"},
        {2,130,0,129,0,5,"C201"},
        {2,128,0,130,0,6,"C202"},
        {2,129,0,130,0,7,"C202"},
        {2,128,0,131,0,8,"C203"},
        {2,129,0,131,0,9,"C203"},
        {2,130,0,131,0,10,"C203"},
        {2,128,0,132,0,11,"C204"},
        {2,129,0,132,0,12,"C204"},
        {2,130,0,132,0,13,"C204"},
        {2,128,0,133,0,14,"C205"},
        {2,129,0,133,0,15,"C205"},
        {2,130,0,133,0,16,"C205"},
	{2,131,0,133,0,17,"C205"},
	{2,129,0,134,0,18,"C365"}};

enum  {ALL_CHENG,CH_CE10,CH_CE40,CH_SM10,CH_SM40,CH_SM12,CH_CA10,CH_CA40,
	CH_SA10, CH_SA40,CH_SA12,CH_CC10,CH_CC40,CH_CC12,CH_FD10,CH_FD40,
	CH_FD12,CH_FD72,CH_MN40,MAX_CH_ENG_TYPES};

ALLOC int	cheng_selected[MAX_CH_ENG_TYPES];

static char* ch_eng_types[MAX_CH_ENG_TYPES] =
       {"cheng","ch_eng_ce10", "ch_eng_ce40", "ch_eng_sm10", "ch_eng_sm40",
        "ch_eng_sm12", "ch_eng_ca10", "ch_eng_ca40", "ch_eng_sa10",
        "ch_eng_sa40", "ch_eng_sa12", "ch_eng_cc10", "ch_eng_cc40",
        "ch_eng_cc12", "ch_eng_fd10", "ch_eng_fd40", "ch_eng_fd12",
        "ch_eng_fd72", "ch_eng_mn40"};

enum	{CH_CE10_SFDU,CH_CE40_SFDU,CH_SM10_SFDU,CH_SM40_SFDU,CH_SM12_SFDU,
	CH_CA10_SFDU,CH_CA40_SFDU,CH_SA10_SFDU,CH_SA40_SFDU,CH_SA12_SFDU,
	CH_CC10_SFDU,CH_CC40_SFDU,CH_CC12_SFDU,CH_FD10_SFDU,CH_FD40_SFDU,
	CH_FD12_SFDU,CH_FD72_SFDU,CH_MN40_SFDU,MAX_CH_ENG_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into ch_eng_types */
	char*		ddp_id;
        } ch_eng_sfdus[MAX_CH_ENG_SFDUS] = {
        {11,128,0,128,0,1,"C227"},
        {11,128,0,129,0,2,"C227"},
        {11,129,0,128,0,3,"C228"},
        {11,129,0,129,0,4,"C228"},
        {11,129,0,130,0,5,"C228"},
        {11,130,0,128,0,6,"C229"},
        {11,130,0,129,0,7,"C229"},
        {11,131,0,128,0,8,"C230"},
        {11,131,0,129,0,9,"C230"},
        {11,131,0,130,0,10,"C230"},
        {11,132,0,128,0,11,"C231"},
        {11,132,0,129,0,12,"C231"},
        {11,132,0,130,0,13,"C231"},
        {11,127,0,128,0,14,"C261"},
        {11,127,0,129,0,15,"C261"},
        {11,127,0,130,0,16,"C261"},
        {11,127,0,131,0,17,"C261"},
	{11,135,0,129,0,18,"C266"}};
	
enum	{CHCCS_SFDU,MAX_CHCCS_SFDUS};
static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into data_type_names */
	char*		ddp_id;
        } chccs_sfdus = {11,133,0,0,0,10,"C232"};

enum  {ALL_SCI,CR5A,UV5A,CR7A,GS08,GS10A,GS10,LRS,HRS,GSE,
       CRS,LECP,MAG,PLS,PRA,PWS,UVS,MAX_SCI_TYPES};
static char* sci_types[MAX_SCI_TYPES] = 
		{"sci","lrs_cr5A","lrs_uv5A","lrs_cr7A",
                 "hrs_gs08","hrs_gs10A","hrs_gs10","lrs","hrs","gse",
		 "crs","lecp","mag","pls","pra","pws","uvs"};

ALLOC	int sci_selected[MAX_SCI_TYPES];

enum  {CR5A_SFDU,UV5A_SFDU,CR7A_SFDU,GS08_SFDU,GS10_SFDU,GS10A_SFDU,
       CRS_CR5A_SFDU,CRS_CR7A_SFDU,CRS_GS08_SFDU,CRS_UV5A_SFDU,
	LECP_CR5A_SFDU,LECP_CR7A_SFDU,
       LECP_GS08_SFDU,LECP_UV5A_SFDU,MAG_CR5A_SFDU,MAG_CR7A_SFDU,MAG_GS08_SFDU,
       MAG_UV5A_SFDU,PLS_CR5A_SFDU,PLS_CR7A_SFDU,PLS_GS08_SFDU,PLS_UV5A_SFDU,
       PRA_CR5A_SFDU,PRA_CR7A_SFDU,PRA_GS08_SFDU,PRA_UV5A_SFDU,PWS_CR5A_SFDU,
       PWS_CR7A_SFDU,PWS_GS08_SFDU,PWS_UV5A_SFDU,UVS_CR5A_SFDU,UVS_CR7A_SFDU,
       UVS_GS08_SFDU,UVS_UV5A_SFDU,MAX_SCI_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into sci_types */
	char*		ddp_id;
        } sci_sfdus[MAX_SCI_SFDUS] = {
        {3,128,0,0,0,1,"C220"},
        {3,129,0,0,0,2,"C221"},
        {3,130,0,0,0,3,"C222"},
        {4,128,0,128,0,4,"C223"},
        {4,128,0,129,0,5,"C224"},
        {4,128,0,130,0,6,"C225"},
	{9,21,0,128,0,10,"C241"},
	{9,21,0,129,0,10,"C242"},
	{9,21,0,130,0,10,"C243"},
	{9,21,0,131,0,10,"C281"},
	{9,25,0,128,0,11,"C244"},
	{9,25,0,129,0,11,"C245"},
	{9,25,0,130,0,11,"C246"},
	{9,25,0,131,0,11,"C282"},
	{9,35,0,128,0,12,"C247"},
	{9,35,0,129,0,12,"C248"},
	{9,35,0,130,0,12,"C249"},
	{9,35,0,131,0,12,"C283"},
	{9,32,0,128,0,13,"C250"},
	{9,32,0,129,0,13,"C251"},
	{9,32,0,130,0,13,"C252"},
	{9,32,0,131,0,13,"C284"},
	{9,22,0,128,0,14,"C253"},
	{9,22,0,129,0,14,"C254"},
	{9,22,0,130,0,14,"C255"},
	{9,22,0,131,0,14,"C285"},
	{9,23,0,128,0,15,"C256"},
	{9,23,0,129,0,15,"C257"},
	{9,23,0,130,0,15,"C258"},
	{9,23,0,131,0,15,"C286"},
	{9,24,0,128,0,16,"C266"},
	{9,24,0,129,0,16,"C267"},
	{9,24,0,130,0,16,"C268"},
	{9,24,0,131,0,16,"C287"}};

enum  {ALL_CHSCI,CH_GSE,CH_CR5,CH_CR7,MAX_CHSCI_TYPES};
static char* chsci_types[MAX_CHSCI_TYPES] = 
			{"chsci","ch_gse","ch_cr5","ch_cr7"};
ALLOC	int	chsci_selected[MAX_CHSCI_TYPES];

enum   {CH_GSE_SFDU,CH_CR5_SFDU,CH_CR7_SFDU,MAX_CH_SCI_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into ch_sci_types */
	char*		ddp_id;
        } ch_sci_sfdus[MAX_CH_SCI_SFDUS] = {
	{11,134,0,128,0,1,"C233"},
	{11,134,0,129,0,2,"C234"},
	{11,134,0,130,0,3,"C235"}};

enum  {ALL_MON,MON_BLK1,MON_BLK2,MON_BLK3,MON_BLK4,MAX_MON_TYPES};
static char* mon_types[MAX_MON_TYPES] = {"mon",
       "gif_mon_block1", "gif_mon_block2", "gif_mon_block3","gif_mon_block4"};

ALLOC	int mon_selected[MAX_MON_TYPES];

enum  {BLK1_SFDU,BLK2_SFDU,BLK3_SFDU,BLK4_SFDU,MAX_MON_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into mon_types */
	char*		ddp_id;
        } mon_sfdus[MAX_MON_SFDUS] = {
	{6,1,0,128,0,1,"C264"},
	{6,1,0,129,0,2,"C264"},
	{6,1,0,130,0,3,"C264"},
	{6,1,0,131,0,4,"C264"}};

static char* chmon_types[MAX_MON_TYPES] = {"chmon","ch_gif_mon_block1",
                 "ch_gif_mon_block2", "ch_gif_mon_block3","ch_gif_mon_block4"};

ALLOC	int	chmon_selected[MAX_MON_TYPES];

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into chmon_types */
	char*		ddp_id;
        } chmon_sfdus[MAX_MON_SFDUS] = {
	{11,2,0,128,0,1,"C265"},
	{11,2,0,129,0,2,"C265"},
	{11,2,0,130,0,3,"C265"},
	{11,2,0,131,0,4,"C265"}};

enum  {ALL_IMG,GS4B,GS4C,MAX_IMG_TYPES};
static char* img_types[MAX_IMG_TYPES] = {"img","hrs_gs4B","hrs_gs4C"};

ALLOC	int	img_selected[MAX_IMG_TYPES];

enum  {GS4B_SFDU,GS4C_SFDU,MAX_IMG_SFDUS};
static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into img_types */
	char*		ddp_id;
        } img_sfdus[MAX_IMG_SFDUS] = {
        {4,130,0,0,0,1,"C226"},
        {4,130,0,0,0,2,"C218"}};

enum  {ALL_TP,TP_CR5T,TP_UV5T,TP_EH24,TP_GS08,TP_CE10,TP_SM10,TP_CA10,
       TP_SA10,TP_CC10,TP_FD10,TP_EHR,TP_GS9,MAX_TP_TYPES};

static char* tp_types[MAX_TP_TYPES] = 
			{"tp","cr5t_tf","uv5t_tf","eh24t_tf","gs08t_tf",
                         "ce10t_tf", "sm10t_tf", "ca10t_tf", "sa10t_tf",
                         "cc10t_tf", "fd10t_tf", "ehrht_tf", "gs9t_tf"};
ALLOC	int	tp_selected[MAX_TP_TYPES];

enum  {CR5RT_SFDU,UV5RT_SFDU,EH24RT_SFDU,GS08RT_SFDU,CR5T_SFDU,UV5T_SFDU,
       EH24T_SFDU,GS08T_SFDU,CE10T_SFDU,SM10T_SFDU,CA10T_SFDU,SA10T_SFDU,
       CC10T_SFDU,FD10T_SFDU,EHRHT_SFDU,GS9T_SFDU,PB16TR_SFDU,PB16T_SFDU,
       MAX_TP_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into tp_types */
	char*		ddp_id;
        } tp_sfdus[MAX_TP_SFDUS] = {
        {7,128,0,128,0,1,"C272"},
        {7,130,0,128,0,2,"C273"},
        {7,131,0,131,0,3,"C274"},
        {7,131,0,132,0,4,"C275"},
        {7,128,0,0,0,1,"C206"},
        {7,130,0,0,0,2,"C207"},
        {7,131,0,128,0,3,"C208"},
        {7,131,0,130,0,4,"C209"},
        {7,132,0,128,0,5,"C210"},
        {7,132,0,129,0,6,"C211"},
        {7,132,0,130,0,7,"C212"},
        {7,132,0,131,0,8,"C213"},
        {7,132,0,132,0,9,"C214"},
        {7,132,0,133,0,10,"C215"},
        {7,133,0,128,0,11,"C216"},
        {7,133,0,129,0,12,"C217"},
        {5,128,0,128,0,0,"C276"},
        {5,128,0,0,0,0,"C219"}};

enum {ALL_MRO,CCS_MRO,AACS_MRO,MAM_MRO,FDS_MRO,AACSMAM_MRO,MAX_MRO_TYPES};

static char* mro_types[MAX_MRO_TYPES] = 
		{"mro","ccsmro","aacsmro","mammro","fdsmro","aacsmam_nosync"};

ALLOC	int	mro_selected[MAX_MRO_TYPES];

enum {CCS_MRO_SFDU,AACS_MRO_SFDU,MAM_MRO_SFDU,FDS_MRO_SFDU,AACSMAM_MRO_SFDU,
      MAX_MRO_SFDUS};

static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into mro_types */
	char*		ddp_id;
        } mro_sfdus[MAX_MRO_SFDUS] = {
        {10,128,0,0,0,1,"C236"},
        {10,129,0,128,0,2,"C237"},
        {10,129,0,129,0,3,"C238"},
        {10,130,0,0,0,4,"C239"},
        {10,131,0,0,0,5,"C260"}};
/*****************************************************************/
/* The following refer to TDS channelized records(as opposed     */
/* to TIS channelized records).                                  */
/*****************************************************************/
enum    {TDS_ON_SAMPLE,TDS_ON_CHANGE,TDS_FREQUENCY,TDS_TIME_DELTA,
         TDS_EXP_ON_SAMPLE,TDS_EXP_ON_CHANGE,
         TDS_EXP_FREQUENCY,TDS_EXP_TIME_DELTA,MAX_TDS_CHANNELIZED_SFDUS};

static  char*   tds_channelized_names[MAX_TDS_CHANNELIZED_SFDUS] = {
        "TDS on sample","TDS on change","TDS Frequency","TDS time delta",
        "TDS on sample EXP","TDS on change EXP",
        "TDS frequency EXP","TDS time delta EXP"};
static  struct {
        unsigned char   sfdu_id[4];/* major,minor,mission,format */
        int             rcvd;/* SFDUS recvd */
        int             dt_index;/* index into tds_channelized_names */
	char*		ddp_id;
        } tds_channel_sfdus[MAX_TDS_CHANNELIZED_SFDUS] = {
        {11,5,0,1,0,0,"C270"},
        {11,5,0,2,0,1,"C270"},
        {11,5,0,3,0,2,"C270"},
        {11,5,0,4,0,3,"C270"},
        {11,5,0,5,0,4,"C271"},
        {11,5,0,2,0,6,"C271"},
        {11,5,0,3,0,7,"C271"},
        {11,5,0,4,0,8,"C271"}};

static  struct sfdu_struct{
        unsigned char   sfdu_id[4];/* major,minor,format */
        int             rcvd;
        int             dt_index;/* index into *_types */
	char*		ddp_id;
        };
/***********************************************/
/* These entries represent all TDS data types  */
/* including TDS channelized records.          */
/***********************************************/
/* MAX_DATA_TYPES + TDS CHANNELIZED DATA TYPES */
#define MAX_TDS_TYPES   MAX_DATA_TYPES+1
static  struct  {
        int     num_sfdu_types;
        struct  sfdu_struct     *sfdus;
        char    **name_list;
        } frame_sfdus[MAX_TDS_TYPES] = {
        {MAX_ENG_SFDUS,(struct sfdu_struct*)eng_sfdus,eng_types},
        {MAX_CH_ENG_SFDUS,(struct sfdu_struct*)ch_eng_sfdus,ch_eng_types},
        {MAX_SCI_SFDUS,(struct sfdu_struct*)&sci_sfdus,sci_types},
        {MAX_CH_SCI_SFDUS,(struct sfdu_struct*)ch_sci_sfdus,chsci_types},
        {MAX_MON_SFDUS,(struct sfdu_struct*)mon_sfdus,mon_types},
        {MAX_MON_SFDUS,(struct sfdu_struct*)chmon_sfdus,chmon_types},
        {MAX_QQC_SFDUS,(struct sfdu_struct*)qqc_sfdus,qqc_types},
        {MAX_QQC_SFDUS,(struct sfdu_struct*)ch_qqc_sfdus,ch_qqc_types},
        {MAX_IMG_SFDUS,(struct sfdu_struct*)img_sfdus,img_types},
        {MAX_TP_SFDUS,(struct sfdu_struct*)tp_sfdus,tp_types},
        {MAX_CHCCS_SFDUS,(struct sfdu_struct*)&chccs_sfdus,data_type_names},
        {MAX_MRO_SFDUS,(struct sfdu_struct*)mro_sfdus,mro_types},
        {MAX_TDS_CHANNELIZED_SFDUS,(struct sfdu_struct*)tds_channel_sfdus,
        					tds_channelized_names}};

ALLOC   int     unknown_sfdus_rcvd;
ALLOC   int     testbed_query;
