/* voyager data fetch : data_fetch.c */
/* this routine uses the TED library */
/* to retrieve data from the TDS     */
/* Original:  8-8-1996               */
/* revised:  4-16-2021 - Ray Bambery */ 
/* Normally run on Shock under nertops account */

#undef		_TED_INIT_
#include	"vgr_tds_if.h"
#include	"ted.h"

#include	<stdio.h>
#include 	<stdlib.h>
#include  <errno.h>     /* added 4-16-2021 */
#include <fcntl.h>      /* added 4-16-2021 */
 
/* Not technically required, but needed on some UNIX distributions */
/* 4-16-2021 - RJB */
#include <sys/types.h>
#include <sys/stat.h>s
/* these externs in ted_tds_if.c located in libted.a */
extern	void	initializeTedNonMotifCommon(int);
extern	int	    openDataSource(char*,int);
extern  void 	buildTdsFrameQuery(char*,char*,char*,char*,char*,char*,
					char*,char*,char*);
extern  int	    writeQueryToTds(void);
extern  char*	processTdsData(void);
extern	void	closeInputFileDescriptor(void);
#define		LABEL_LENGTH	20

//int open(const char *path, int oflags, mode_t mode);

main(argc,argv)
int	argc;
char	**argv;
{
FILE*	file_desc;
int	    sc_id,func_stat;
char	tds_source[5];
char	*tds_host;
char	*data_path;
char	*data_ptr;
char	file_name[200];
int	    record_length;

tds_host = getenv("TDS_HOST");
if (tds_host == NULL)
   {
   printf("data_fetch: Environment variable TDS_HOST not set!\n");
   printf("TDS_HOST should specify the name of the TDS host.\n");
   exit(0);
   }
/* setup TDS IF */
initializeTedNonMotifCommon(0);

/* added 4-18-2021 - removed 5-27-2021*/
/* different from data_fetch.c and build_edr.c dated Aug 8, 1996 
query_capture=1;
//S_IRGRP  S_IWGRP  S_IXGRP
query_log_file = open("/home/rjb/fetch/tds_query",O_CREAT|O_RDWR,S_IRUSR|S_IWUSR|S_IXUSR);

printf ("Error no is : %d\n", errno);
if (query_log_file ==-1)
    {
        // print which type of error have in a code
        printf("Error Number % d\n", errno); 
                         
        // print program detail "Success or failure"
                    perror("Program");                 
     }
printf ("query_log_file = %d\n",query_log_file);
if (query_log_file<0)
   {
   printf("unable to open TDS Query log file\n");
   exit(0);
   }
    printf ("data_fetch: befor openDataSource\n");
// completion of difference */
func_stat = openDataSource(tds_host,6666);

if (func_stat == 0)
   {
   if (argc < 8)
      file_desc = stdout;
   else
      {/* open data file */
      data_path = getenv("DATA_PATH");
      if (data_path == NULL)
         {
         printf("data_fetch: Environment variable DATA_PATH not set!\n");
         printf("DATA_PATH should specify the path of the disk cache.\n");
         exit(0);
         }
      strcpy(file_name,data_path);
      strcat(file_name,argv[7]);
      file_desc = fopen((const char*)file_name,"w");
      if (!file_desc)
         {
         printf("data_fetch: fopen of file %s failed\n",file_name);
         perror("data_fetch");
         exit(0);
         }
      }
   if ((strcmp(argv[4],"now") == 0 || strcmp(argv[4],"NOW") == 0) &&
       (strcmp(argv[5],"forever") == 0 || strcmp(argv[5],"FOREVER") == 0))
      strcpy(tds_source,"{RT");
   else
      strcpy(tds_source,"{NERT");
   printf("tds sc=%s data type=%s time start=%s end=%s time type=%s order=%s\n",argv[1],argv[2],
	argv[4],argv[5],argv[3],argv[6]);
   printf("data file = %s\n",file_name);
   buildTdsFrameQuery("DMT","VOYAGER",argv[1],argv[3],argv[4],argv[5],argv[6],
			tds_source,argv[2]);
   processTdsQuery(NULL);
//    processTdsQuery(query_log_file);
   while (1)
      {
      data_ptr = processTdsData();
//    printf ("data_ptr = %x\n",data_ptr);
      if (data_ptr == (char*)-1)
         {
         closeInputFileDescriptor();
         break;
         }
      else
         {
         if (data_ptr)
            {/* data rcvd */
            /* determine length of record */
            memcpy((void*)&record_length, (void*)(data_ptr+16),4);
            record_length += LABEL_LENGTH;
            /* output record */
            fwrite(data_ptr,sizeof(char),record_length,file_desc);
            }
         else
            {
            sleep(1);
            }
         }
      }  // while()
   }  // func_stat
    /* 4-18-2021 - if func_stat fails */
   if (func_stat != 0) {
        printf("data_fetch:  openDataSource return -  func_stat = %d\n",func_stat);
        printf ("Error no is : %d\n", errno);
    }
}          


