/* voyager data fetch : data_fetch.c */
/* this routine uses the TED library */
/* to retrieve data from the TDS     */


#undef		_TED_INIT_
#include	"vgr_tds_if.h"
#include	"ted.h"

#include	<stdio.h>
#include 	<stdlib.h>
extern	void	initializeTedNonMotifCommon(int);
extern	int	openDataSource(char*,int);
extern  void 	buildTdsFrameQuery(char*,char*,char*,char*,char*,char*,
					char*,char*,char*);
extern  int	writeQueryToTds(void);
extern  char*	processTdsData(void);
extern	void	closeInputFileDescriptor(void);
#define		LABEL_LENGTH	20
#define isleapyear(year) (((year)%400==0)||(((year)%100!=0)&&((year)%4==0)))

main(argc,argv)
int	argc;
char	**argv;
{
FILE*	data_file_desc;
FILE*	log_file_desc;
int	sc_id,func_stat;
char	tds_source[5];
char	*tds_host;
char	*dp;
char	data_path[130];
char	log_file_path[120];
char	*sc;
char	sc_name[100];
char	*data_ptr;
char	data_file_name[80],log_file_name[200];
char	data_types[80];
char	command_line[400];
char	end_time_string[25];
char	start_time_string[25];
int	record_length,year_int,doy_int;
struct timeval time_struct;
struct timezone time_zone_struct;
struct tm *gmt_time_struct_ptr;
/* return values */
int time_stat;

int string_length;

if (argc < 6)
   {
   printf("Insufficient Parameters Entered, must use the following parameters\n");
   printf("cron_query Spacecraft TDS_HOST DATA_PATH DataTypes\n");
   exit(0);
   }

sprintf(sc_name,"TDS_HOST=%s",argv[2]);
if (putenv(sc_name))
   { 
   perror("cron_query:putenv failed");
   exit(0);
   }
sc = getenv("TDS_HOST=");
printf("TDS_HOST=%s\n",sc);

string_length=strlen(argv[3]);
if (string_length >= 120)
   {
   printf("DATA PATH PARAMETER EXCEEDS MAXIMUM LENGTH(120 characters)\n");
   exit(0);
   }
/* check data_fetch path for trailing slash */
string_length = strlen(argv[5]);
if (argv[5][string_length-1] == '/')
   argv[5][string_length-1]=NULL;

/* set environment variable */
sprintf(data_path,"DATA_PATH=%s",argv[3]);
/* set log file path */
strcpy(log_file_path,argv[3]);
if (putenv(data_path))
   { 
   perror("cron_query:putenv failed");
   exit(0);
   }

/* append a slash if needed */
if (argv[3][string_length-1] != '/')
   {
   strcat(data_path,"/");
   strcat(log_file_path,"/");
   }
   

dp = getenv("DATA_PATH=");
printf("DATA_PATH=%s\n",dp);

/* update time display field in main window */
gettimeofday(&time_struct,&time_zone_struct);
gmt_time_struct_ptr = gmtime(&time_struct.tv_sec);
if (gmt_time_struct_ptr EQ NULL)
   {
   perror("gmtime failed\n");
   exit(0);
   }

/*process day of year*/
time_stat = strftime(start_time_string, 4, "%j", gmt_time_struct_ptr);
if (time_stat <= 0)
   {/* results are not usable */
   perror("strftime failed");
   exit(0);
   }
doy_int = atoi(start_time_string);
/* process year*/
time_stat = strftime(start_time_string, 5, "%Y", gmt_time_struct_ptr);
if (time_stat <= 0)
   {/* results are not usable */
   perror("strftime failed");
   exit(0);
   }
year_int = atoi(start_time_string);

if (doy_int == 1)
   {/*query is for last day of previous year*/
   doy_int = ( isleapyear(year_int) ? 366 : 365 );
   }
else
   {/* query for previous day */
   doy_int--;
   }
if (doy_int > 364)
   {/* query is for last day of previous year */
   year_int--;
   }

/* initialize data file */
sprintf(data_file_name,"%s_%d-%d.data",argv[1],year_int,doy_int);

/* initialize log file */
sprintf(log_file_name,"%s%s_%d-%d.log",log_file_path,argv[1],year_int,doy_int);

sprintf(start_time_string,"%d-%dT00:00:00.000",year_int,doy_int); 
sprintf(end_time_string,"%d-%dT23:59:59.999",year_int,doy_int); 
printf("tds sc=%s time start=%s end=%s log file=%s data file =%s\n",argv[1],start_time_string,end_time_string,log_file_name,data_file_name);
sprintf(command_line,"%s/data_fetch %s %s ERT %s %s ERT %s > %s\n"
      ,argv[5],argv[1],argv[4],start_time_string,end_time_string,data_file_name,log_file_name);
printf("%s",command_line);
system(command_line);
}          


