/* crs1.c 
 * program to create .act and .bct files from the crs_edr produced from
 * program  vgr_edr
 * These are text files are used to create postscript file of of crs data
 *
 * crs1.c is main routine: it is linked with the following
 *      to use with both spacecraft
 *      calcurn.c is for VGR1
 *      calcurn32.c is for VGR2
 * see: MAKE_CRS_31 and MAKE_CRS_32
 * 
 *      command: crs1 crs_edr
 *
 *      input:
 *          crs_edr
 *      outputs:
 *  1 - crs_edr.act or crs_edr.bct
 *  2 - crsout.a or crsout.b
 *  3 - crsout2.a or crsout2.b - where used? 
 *
 * in its original form in 1997 it calls two commands in routine finish():
 *  cmd1a  - enscript command for PS file from crsout.a
 *  cmd1b  - enscript command for PS file from crsout.b
 *  cmd2  - lpr command to printer 
 *  They have been commented out in this version
 *
 * See Ronald Hungerford Memo (crs1.README) - dated 1997-09-23 - modified 2000-01-06
 * History:
 *
 * - 1997-08-20 from shock2::jyin directory (/ftp_FILES/VGR2/crs/jyin)
 *          Solaris 5.2 
 *   2021-10-13 - Ray Bambery - original source code crashes on Solaris 10.4
 *                      and Centos7 
 *   2021-10-19 - Ray Bambery - modified for Centos7 
 *                     crashes in do while loop - confusing logic
 *   2021-10-21 - Ray Bambery - updated internal doc, fix crashes
 *                  via gdb debugger on Centos7
 *                  This routine incorporates changes introduced
 *                  with crs12000.c dated Jan 6, 2000
*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>            /* hard code mode = 4 cr5 " */
#include <string.h>
#include <math.h>
#define true  1
#define false 0
#include "crs.h"

/* prototypes */
void finish(void);
void write_hd_info(FILE *out);
void write_record(void);
void write_page_header(FILE *out0);
void position_cr(void);
void position_gs(void);
void read_header(void);
void read_subheader(void);
void write_subheader(void);
void read_science(void);
//FILE *setup_file(char *msg, char *type);
long get_logcomp(unsigned short *bp);
void calc_time(void);
void find_mode(void);


FILE            *in, *out, *out2, *outct31, *outct32;
unsigned char   idata[1000];
unsigned long   record_type, sc_id, x2 = 1;
int             resett, rate_offset, new_rec = 1, state = 0, p = 0, r = 0, i;
int             first_rec = 1;
unsigned short  sub_head[40], pha[2000], dn1[480];
float           renorm, urns[114];
unsigned int    mod16,line_count, seg_no;
char            mod60, mode;
static char     _ch ;
char   		sc[4], *sc_, *mode_, str1[40];
int    dmode, ertd, erds, erhs, ert, erys,null_counter=0, tet_counter=0,
       summary_counter=0,erth, hod, ertm, ertmn, erts, erms, yr,
       sceth, scethod, scetm, scetmn, scets, scetd;

FILE *setup_file();
long get_logcomp();
double calcurn();

/* ------------------------------- */
/*            Main                 */
/* ------------------------------- */
main(argc, argv)
int argc;
char *argv[];
{

   int last_ch;    //last character, either "a" or "b"

   if (argc < 2){
      printf("usage:  crs1 infile\n");
      exit(0);
   }
/* added error message - 10-20-2021 - rjb */
/* crashes without it                   */
   in   = fopen(argv[1],"r");
    if (in == NULL) {
        printf ("input file %s NOT FOUND\n",in);
        exit (1);
    } else {
//        printf ("main: *in = %p\n",in);
    }
    last_ch = strlen(argv[1]);
//    printf ("last_ch = %c\n",argv[1][last_ch-1]);
    if (argv[1][last_ch - 1 ]=='a') {
        out = fopen("crsout.a","w");
        printf ("fopen crsout.a\n");
        out2  = fopen("crsout2.a","w");
    } else {
        out  = fopen("crsout.b","w");
        printf ("fopen crsout.b\n");
        out2  = fopen("crsout2.b","w");
    }
    
   sprintf(str1,"%sct",argv[1]);
   last_ch = strlen(argv[1]);
   if (argv[1][last_ch - 1]=='a')
       _ch = 'a';
   else
       _ch = 'b';

// printf("%s\n",&str1); 
   
   if (_ch == 'a') outct31  = fopen(str1,"w");
   else outct32  = fopen(str1,"w");
/*  OBSOLETED before 10-13-2021             
   in   = setup_file("DATA FILE TO OPEN : ","r");
   out  = setup_file("OUTPUT FILE TO OPEN : ","w");
*/
    printf ("fopen %s\n",str1);
//    printf ("mod60 = %d\n",mod60);
    printf ("find_mode()\n");
   find_mode();
   if (mode == 4) {
//    printf ("mod60 = %d\n",mod60);
//    printf ("mode =4\n");
      position_cr();
   } else {
//    printf ("mode else = %d\n",mode);
      position_gs();
/*  10-20-2021 - commented out next call */
//    printf ("find_mode() 2\n");
    }
   find_mode();
    printf ("write_page_header (out)\n");
   write_page_header(out);
    printf ("write_page_header(out2)\n");
   write_page_header(out2);
   if (_ch == 'a') write_page_header(outct31);
   else write_page_header(outct32);
//    printf ("in = %d\n",*in);
   while (!feof(in)){ 

      read_science();

      if (!resett){
         for (i=0;i<=479;i++) 
           dn[i] = get_logcomp(&dn1[i]);
/*         {   
           dn[i] = get_logcomp(&dn1[i]);
           printf("  %d= %8.4f  ",i,dn[i]);
         }
         printf("  \n");
*/
         if (mode!=4)
            renorm = 6.0;
         else 
            renorm = 48.0;
         for (i=1;i<=114;i++) 
            urn[i] = calcurn(i)/renorm;
         write_hd_info(out);
         if (_ch == 'a') write_hd_info(outct31);
         else write_hd_info(outct32);
         write_record();
         null_counter = 0;
         tet_counter  = 0;
         summary_counter = 0;
      }

      if ((mode == 4) && (state >= 6)){ 
        if (!feof(in)) position_cr();
      }
      if ((mode != 4) && (state >= 2)){ 
        if (!feof(in)) position_gs();
      }
   
   }
   finish();
}
/*************************************************************/
void finish(){
/* close crs_edr.act or crs_edr.bct and create PS output    */
/*  and print it                                            */
   fclose(in);
   fclose(out); 
   fclose(out2);
/* added 10-19-2021 - it crashes if wrong file is closed */ 
   if (_ch == 'a') {
        fclose(outct31);
        system("cmd1a");
//        system("cmd2a");
    } else {
        fclose(outct32);
        system("cmd1b");
        system("cmd2b");
    } 
//   system("cmd1");   //enscrypt command for graphic
//   system("cmd2");   // lpr command to printer
   exit(0);
}
/*************************************************************/
/* ------------------------------- */
void write_hd_info(out)FILE *out;{
/* ------------------------------- */
/* 10-21-2021 - added leading zeros according to Hungerford memo    */
/*     and crs1200.c (dated Jan 6, 2000)                           */
   fprintf(out,"\nERT:  %03d %2d:%02d:%02d   ",ertd,hod,ertmn,erts);
   fprintf(out,"SCET: %03d %2d:%02d:%02d   ",scetd,scethod,scetmn,scets);
   fprintf(out,"fdsc: %6d:%02d ",mod16,mod60);
}
/****************************************************************************/
/* ------------------------------- */
/*          Write Record           */
/* ------------------------------- */
void write_record(){

   fprintf(out,"         ");
   fprintf(out,"%8.4f     %8.4f     %8.4f       %8.4f\n",
               urn[3],urn[5],urn[12],urn[28]);
   fprintf(out2,"%3d %8.4f     %8.4f     %8.4f       %8.4f\n",
               ertd,urn[3],urn[5],urn[12],urn[28]);
if (_ch == 'a'){
   fprintf(outct31,"\n%12.4f %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f",
               urn[1],urn[5],urn[12],urn[16],urn[19],urn[28],urn[39],urn[43]);
   fprintf(outct31," %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f\n",
               urn[46],urn[63],urn[71],urn[87],urn[96],urn[100]);
   fprintf(outct31,"  Null: %d TET: %d SUMMARY: %d\n",null_counter, tet_counter,
               summary_counter); 
}else{
   fprintf(outct32,"\n%12.4f %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f",
               urn[1],urn[5],urn[12],urn[16],urn[27],urn[28],urn[39],urn[43]);
   fprintf(outct32," %12.4f %12.4f %12.4f %12.4f %12.4f %12.4f\n",
               urn[54],urn[63],urn[79],urn[87],urn[96],urn[100]);
   fprintf(outct32,"Null: %d TET: %d SUMMARY: %d\n",null_counter, tet_counter,
               summary_counter); 
}                
}
/**************************************************************************/
/* ------------------------------- */
/*       Write page  header        */
/* ------------------------------- */
void write_page_header(out0)FILE *out0;{

   fprintf(out0,"INSTRUMENT: CRS   ");
/* 10-21-2021 - added leading zeros according to hungerford memo    */
/*     and crs1200.c (dated Jan 6, 2000)                           */
   fprintf(out0,"\nYR: %02d     SC: %4s    MODE: %5s",yr,sc_,mode_);

if ((out0 == out) || (out0 == out2)){
   fprintf(out0,"                             ");
   fprintf(out0,"HET1: BSe(Z2)       PG           A1");
   fprintf(out0,"       HET2:AS(Z3)\n");
   fprintf(out0,"                                                                     ");
   fprintf(out0,"URN 3        URN 5        URN 12         URN 28\n\n");
}else{
   if (out0 == outct32){
   fprintf(out0,"\n\n");
   fprintf(out0,"   HET1:AS         PG           A1           B1           SB");
   fprintf(out0,"        HET2:AS         A1          B1            SB");
   fprintf(out0,"         LET:LA1        LC1          LD1");
   fprintf(out0,"        TET:TAN       GA+GB\n");
   }else{
   fprintf(out0,"\n\n");
   fprintf(out0,"   HET1:AS         PG           A1           B1           SB");
   fprintf(out0,"        HET2:AS         A1          B1            SB");
   fprintf(out0,"         LET:LA1        LB1          LD1");
   fprintf(out0,"        TET:TAN       GA+GB\n");
   }
   }
}
/***************************************************************************/
/* ------------------------------- */
/*       Position CRUISE File      */
/* ------------------------------- */
void position_cr(){
int flag = 1;
int ct;
/* 10-19-2021 - added typeA0 to simplify debugging crash in do while loop    */
int  typeA0;
    typeA0 = 0;
    ct=0;
    printf ("position_cr() Enter\n");  
//    printf ("yr = %d\n",yr); 
//    printf ("mod16%4 = %d\n",mod16%4);
//    printf ("mod60 = %d\n",mod60);

   do {
        ct++;
      read_header();
//    printf ("after read_header\n");
      read_subheader();
//        printf ("after read_subheader\n");
      calc_time();
//        printf ("after calc_time mod60 = %d mod16%4 = %d\n",mod60,mod16%4);
      fseek(in,3120L,1);
//        printf ("after fseek ct =%d\n",ct);
//  }

    if (feof(in)) {printf ("EOF!!\n");}

/* the followiing logic was added 10-19-2021 to simplify logic of the do        */
/* while loop below - It was crashing with SIGEV and logic of ! (nots) was      */
/* making debugging difficult                                                   */
    if (! (((mod16%4) == 0) && (mod60 ==  0))) {
//             printf("first case - true - mod16%4 == 0 && mod60 ==  0\n");
            typeA0 = 1;
        }
    if (! (((mod16%4) == 0) && (mod60 == 48))) { 
//            printf("Second case RecordType A - true - mod16%4 == 0 && mod60 ==  48\n");
            typeA0 = 1;
        }

    if (! (((mod16%4) == 1) && (mod60 == 36)))  { 
//            printf("Third case true - mod16%4 == 1 && mod60 == 36\n");
            typeA0 = 1;
        }
    if (! (((mod16%4) == 2) && (mod60 == 24))) { 
//            printf("Fourth case true - mod16%4 == 2 && mod60 ==  24\n");
            typeA0 = 1;
        }
    if (! (((mod16%4) == 3) && (mod60 == 12))) { 
//            printf("Fifth case true - mod16%4 == 3 && mod60 ==  12\n");
            typeA0 = 1;
        }
//        printf ("ct = %d\n",ct);
//    printf ("mod16%4 = %d - mod60 = %d\n",(mod16%4), mod60);
    }
// All of these are Record Type A

/* logic of crs1.c      */
/*    while(    
     (((yr < 90) ||
     !(((mod16%4) == 0) && (mod60 ==  0)) &&
     !(((mod16%4) == 0) && (mod60 == 48)) && 
     !(((mod16%4) == 1) && (mod60 == 36)) && 
     !(((mod16%4) == 2) && (mod60 == 24)) &&
     !(((mod16%4) == 3) && (mod60 == 12))) 
     ) && (!feof(in)));
*/

/* logic of crs12000.c   */
/*    while(            
     (yr < 90)  && (yr >30)  ||  (typeA0 == 0)  
     ! (((mod16%4) == 0) && (mod60 ==  0)) &&
     ! (((mod16%4) == 0) && (mod60 == 48)) && 
     ! (((mod16%4) == 1) && (mod60 == 36)) && 
     ! (((mod16%4) == 2) && (mod60 == 24)) &&
     ! (((mod16%4) == 3) && (mod60 == 12))

      && ( !feof(in)) 
     );{printf ("xxxx\n");}
*/

/*  New logic */
    while (
     (yr < 90)  && (yr >30)  ||  (typeA0 == 0)   
           && ( !feof(in)) 
     );{
//        printf ("xxxx\n");
       }


 //   printf ("...\n");
   fseek(in,-3400L,1);
   state  = 0;
    
}
/*************************************************************************/
/* ------------------------------- */
/*       Position GS File          */
/* ------------------------------- */
/* 10-20-2021 - THIS has not been debugged since there is no        */
/*              input file to test - it might fail in do while loop */
/*              If it does then you might try:                      */
/*              } while (( (yr < 90) && (yr > 30) ||                */
/*                  (mod60%2 !=0)) && (!feof(in)));                 */
void position_gs(){
int flag = 1;
   
   do{
      read_header();
      read_subheader();
      calc_time();
      fseek(in,2080L,1); 
  }while(((yr < 90) || (mod60%2 != 0)) && (!feof(in)));
  fseek(in,-2360L,1); 
  state  = 0;
}
/*************************************************************************/
/* ------------------------------- */
/*       Read Header               */
/* ------------------------------- */
/* CRS Records
*
615-306 Rev. D VOYAGER
EXPERIMENT DATA RECORD FORMAT SPEC1FICATION
Change 4 - 1 May 1986
Table C-9 - CR-5 - Pg C-114
Standard EDR Header items

Item 27 - word 9 - bits 31-16 MJS Mod 2^16 Count Word 
            contains the 16-bit MM subcom time word for this record
            It is incremented every 48-minutes
            Counts from 0 - 65535   
Item 28 - word 9 - Bits 15-8  MJS Mod 60 Count Word
            contains the modular 60 spacecraft time as created in FDS
            for the first minor frame received that is contained in
            this record - increments every 48-seconds.
            Counts from 0 - 59 
618-306_RevD_ch5

Attachement 2
CRS, PLS, AND PWS SEGMENTED RECORD IDENTIFICATION

CRS Records
Four CRS physical records are required
cycles. For convenience,the record types are labeled
A, B, C, and D.

Given Valid FDSC values,the following would hold:

RecordType      MOD 2^16       MOD60
    A               0           0,48 
                    1           36
                    2           24
                    3           12
    B               0           12
                    1           0,48 
                    2           36
                    3           24
    C               0           24
                    1           12
                    2           0,48 
                    3           36
    D               0           36
                    1           24
                    2           12
                    3           0,48
*/

void read_header(){
int i;
//crashes in fread - fixed 
   i = fread(&idata[1],1,240,in);
if (!i) finish();
   x2 = record_type = idata[4];
   record_type = (record_type & 0xf0)>>4; 
   seg_no = idata[16] & 0x0f;
   mode   = idata[7] & 0x0ff;
mode = 4;
   mod16  = (idata[33] << 8 | idata[34]) & 0x0ffff;
   mod60  = idata[35];
   if (mode == 0x18) mode = 4;
}
/*****************************************************************************/
/* ------------------------------- */
/*       Read Subheader            */
/* ------------------------------- */
void read_subheader(){
   fread(sub_head,1,40,in);
}
/****************************************************************************/
/* ------------------------------- */
/*      Write Subheader            */
/* ------------------------------- */
void write_subheader(){        /* binary or ???? */
int i,j;
   for (i=1; i<=4; i++){
      for (j=1; j<=10; j++) fprintf(out,"%x ",sub_head[i*10+j]);
      fprintf(out," \r ");
   }
}
/******************************************************************************/
/* ------------------------------- */
/*         Read Science            */
/* ------------------------------- */
void read_science(){
unsigned int buff[100], *pha_ptr, *rate_ptr;
int i, wrds, j, x = 7, d1;
unsigned char  d2;
char c;

   resett      = true;
   rate_offset = 240;    /* assume GS mode */
   new_rec     = 1;

   if (mode == 4){
      switch (state){
	 case 0:  rate_offset = 360;                resett = true;  break;
	 case 1:  rate_offset = 480;                resett = false; break;
	 case 2:  rate_offset = 240;  new_rec = 0;  resett = true;  break;
	 case 3:  rate_offset = 480;                resett = false; break;
	 case 4:  rate_offset = 120;  new_rec = 0;  resett = true;  break;
	 case 5:  rate_offset = 480;                resett = false; break;
	 default: break;
      }
   }else{
      if (state == 1){
         rate_offset = 480; 
         resett = false;
      }
   }

   state++;

   if (resett){
      p = 0; 
      r = 0;
   } 
   if (new_rec){
      read_header();
      read_subheader();
      calc_time();
   }
   do
      for (i=1; i<=10; i++){     /*  read 2 minor frames */
	 wrds = 1;
	 if ((i == 1) || (i == 6)) 
                wrds = 2;
		   fscanf(in,"%2c", &pha[p]); 
                   if (((pha[p]&0x0e)) == 0x0c) tet_counter++;
                   p++;
                   fscanf(in,"%2c", &pha[p]); 
                   if ((pha[p-1] == 0) && (pha[p] == 0)) null_counter++;
                   p++;
                   fscanf(in,"%2c", &pha[p++]);
                   fscanf(in,"%2c", &pha[p++]);
                   summary_counter++; 
	 for (j=1; j<=wrds; j++)
		   fscanf(in,"%2c", &dn1[r++]);
      }
   while (r <= rate_offset-1);    /* until end of record */
}
/***************************************************************************/
/* ------------------------------------ */
/*         File Setup                   */
/*  10-13-2021 - obsolete - Ray Bambery */
/* ------------------------------------ */
/*
FILE *setup_file(msg, type)char *msg, *type;{
char ffile[30];
FILE *f;

    printf ("setup_file Enter\n");
   printf("%s",msg);
   gets(ffile);
   if ((f = fopen(ffile,type)) == NULL) exit(0); 
   return f;
}
*/
/***************************************************************************/
/* ------------------------------- */
long get_logcomp(bp)       /* extract twelve bit patterns */
unsigned short *bp;                       /* pointer to leading byte */
                        /* starting bit position (bit-7 = MSB) */
{
    int l,bit=7;                      /* leading zeros */
    int b;                      /* mantissa */
    long rslt;                  /* resulting value */
 
    b = *bp&0xfff; 
    l = b >> 7;                 /* leading zeros */
    b &= 0x7f;                  /* mantissa */
 
    if ((l == 0) && (b == 0x7f)) {
        rslt = 0;
    } else if (l < 16 ) {
        rslt = ((0x101 | (b << 1)) << (15 - l)) ;
    } else if (l < 24) {
        rslt = (0x80 | b) >> (l - 16) ;
        rslt++;
    } else {
        rslt = 1;
    }
    return rslt;
}
/****************************************************************************/ 
/* ------------------------- */
void calc_time(){

   erth      = idata[9] << 8 | idata[10];
   ertd      = erth / 24;
   hod       = erth-24*ertd;
   ertm      = idata[11] << 8 | idata[12];
   ertmn     = ertm / 60;

   sceth     = idata[25] << 8 | idata[26];
   scetd     = sceth / 24;
   scethod   = sceth-24*scetd;
   scetm     = idata[27] << 8 | idata[28];
   scetmn    = scetm / 60;
   yr        = idata[31];
   erts      = ertm - 60*ertmn;
   scets     = scetm - 60*scetmn;
//    printf ("calc_time mod60 = %d\n",mod60);
}
/*******************************************************************************/
/* ------------------------- */
void find_mode(){
   int sc_id;

    printf ("mod60 = %d\n",mod60);
   read_header();
   calc_time();
   fseek(in,-240L,1); 
    printf ("mod60 =%d\n",mod60);
   if (mode == 0x1d)
      mode_  = "GS7";
   else{
      mode   = 4;  
      mode_  = "UV5";
   }
    printf ("find_mode = %d mode_ = %s\n",mode,mode_);
   sc_id = idata[4] & 0x01;
   if (sc_id == 0)       sc_  = "SC32";
   else if (sc_id == 1)  sc_  = "SC31";
   else                  sc_  = "ERROR";
}
