#include <stdio.h>
#include <string.h>

#include "s3_dhk.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct sshdhk testdata;
  int ii,jj,kk,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  numrec = init_rd_s3_dhk(hdf_fp, SD_id, "r");
  if(numrec <= 0) {
      fprintf(stderr,"No sepica s3_dhk data\n");
      exit(-1);
  }

  /* read and print data */
  ii=0;
  while((retval=read_s3_dhk(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %3d \n", ii++, testdata.sctime, testdata.QAC);
    printf("\tEDB=%2d SPINCNT=%8d SUNSECT=%6d REC=%4d SECT0=%4d\n",
	testdata.EDB, testdata.SPINCTR, testdata.SUNSECTOR,
	testdata.RECORDCTR, testdata.SECTOR0LEN);
  }

  /* all done, close HDF interface */

  close_rd_s3_dhk();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
