/* $Id: s3_spha.h,v 1.5 1997/09/05 22:31:18 jeff Exp $	     */
#include "hdfi.h"

#define SEP_PHA_CYCLEN   106
#define SEP_PHA_CYCPERSR  60

struct spha{
	uint32 sctime_readout;	/* 32 bit spacecraft time  */
	uint32 sctime_collection;/* 32 bit spacecraft time  */

	uint32 QAC;	/* number of frames missing in this SR */

	uint32 elements; /* Number of pha events in this structure. */
                 /* Should always be 6360(106*60) when concat is not 1. */

	uint8  concat; /* Sequence number for this struture will be */
		       /* greater than one for cases where the number of */
		       /* events exceeds the standard size.  In these cases */
		       /* concat will count down from N to 1, where N is */
			/* the total number of spha structure in this SR. */

	uint16 numevts[SEP_PHA_CYCPERSR];  /* number of events in EDB */

	uint8  range[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* range*/
	uint8  sector[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* sector*/
	uint8  fan[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* fan */
	uint8  sys[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* sys*/
	uint8  dZ[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/*  delta Z */
	uint16 E[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Energy*/
	uint8  Eg[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Energy gain bit */
	uint16 dE[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* delta Energy */
	uint8  dEg[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* delta Energy gain bit*/
	uint16 Y[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Y value */
};
