/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.48 1998/09/29 18:21:45 steves Exp  */

/* The include file used to create this file is: */
/* $Id: s3_spha.h,v 1.5 1997/09/05 22:31:18 jeff Exp  */

#include "s3_spha.h"
#include "mfhdf.h"
#include "df.h"

int32 vgrp_id_s3_spha;
static int32 vdata_id_s3_spha;

static int32 sds_id_s3_spha1, sds_id_s3_spha2, sds_id_s3_spha3, sds_id_s3_spha4, sds_id_s3_spha5, sds_id_s3_spha6, sds_id_s3_spha7, sds_id_s3_spha8, sds_id_s3_spha9, sds_id_s3_spha10;

  /* 1660 is the size of s3_spha.h + 1 added line */
char Vgrp_descrp_spha[1660];

/****----  init create function  ----****/

int32 init_cr_s3_spha(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;

  int32 sds_ref_w1, sds_ref_w2, sds_ref_w3, sds_ref_w4, sds_ref_w5, sds_ref_w6, sds_ref_w7, sds_ref_w8, sds_ref_w9, sds_ref_w10;
  int32 dim_sizes[2];
  int32 rank;

  int32 wr_Vgrp_desc_s3_spha();

  void print_s3_spha_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_s3_spha = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_s3_spha, "VG_spha"); 
  Vsetclass(vgrp_id_s3_spha, "VG_S3_SPHA");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_spha" )) ==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_s3_spha(Vgrp_descrp_spha);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_spha, sizeof(Vgrp_descrp_spha))) ==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_s3_spha = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_s3_spha, "spha");
  VSsetclass(vdata_id_s3_spha, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_s3_spha, vdata_id_s3_spha)) ==FAIL) {
    print_s3_spha_error("init_cr_s3_spha -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_s3_spha, "sctime_readout", DFNT_UINT32, (1) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define sctime_readout");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_spha, "sctime_collection", DFNT_UINT32, (1) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define sctime_collection");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_spha, "QAC", DFNT_UINT32, (1) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define QAC");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_spha, "elements", DFNT_UINT32, (1) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define elements");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_spha, "concat", DFNT_UINT8, (1) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define concat");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_spha, "numevts", DFNT_UINT16, (SEP_PHA_CYCPERSR) )) {
    print_s3_spha_error("init_cr_s3_spha -> VSfdefine: Couldn't define numevts");
    retval = -1;
  }

  if (VSsetfields(vdata_id_s3_spha,"sctime_readout, sctime_collection, QAC, elements, concat, numevts")){
    print_s3_spha_error("init_cr_s3_spha -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

 /*  Create SDS's and add to the Vgroup  */
  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha1 = SDcreate(sd_id, "spha_range", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_range");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w1 = SDidtoref(sds_id_s3_spha1)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_range");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w1)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_range to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha2 = SDcreate(sd_id, "spha_sector", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_sector");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w2 = SDidtoref(sds_id_s3_spha2)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_sector");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w2)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_sector to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha3 = SDcreate(sd_id, "spha_fan", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_fan");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w3 = SDidtoref(sds_id_s3_spha3)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_fan");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w3)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_fan to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha4 = SDcreate(sd_id, "spha_sys", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_sys");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w4 = SDidtoref(sds_id_s3_spha4)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_sys");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w4)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_sys to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha5 = SDcreate(sd_id, "spha_dZ", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_dZ");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w5 = SDidtoref(sds_id_s3_spha5)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_dZ");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w5)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_dZ to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha6 = SDcreate(sd_id, "spha_E", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_E");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w6 = SDidtoref(sds_id_s3_spha6)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_E");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w6)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_E to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha7 = SDcreate(sd_id, "spha_Eg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_Eg");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w7 = SDidtoref(sds_id_s3_spha7)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_Eg");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w7)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_Eg to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha8 = SDcreate(sd_id, "spha_dE", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_dE");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w8 = SDidtoref(sds_id_s3_spha8)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_dE");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w8)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_dE to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha9 = SDcreate(sd_id, "spha_dEg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_dEg");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w9 = SDidtoref(sds_id_s3_spha9)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_dEg");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w9)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_dEg to Vgrp");

  rank = 2;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if((sds_id_s3_spha10 = SDcreate(sd_id, "spha_Y", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDcreate: Couldn't create spha_Y");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w10 = SDidtoref(sds_id_s3_spha10)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> SDidtoref: Couldn't get ref for spha_Y");

  if((Vaddtagref(vgrp_id_s3_spha, DFTAG_NDG, sds_ref_w10)) == FAIL)
    print_s3_spha_error("init_cr_s3_spha -> Vaddtagref: Couldn't add SDS spha_Y to Vgrp");

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_s3_spha(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_s3_spha(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_s3_spha(struct spha spha_struc, int32 recnum)
{
  int32 start[2], edges[2];
  int32 retval = 0;
  uint8 *odata;
  static int32 recnum_wr=0;

void print_s3_spha_error();
void pack_s3_spha();

  odata = (uint8 *) malloc(sizeof(struct spha));
  pack_s3_spha(odata, &spha_struc);

  if(recnum!=-1) {
	recnum_wr=recnum;
	if(VSseek(vdata_id_s3_spha, recnum)==-1) {
		print_s3_spha_error("write_s3_spha -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_s3_spha, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_s3_spha_error("write_s3_spha -> VSwrite: Couldn't write data.");

  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha1,start,NULL,edges, (VOIDP)(spha_struc.range)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing range data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha2,start,NULL,edges, (VOIDP)(spha_struc.sector)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing sector data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha3,start,NULL,edges, (VOIDP)(spha_struc.fan)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing fan data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha4,start,NULL,edges, (VOIDP)(spha_struc.sys)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing sys data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha5,start,NULL,edges, (VOIDP)(spha_struc.dZ)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing dZ data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha6,start,NULL,edges, (VOIDP)(spha_struc.E)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing E data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha7,start,NULL,edges, (VOIDP)(spha_struc.Eg)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing Eg data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha8,start,NULL,edges, (VOIDP)(spha_struc.dE)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing dE data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha9,start,NULL,edges, (VOIDP)(spha_struc.dEg)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing dEg data.");

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_s3_spha10,start,NULL,edges, (VOIDP)(spha_struc.Y)) ==FAIL)
    print_s3_spha_error("write_s3_spha -> SDwritedata: Problem writing Y data.");

  memset(&spha_struc, 0, sizeof(struct spha));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_s3_spha()
{
  VSdetach(vdata_id_s3_spha);
  Vdetach(vgrp_id_s3_spha);
  SDendaccess(sds_id_s3_spha1);
  SDendaccess(sds_id_s3_spha2);
  SDendaccess(sds_id_s3_spha3);
  SDendaccess(sds_id_s3_spha4);
  SDendaccess(sds_id_s3_spha5);
  SDendaccess(sds_id_s3_spha6);
  SDendaccess(sds_id_s3_spha7);
  SDendaccess(sds_id_s3_spha8);
  SDendaccess(sds_id_s3_spha9);
  SDendaccess(sds_id_s3_spha10);
}

/*----     init access function    ----*/

int32 init_acc_s3_spha(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  int32 vdata_ref;
  int32 num_rec;

  void print_s3_spha_error();

  if((sds_index1=SDnametoindex(sd_id, "spha_range" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_range");
      return(-1);
  }
  if((sds_id_s3_spha1=SDselect(sd_id, sds_index1)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index1");
      return(-1);
  }
  if((sds_index2=SDnametoindex(sd_id, "spha_sector" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_sector");
      return(-1);
  }
  if((sds_id_s3_spha2=SDselect(sd_id, sds_index2)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index2");
      return(-1);
  }
  if((sds_index3=SDnametoindex(sd_id, "spha_fan" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_fan");
      return(-1);
  }
  if((sds_id_s3_spha3=SDselect(sd_id, sds_index3)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index3");
      return(-1);
  }
  if((sds_index4=SDnametoindex(sd_id, "spha_sys" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_sys");
      return(-1);
  }
  if((sds_id_s3_spha4=SDselect(sd_id, sds_index4)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index4");
      return(-1);
  }
  if((sds_index5=SDnametoindex(sd_id, "spha_dZ" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_dZ");
      return(-1);
  }
  if((sds_id_s3_spha5=SDselect(sd_id, sds_index5)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index5");
      return(-1);
  }
  if((sds_index6=SDnametoindex(sd_id, "spha_E" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_E");
      return(-1);
  }
  if((sds_id_s3_spha6=SDselect(sd_id, sds_index6)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index6");
      return(-1);
  }
  if((sds_index7=SDnametoindex(sd_id, "spha_Eg" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_Eg");
      return(-1);
  }
  if((sds_id_s3_spha7=SDselect(sd_id, sds_index7)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index7");
      return(-1);
  }
  if((sds_index8=SDnametoindex(sd_id, "spha_dE" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_dE");
      return(-1);
  }
  if((sds_id_s3_spha8=SDselect(sd_id, sds_index8)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index8");
      return(-1);
  }
  if((sds_index9=SDnametoindex(sd_id, "spha_dEg" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_dEg");
      return(-1);
  }
  if((sds_id_s3_spha9=SDselect(sd_id, sds_index9)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index9");
      return(-1);
  }
  if((sds_index10=SDnametoindex(sd_id, "spha_Y" )) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDnametoindex: Couldn't find spha_Y");
      return(-1);
  }
  if((sds_id_s3_spha10=SDselect(sd_id, sds_index10)) ==FAIL) {
      print_s3_spha_error("init_acc_s3_spha -> SDselect: Couldn't select sds_index10");
      return(-1);
  }

  if ((vdata_ref = VSfind(hdf_fp, "spha")) <= 0 ) {
    print_s3_spha_error("init_acc_s3_spha -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_s3_spha = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_s3_spha_error("init_acc_s3_spha -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_s3_spha, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_s3_spha,"sctime_readout, sctime_collection, QAC, elements, concat, numevts")) {
      print_s3_spha_error("init_acc_s3_spha -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_s3_spha(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_s3_spha(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_s3_spha(struct spha *spha_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_s3_spha_error();
void unpack_s3_spha();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  start[0] = recnum_rd;
  start[1] = 0;

  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct spha));
  VSinquire(vdata_id_s3_spha, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_s3_spha, recnum_rd)==FAIL) {
          print_s3_spha_error("read_s3_spha -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha1,start,NULL,edges, (VOIDP)(spha_struc->range )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read range");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha2,start,NULL,edges, (VOIDP)(spha_struc->sector )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read sector");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha3,start,NULL,edges, (VOIDP)(spha_struc->fan )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read fan");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha4,start,NULL,edges, (VOIDP)(spha_struc->sys )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read sys");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha5,start,NULL,edges, (VOIDP)(spha_struc->dZ )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read dZ");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha6,start,NULL,edges, (VOIDP)(spha_struc->E )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read E");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha7,start,NULL,edges, (VOIDP)(spha_struc->Eg )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read Eg");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha8,start,NULL,edges, (VOIDP)(spha_struc->dE )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read dE");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha9,start,NULL,edges, (VOIDP)(spha_struc->dEg )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read dEg");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN*SEP_PHA_CYCPERSR;

  if(SDreaddata(sds_id_s3_spha10,start,NULL,edges, (VOIDP)(spha_struc->Y )) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> SDreaddata: Couldn't read Y");
    retval = -1;
  }
  if(VSread(vdata_id_s3_spha, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_s3_spha_error("read_s3_spha -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_s3_spha(odata, spha_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_s3_spha()
{
  VSdetach(vdata_id_s3_spha);
  SDendaccess(sds_id_s3_spha1);
  SDendaccess(sds_id_s3_spha2);
  SDendaccess(sds_id_s3_spha3);
  SDendaccess(sds_id_s3_spha4);
  SDendaccess(sds_id_s3_spha5);
  SDendaccess(sds_id_s3_spha6);
  SDendaccess(sds_id_s3_spha7);
  SDendaccess(sds_id_s3_spha8);
  SDendaccess(sds_id_s3_spha9);
  SDendaccess(sds_id_s3_spha10);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_s3_spha(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_s3_spha_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_spha" )) ==FAIL)
    print_s3_spha_error("rd_Vgrp_s3_spha -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_s3_spha_error("rd_Vgrp_s3_spha -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_s3_spha_error("rd_Vgrp_s3_spha -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_s3_spha_error("rd_Vgrp_s3_spha -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_spha, HDstrlen(Vgrp_descrp_spha)) ==FAIL)
    print_s3_spha_error("rd_Vgrp_s3_spha -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_spha);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_s3_spha_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sepica_spha.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_s3_spha(uint8 *data, struct spha *spha_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &spha_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->elements, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->concat, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &spha_ptr->numevts[0], ((2)*(SEP_PHA_CYCPERSR)) );
   ptr+= ((2)*(SEP_PHA_CYCPERSR));
}

/*----   unpack function    ----*/

void unpack_s3_spha(uint8 *data, struct spha *spha_ptr)
{
int32 ptr=0;

   memcpy(&spha_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->elements, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->concat, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&spha_ptr->numevts[0], data+ptr,  ((2)*(SEP_PHA_CYCPERSR)) );
   ptr+= ((2)*(SEP_PHA_CYCPERSR));
}
int32 get_vgrp_id_s3_spha() {return(vgrp_id_s3_spha);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_s3_spha(char *wr_strval)
{
  strcpy(wr_strval, "The file 's3_spha.h' is shown below, it was used to create the data in the Vgroup named 'VG_spha'.\n\n");
  strcat(wr_strval,"/* Id: s3_spha.h,v 1.5 1997/09/05 22:31:18 jeff Exp $	     */\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#define SEP_PHA_CYCLEN   106\n");
  strcat(wr_strval,"#define SEP_PHA_CYCPERSR  60\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct spha{\n");
  strcat(wr_strval,"	uint32 sctime_readout;	/* 32 bit spacecraft time  */\n");
  strcat(wr_strval,"	uint32 sctime_collection;/* 32 bit spacecraft time  */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"	uint32 QAC;	/* number of frames missing in this SR */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"	uint32 elements; /* Number of pha events in this structure. */\n");
  strcat(wr_strval,"                 /* Should always be 6360(106*60) when concat is not 1. */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"	uint8  concat; /* Sequence number for this struture will be */\n");
  strcat(wr_strval,"		       /* greater than one for cases where the number of */\n");
  strcat(wr_strval,"		       /* events exceeds the standard size.  In these cases */\n");
  strcat(wr_strval,"		       /* concat will count down from N to 1, where N is */\n");
  strcat(wr_strval,"			/* the total number of spha structure in this SR. */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"	uint16 numevts[SEP_PHA_CYCPERSR];  /* number of events in EDB */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"	uint8  range[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* range*/\n");
  strcat(wr_strval,"	uint8  sector[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* sector*/\n");
  strcat(wr_strval,"	uint8  fan[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* fan */\n");
  strcat(wr_strval,"	uint8  sys[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* sys*/\n");
  strcat(wr_strval,"	uint8  dZ[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/*  delta Z */\n");
  strcat(wr_strval,"	uint16 E[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Energy*/\n");
  strcat(wr_strval,"	uint8  Eg[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Energy gain bit */\n");
  strcat(wr_strval,"	uint16 dE[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* delta Energy */\n");
  strcat(wr_strval,"	uint8  dEg[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* delta Energy gain bit*/\n");
  strcat(wr_strval,"	uint16 Y[SEP_PHA_CYCLEN * SEP_PHA_CYCPERSR];/* Y value */\n");
  strcat(wr_strval,"};\n");
  return(0);
}
