/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: mag_hskp.h,v 1.7 1997/05/07 18:44:38 jeff Exp $ */

#include "mag_spltst_hskp.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_mag_hskp(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void mag_hskp_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpmag_hskp");
    Vsetclass(vgrp_id, "CVgrpmag_hskp");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "MagHskpSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     mag_hskp_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     mag_hskp_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     mag_hskp_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st1a", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st1a error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st2a", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st2a error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st3", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st4", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st5", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st6", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st6 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "pctemp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine pctemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "cmon", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine cmon error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st1b", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st1b error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st2b", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st2b error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "hk1", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine hk1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "hk2", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine hk2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "hk3", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine hk3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "hk4", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine hk4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "hk5", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine hk5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sync", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine sync error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st_a", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st_a error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "st_b", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine st_b error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "in_temp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine in_temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "out_temp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine out_temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "in_pwrlvl", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine in_pwrlvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "out_pwrlvl", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine out_pwrlvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "current", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine current error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SenIntTempPosY", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine SenIntTempPosY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SenIntTempNegY", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine SenIntTempNegY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagPowBits", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagPowBits error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, st1a, st2a, st3, st4, st5, st6, pctemp, cmon, st1b, st2b, hk1, hk2, hk3, hk4, hk5, sync, st_a, st_b, in_temp, out_temp, in_pwrlvl, out_pwrlvl, current, SenIntTempPosY, SenIntTempNegY, MagPowBits")){
    mag_hskp_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_mag_hskp(struct MagHskpSet MagHskpSet_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_mag_hskp();

  odata = (uint8 *) malloc(sizeof(struct MagHskpSet));
  pack_mag_hskp(odata, &MagHskpSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing MAG HSKP data\n");
  } 
  memset(&MagHskpSet_struc, 0, sizeof(struct MagHskpSet));
  free(odata);
  return(retval);
}

void close_wr_mag_hskp() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_mag_hskp(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void mag_hskp_error();


  if ((vdata_ref = VSfind(hdf_fp, "MagHskpSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, st1a, st2a, st3, st4, st5, st6, pctemp, cmon, st1b, st2b, hk1, hk2, hk3, hk4, hk5, sync, st_a, st_b, in_temp, out_temp, in_pwrlvl, out_pwrlvl, current, SenIntTempPosY, SenIntTempNegY, MagPowBits")) {
    mag_hskp_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_mag_hskp(struct MagHskpSet *MagHskpSet_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_mag_hskp();

  odata = (uint8 *) malloc(sizeof(struct MagHskpSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_mag_hskp(odata, MagHskpSet_struc);
  free(odata);
  return(retval);
}

void mag_hskp_error(int8 *mess)
  { fprintf(stderr,"MAG HSKP: %s\n",mess); }

void close_rd_mag_hskp() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_mag_hskp(uint8 *data, struct MagHskpSet *MagHskpSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &MagHskpSet_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st1a, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st2a, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st6, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->pctemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->cmon, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st1b, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st2b, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->sync, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st_a, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st_b, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->in_temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->out_temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->in_pwrlvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->out_pwrlvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->current, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->SenIntTempPosY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->SenIntTempNegY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->MagPowBits, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_mag_hskp(uint8 *data, struct MagHskpSet *MagHskpSet_ptr)
{
int32 ptr=0;

   memcpy(&MagHskpSet_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagHskpSet_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagHskpSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagHskpSet_ptr->st1a, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st2a, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st6, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->pctemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->cmon, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st1b, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st2b, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->sync, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st_a, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st_b, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->in_temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->out_temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->in_pwrlvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->out_pwrlvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->current, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->SenIntTempPosY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->SenIntTempNegY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->MagPowBits, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
