#include <stdio.h>
#include <string.h>

#include "swepam_iload.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct LOADI testdata;
  int ii,jj,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_swepam_iload(hdf_fp, SD_id);

  /* read and print data */
  ii=0;
  while((retval=read_swepam_iload(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %3d %3d %3d %3d %3d %3d\n", 
	    ii++, testdata.output_sctime, testdata.QAC, testdata.SCid,
	    testdata.FmtFC, testdata.FmtID, testdata.EF, testdata.DB);
    for(jj=0;jj<16;jj++) {
    printf("\t%4d %4d %4d %4d %4d %4d %4d\n", 
	    testdata.MinFrmCnt[jj], testdata.EventFlag[jj], 
	    testdata.StatRec[jj][0], testdata.LoadErr[jj][0], 
	    testdata.DumpAddr[jj], testdata.MemDump[jj][0], 
	    testdata.MinFrmChk[jj]);
    }
  }

  /* all done, close HDF interface */

  close_rd_swepam_iload();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
