#include <stdio.h>
#include <string.h>

#include "swepam_ihskp.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct IHskpSet testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_swepam_ihskp(hdf_fp, SD_id);

  /* read and print data */
  ii=0;
  while((retval=read_swepam_ihskp(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %3d %3d %3d %3d %6d %3d\n", 
	    ii++, testdata.output_sctime, testdata.QAC, testdata.SCid,
	    testdata.FmtFC,testdata.FmtID,
	    testdata.CS,testdata.EF);
  }

  /* all done, close HDF interface */

  close_rd_swepam_ihskp();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
