/*$Id: swepam_ecal.h,v 1.4 1997/05/07 22:45:05 jeff Exp $ */
#include "hdfi.h"

struct DCALE
{
  uint32 output_sctime;   /* time for beginning of data output cycle */
  uint32 collect_sctime;  /* time for beginning of data collection */
  uint8  QAC;              /* number of bad frames in this cycle */

  /* Major Frame Header */
  uint8  SCid;         /* SubCom ID */
  uint8  FmtFC;        /* Frame Format Count */
  uint8  FmtID;        /* Format ID */
  uint8  EF;           /* Event Flag */
  uint16 CS;           /* subcom Configuration Status */
  uint8  DB;           /* DataBase paramter */

  /* Data set header */
  uint8 PhiLim;            /* Current sensor limit */
  uint8 DQAlarm;            /* Data Quality alarm */
  uint8 CEMLev;            /* CEM level */
  uint8 Lmx;               /* ESA lvl with max count rate.0-199.255=invalid*/

  /* spectral segment headers - they should all be 0 */
  uint8 RLmxs[5];          /* Rel ESA lvl with max rate in Spec seg s */
  uint8 DCLmxs[5];          /* Data Channel of Lmxs */
  uint8 PhiLmxs[5];          /* Phi of Lmxs */

  uint8 DiscThld[5][51][2][7];

  uint8 Fill12[5][12];	    /* should all be 55 hex */
  uint8 Fill1;
};

