/* $Id: s3_smatrix.h,v 1.5 1997/05/06 19:13:01 jeff Exp $	     */
#include "hdfi.h"

#define SMAT_N     60  /* number of matrix rates */
#define SMAT_S     1  /* number of sectors */
#define SMAT_CYC   6  /* number of cycles per SR = 60 / 10 */

 /* total size (in bytes) of SMAT data (including slack) in a full SR */
#define SMAT_TSZ   540 

 /* size (in bytes) of SMON cycle (including slack) */
#define SMAT_CSZ   SMAT_TSZ/SMAT_CYC 
#define SMAT_ESZ   SMAT_TSZ/60  /* size (in bytes) of SMAT area in EDB */

struct smatrix{

	uint32 sctime_readout;	/* 32 bit spacecraft time  */
	uint32 sctime_collection;/* 32 bit spacecraft time  */
	uint32 QAC;	/* number of missing frames in this SR */

	uint16 MATRIX[SMAT_CYC][SMAT_N]; /* 49 Matrix rates, 11fill*/
};
