/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: uleis_hskp.h,v 1.4 1997/05/07 21:33:36 steves Exp $ */

#include "uleis_hskp.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8, sds_id_r9, sds_id_w9, sds_id_r10, sds_id_w10, sds_id_r11, sds_id_w11, sds_id_r12, sds_id_w12, sds_id_r13, sds_id_w13, sds_id_r14, sds_id_w14, sds_id_r15, sds_id_w15;


/****  init write function  ****/

int32 init_wr_uleis_hskp(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void uleis_hskp_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpuleis_hskp");
    Vsetclass(vgrp_id, "CVgrpuleis_hskp");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "UHskpSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     uleis_hskp_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     uleis_hskp_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     uleis_hskp_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC")){
    uleis_hskp_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 129;
  if((sds_id_w1=SDcreate(sd_id, "UHskpSet_dump_flg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_dump_flg \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 129;
  if((sds_id_w2=SDcreate(sd_id, "UHskpSet_stat_tlm_flg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_stat_tlm_flg \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w3=SDcreate(sd_id, "UHskpSet_DeckTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_DeckTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w4=SDcreate(sd_id, "UHskpSet_lvps_voltage", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_lvps_voltage \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w5=SDcreate(sd_id, "UHskpSet_total_cur", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_total_cur \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w6=SDcreate(sd_id, "UHskpSet_lvps_cur_analg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_lvps_cur_analg \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w7=SDcreate(sd_id, "UHskpSet_heater_cur", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_heater_cur \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w8=SDcreate(sd_id, "UHskpSet_telescp_temp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_telescp_temp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w9=SDcreate(sd_id, "UHskpSet_analg_elect_temp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_analg_elect_temp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w10=SDcreate(sd_id, "UHskpSet_dpu_temp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_dpu_temp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w11=SDcreate(sd_id, "UHskpSet_UPowBits", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_UPowBits \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = NUMFRM;
  if((sds_id_w12=SDcreate(sd_id, "UHskpSet_PhaseAng", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_PhaseAng \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = NUMFRM;
  if((sds_id_w13=SDcreate(sd_id, "UHskpSet_SunSenID", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_SunSenID \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 2;
  dim_sizes[2] = 8;
  if((sds_id_w14=SDcreate(sd_id, "UHskpSet_SunPulLat", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_SunPulLat \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 2;
  dim_sizes[2] = 8;
  if((sds_id_w15=SDcreate(sd_id, "UHskpSet_SunPulDat", DFNT_UINT32, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UHskpSet_SunPulDat \n");

  return(retval);
}

/****** write function ******/

int32 write_uleis_hskp(struct UHskpSet UHskpSet_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_uleis_hskp();

  odata = (uint8 *) malloc(sizeof(struct UHskpSet));
  pack_uleis_hskp(odata, &UHskpSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing ULEIS HSKP data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = 129;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (UHskpSet_struc.dump_flg ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dump_flg data.\n");
  }
  edges[1] = 129;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (UHskpSet_struc.stat_tlm_flg ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing stat_tlm_flg data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (UHskpSet_struc.DeckTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DeckTemp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (UHskpSet_struc.lvps_voltage ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing lvps_voltage data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (UHskpSet_struc.total_cur ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing total_cur data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (UHskpSet_struc.lvps_cur_analg ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing lvps_cur_analg data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (UHskpSet_struc.heater_cur ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing heater_cur data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (UHskpSet_struc.telescp_temp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing telescp_temp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w9,start,NULL,edges,(VOIDP) (UHskpSet_struc.analg_elect_temp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing analg_elect_temp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w10,start,NULL,edges,(VOIDP) (UHskpSet_struc.dpu_temp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dpu_temp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w11,start,NULL,edges,(VOIDP) (UHskpSet_struc.UPowBits ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing UPowBits data.\n");
  }
  edges[1] = NUMFRM;
  if (SDwritedata(sds_id_w12,start,NULL,edges,(VOIDP) (UHskpSet_struc.PhaseAng ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PhaseAng data.\n");
  }
  edges[1] = NUMFRM;
  if (SDwritedata(sds_id_w13,start,NULL,edges,(VOIDP) (UHskpSet_struc.SunSenID ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunSenID data.\n");
  }
  edges[1] = 2;
  edges[2] = 8;
  if (SDwritedata(sds_id_w14,start,NULL,edges,(VOIDP) (UHskpSet_struc.SunPulLat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunPulLat data.\n");
  }
  edges[1] = 2;
  edges[2] = 8;
  if (SDwritedata(sds_id_w15,start,NULL,edges,(VOIDP) (UHskpSet_struc.SunPulDat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunPulDat data.\n");
  }
  memset(&UHskpSet_struc, 0, sizeof(struct UHskpSet));
  free(odata);
  return(retval);
}

void close_wr_uleis_hskp() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
  SDendaccess(sds_id_w9);
  SDendaccess(sds_id_w10);
  SDendaccess(sds_id_w11);
  SDendaccess(sds_id_w12);
  SDendaccess(sds_id_w13);
  SDendaccess(sds_id_w14);
  SDendaccess(sds_id_w15);
}

/*     init read function    */

int32 init_rd_uleis_hskp(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  static int32 sds_index11;
  static int32 sds_index12;
  static int32 sds_index13;
  static int32 sds_index14;
  static int32 sds_index15;
  int32 vdata_ref;
  int32 retval=0;

  void uleis_hskp_error();

    if((sds_index1=SDnametoindex(sd_id, "UHskpSet_dump_flg" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_dump_flg\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "UHskpSet_stat_tlm_flg" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_stat_tlm_flg\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "UHskpSet_DeckTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_DeckTemp\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "UHskpSet_lvps_voltage" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_lvps_voltage\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "UHskpSet_total_cur" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_total_cur\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "UHskpSet_lvps_cur_analg" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_lvps_cur_analg\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "UHskpSet_heater_cur" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_heater_cur\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "UHskpSet_telescp_temp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_telescp_temp\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }
    if((sds_index9=SDnametoindex(sd_id, "UHskpSet_analg_elect_temp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_analg_elect_temp\n");
      retval = -1;
    }
    if((sds_id_r9=SDselect(sd_id, sds_index9))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index9\n");
      retval = -1;
    }
    if((sds_index10=SDnametoindex(sd_id, "UHskpSet_dpu_temp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_dpu_temp\n");
      retval = -1;
    }
    if((sds_id_r10=SDselect(sd_id, sds_index10))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index10\n");
      retval = -1;
    }
    if((sds_index11=SDnametoindex(sd_id, "UHskpSet_UPowBits" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_UPowBits\n");
      retval = -1;
    }
    if((sds_id_r11=SDselect(sd_id, sds_index11))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index11\n");
      retval = -1;
    }
    if((sds_index12=SDnametoindex(sd_id, "UHskpSet_PhaseAng" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_PhaseAng\n");
      retval = -1;
    }
    if((sds_id_r12=SDselect(sd_id, sds_index12))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index12\n");
      retval = -1;
    }
    if((sds_index13=SDnametoindex(sd_id, "UHskpSet_SunSenID" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_SunSenID\n");
      retval = -1;
    }
    if((sds_id_r13=SDselect(sd_id, sds_index13))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index13\n");
      retval = -1;
    }
    if((sds_index14=SDnametoindex(sd_id, "UHskpSet_SunPulLat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_SunPulLat\n");
      retval = -1;
    }
    if((sds_id_r14=SDselect(sd_id, sds_index14))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index14\n");
      retval = -1;
    }
    if((sds_index15=SDnametoindex(sd_id, "UHskpSet_SunPulDat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UHskpSet_SunPulDat\n");
      retval = -1;
    }
    if((sds_id_r15=SDselect(sd_id, sds_index15))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index15\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "UHskpSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC")) {
    uleis_hskp_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_uleis_hskp(struct UHskpSet *UHskpSet_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_uleis_hskp();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct UHskpSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 129;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(UHskpSet_struc->dump_flg ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dump_flg\n");
    retval = -1;
  }
  edges[1] = 129;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(UHskpSet_struc->stat_tlm_flg ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read stat_tlm_flg\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(UHskpSet_struc->DeckTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DeckTemp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(UHskpSet_struc->lvps_voltage ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read lvps_voltage\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(UHskpSet_struc->total_cur ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read total_cur\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(UHskpSet_struc->lvps_cur_analg ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read lvps_cur_analg\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(UHskpSet_struc->heater_cur ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read heater_cur\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(UHskpSet_struc->telescp_temp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read telescp_temp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r9,start,NULL,edges, (VOIDP)(UHskpSet_struc->analg_elect_temp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read analg_elect_temp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r10,start,NULL,edges, (VOIDP)(UHskpSet_struc->dpu_temp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dpu_temp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r11,start,NULL,edges, (VOIDP)(UHskpSet_struc->UPowBits ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read UPowBits\n");
    retval = -1;
  }
  edges[1] = NUMFRM;
  if(SDreaddata(sds_id_r12,start,NULL,edges, (VOIDP)(UHskpSet_struc->PhaseAng ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PhaseAng\n");
    retval = -1;
  }
  edges[1] = NUMFRM;
  if(SDreaddata(sds_id_r13,start,NULL,edges, (VOIDP)(UHskpSet_struc->SunSenID ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunSenID\n");
    retval = -1;
  }
  edges[1] = 2;
  edges[2] = 8;
  if(SDreaddata(sds_id_r14,start,NULL,edges, (VOIDP)(UHskpSet_struc->SunPulLat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunPulLat\n");
    retval = -1;
  }
  edges[1] = 2;
  edges[2] = 8;
  if(SDreaddata(sds_id_r15,start,NULL,edges, (VOIDP)(UHskpSet_struc->SunPulDat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunPulDat\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_uleis_hskp(odata, UHskpSet_struc);
  free(odata);
  return(retval);
}

void uleis_hskp_error(int8 *mess)
  { fprintf(stderr,"ULEIS HSKP: %s\n",mess); }

void close_rd_uleis_hskp() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
  SDendaccess(sds_id_r9);
  SDendaccess(sds_id_r10);
  SDendaccess(sds_id_r11);
  SDendaccess(sds_id_r12);
  SDendaccess(sds_id_r13);
  SDendaccess(sds_id_r14);
  SDendaccess(sds_id_r15);
}
/*   pack function    */

void pack_uleis_hskp(uint8 *data, struct UHskpSet *UHskpSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &UHskpSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UHskpSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UHskpSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_uleis_hskp(uint8 *data, struct UHskpSet *UHskpSet_ptr)
{
int32 ptr=0;

   memcpy(&UHskpSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UHskpSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UHskpSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
