/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_mpha.h,v 1.2 1997/05/06 19:11:02 jeff Exp $           */

#include "s3_mpha.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6;


/****  init write function  ****/

int32 init_wr_s3_mpha(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void s3_mpha_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_mpha");
    Vsetclass(vgrp_id, "CVgrps3_mpha");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "mpha");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_mpha_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_mpha_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_mpha_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "concat", DFNT_UINT8, (1) )) {
     s3_mpha_error("VSfdefine concat error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "elements", DFNT_UINT32, (1) )) {
     s3_mpha_error("VSfdefine elements error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, concat, elements")){
    s3_mpha_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w1=SDcreate(sd_id, "mpha_range", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_range \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w2=SDcreate(sd_id, "mpha_sector", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_sector \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w3=SDcreate(sd_id, "mpha_stamp", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_stamp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w4=SDcreate(sd_id, "mpha_stopk1", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_stopk1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w5=SDcreate(sd_id, "mpha_stopk2", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_stopk2 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SWIMS_PHA_CYCLEN;
  dim_sizes[2] = SWIMS_PHA_CYCPERSR;
  if((sds_id_w6=SDcreate(sd_id, "mpha_tof", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create mpha_tof \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_mpha(struct mpha mpha_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_mpha();

  odata = (uint8 *) malloc(sizeof(struct mpha));
  pack_s3_mpha(odata, &mpha_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 MPHA data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (mpha_struc.range ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing range data.\n");
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (mpha_struc.sector ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing sector data.\n");
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (mpha_struc.stamp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing stamp data.\n");
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (mpha_struc.stopk1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing stopk1 data.\n");
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (mpha_struc.stopk2 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing stopk2 data.\n");
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (mpha_struc.tof ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing tof data.\n");
  }
  memset(&mpha_struc, 0, sizeof(struct mpha));
  free(odata);
  return(retval);
}

void close_wr_s3_mpha() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
}

/*     init read function    */

int32 init_rd_s3_mpha(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  int32 vdata_ref;
  int32 retval=0;

  void s3_mpha_error();

    if((sds_index1=SDnametoindex(sd_id, "mpha_range" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_range\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "mpha_sector" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_sector\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "mpha_stamp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_stamp\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "mpha_stopk1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_stopk1\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "mpha_stopk2" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_stopk2\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "mpha_tof" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find mpha_tof\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "mpha"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, concat, elements")) {
    s3_mpha_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_mpha(struct mpha *mpha_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_mpha();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct mpha));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(mpha_struc->range ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read range\n");
    retval = -1;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(mpha_struc->sector ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read sector\n");
    retval = -1;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(mpha_struc->stamp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read stamp\n");
    retval = -1;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(mpha_struc->stopk1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read stopk1\n");
    retval = -1;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(mpha_struc->stopk2 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read stopk2\n");
    retval = -1;
  }
  edges[1] = SWIMS_PHA_CYCLEN;
  edges[2] = SWIMS_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(mpha_struc->tof ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read tof\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_mpha(odata, mpha_struc);
  free(odata);
  return(retval);
}

void s3_mpha_error(int8 *mess)
  { fprintf(stderr,"S3 MPHA: %s\n",mess); }

void close_rd_s3_mpha() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
}
/*   pack function    */

void pack_s3_mpha(uint8 *data, struct mpha *mpha_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &mpha_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &mpha_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &mpha_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &mpha_ptr->concat, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &mpha_ptr->elements, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_s3_mpha(uint8 *data, struct mpha *mpha_ptr)
{
int32 ptr=0;

   memcpy(&mpha_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&mpha_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&mpha_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&mpha_ptr->concat, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&mpha_ptr->elements, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
