/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: swepam_ieng.h,v 1.3 1997/02/13 00:54:26 jeff Exp $ */

#include "swepam_ieng.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7;


/****  init write function  ****/

int32 init_wr_swepam_ieng(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void swepam_ieng_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpswepam_ieng");
    Vsetclass(vgrp_id, "CVgrpswepam_ieng");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "ENGI");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     swepam_ieng_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     swepam_ieng_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SCid", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine SCid error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtFC", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine FmtFC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtID", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine FmtID error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EF", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine EF error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CS", DFNT_UINT16, (1) )) {
     swepam_ieng_error("VSfdefine CS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DB", DFNT_UINT8, (1) )) {
     swepam_ieng_error("VSfdefine DB error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB")){
    swepam_ieng_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w1=SDcreate(sd_id, "ENGI_MinFrmIndx", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_MinFrmIndx \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w2=SDcreate(sd_id, "ENGI_EventFlag", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_EventFlag \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 16;
  dim_sizes[2] = 3;
  if((sds_id_w3=SDcreate(sd_id, "ENGI_StatRec", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_StatRec \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 16;
  dim_sizes[2] = 16;
  if((sds_id_w4=SDcreate(sd_id, "ENGI_ScalerRec", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_ScalerRec \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w5=SDcreate(sd_id, "ENGI_DumpAddr", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_DumpAddr \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 16;
  dim_sizes[2] = 28;
  if((sds_id_w6=SDcreate(sd_id, "ENGI_MemDump", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_MemDump \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w7=SDcreate(sd_id, "ENGI_MinFrmChk", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ENGI_MinFrmChk \n");

  return(retval);
}

/****** write function ******/

int32 write_swepam_ieng(struct ENGI ENGI_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_swepam_ieng();

  odata = (uint8 *) malloc(sizeof(struct ENGI));
  pack_swepam_ieng(odata, &ENGI_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SWEPAM IENG data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = 16;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (ENGI_struc.MinFrmIndx ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing MinFrmIndx data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (ENGI_struc.EventFlag ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing EventFlag data.\n");
  }
  edges[1] = 16;
  edges[2] = 3;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (ENGI_struc.StatRec ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing StatRec data.\n");
  }
  edges[1] = 16;
  edges[2] = 16;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (ENGI_struc.ScalerRec ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing ScalerRec data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (ENGI_struc.DumpAddr ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DumpAddr data.\n");
  }
  edges[1] = 16;
  edges[2] = 28;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (ENGI_struc.MemDump ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing MemDump data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (ENGI_struc.MinFrmChk ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing MinFrmChk data.\n");
  }
  memset(&ENGI_struc, 0, sizeof(struct ENGI));
  free(odata);
  return(retval);
}

void close_wr_swepam_ieng() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
}

/*     init read function    */

int32 init_rd_swepam_ieng(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  int32 vdata_ref;
  int32 retval=0;

  void swepam_ieng_error();

    if((sds_index1=SDnametoindex(sd_id, "ENGI_MinFrmIndx" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_MinFrmIndx\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "ENGI_EventFlag" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_EventFlag\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "ENGI_StatRec" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_StatRec\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "ENGI_ScalerRec" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_ScalerRec\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "ENGI_DumpAddr" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_DumpAddr\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "ENGI_MemDump" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_MemDump\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "ENGI_MinFrmChk" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ENGI_MinFrmChk\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "ENGI"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB")) {
    swepam_ieng_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_swepam_ieng(struct ENGI *ENGI_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_swepam_ieng();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct ENGI));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(ENGI_struc->MinFrmIndx ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read MinFrmIndx\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(ENGI_struc->EventFlag ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read EventFlag\n");
    retval = -1;
  }
  edges[1] = 16;
  edges[2] = 3;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(ENGI_struc->StatRec ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read StatRec\n");
    retval = -1;
  }
  edges[1] = 16;
  edges[2] = 16;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(ENGI_struc->ScalerRec ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read ScalerRec\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(ENGI_struc->DumpAddr ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DumpAddr\n");
    retval = -1;
  }
  edges[1] = 16;
  edges[2] = 28;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(ENGI_struc->MemDump ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read MemDump\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(ENGI_struc->MinFrmChk ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read MinFrmChk\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_swepam_ieng(odata, ENGI_struc);
  free(odata);
  return(retval);
}

void swepam_ieng_error(int8 *mess)
  { fprintf(stderr,"SWEPAM IENG: %s\n",mess); }

void close_rd_swepam_ieng() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
}
/*   pack function    */

void pack_swepam_ieng(uint8 *data, struct ENGI *ENGI_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &ENGI_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ENGI_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ENGI_ptr->QAC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ENGI_ptr->SCid, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ENGI_ptr->FmtFC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ENGI_ptr->FmtID, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ENGI_ptr->EF, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ENGI_ptr->CS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &ENGI_ptr->DB, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_swepam_ieng(uint8 *data, struct ENGI *ENGI_ptr)
{
int32 ptr=0;

   memcpy(&ENGI_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ENGI_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ENGI_ptr->QAC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ENGI_ptr->SCid, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ENGI_ptr->FmtFC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ENGI_ptr->FmtID, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ENGI_ptr->EF, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ENGI_ptr->CS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&ENGI_ptr->DB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
