/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: swepam_ensw.h,v 1.4 1997/05/07 22:45:05 jeff Exp $ */

#include "swepam_ensw.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8;


/****  init write function  ****/

int32 init_wr_swepam_ephe(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[5];
  int32 rank;

  void swepam_ephe_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpswepam_ephe");
    Vsetclass(vgrp_id, "CVgrpswepam_ephe");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "DNSWE");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     swepam_ephe_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     swepam_ephe_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PhiLim", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine PhiLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DQAlarm", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine DQAlarm error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CEMLev", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine CEMLev error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Lmx", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine Lmx error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Fill1", DFNT_UINT8, (1) )) {
     swepam_ephe_error("VSfdefine Fill1 error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, PhiLim, DQAlarm, CEMLev, Lmx, Fill1")){
    swepam_ephe_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w1=SDcreate(sd_id, "DNSWE_SCid", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_SCid \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w2=SDcreate(sd_id, "DNSWE_FmtFC", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_FmtFC \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w3=SDcreate(sd_id, "DNSWE_FmtID", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_FmtID \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w4=SDcreate(sd_id, "DNSWE_EF", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_EF \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w5=SDcreate(sd_id, "DNSWE_CS", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_CS \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w6=SDcreate(sd_id, "DNSWE_DB", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_DB \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 5;
  dim_sizes[1] = 5;
  dim_sizes[2] = 30;
  dim_sizes[3] = 4;
  dim_sizes[4] = 5;
  if((sds_id_w7=SDcreate(sd_id, "DNSWE_CEMcnt", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_CEMcnt \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 5;
  dim_sizes[2] = 5;
  if((sds_id_w8=SDcreate(sd_id, "DNSWE_Fill5", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DNSWE_Fill5 \n");

  return(retval);
}

/****** write function ******/

int32 write_swepam_ephe(struct DNSWE DNSWE_struc)
{
int32 start[5], edges[5];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_swepam_ephe();

  odata = (uint8 *) malloc(sizeof(struct DNSWE));
  pack_swepam_ephe(odata, &DNSWE_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SWEPAM EPHE data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  start[4] = 0;
  edges[0] = 1;

  edges[1] = 4;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (DNSWE_struc.SCid ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SCid data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (DNSWE_struc.FmtFC ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FmtFC data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (DNSWE_struc.FmtID ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FmtID data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (DNSWE_struc.EF ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing EF data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (DNSWE_struc.CS ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing CS data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (DNSWE_struc.DB ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DB data.\n");
  }
  edges[1] = 5;
  edges[2] = 30;
  edges[3] = 4;
  edges[4] = 5;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (DNSWE_struc.CEMcnt ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing CEMcnt data.\n");
  }
  edges[1] = 5;
  edges[2] = 5;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (DNSWE_struc.Fill5 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Fill5 data.\n");
  }
  memset(&DNSWE_struc, 0, sizeof(struct DNSWE));
  free(odata);
  return(retval);
}

void close_wr_swepam_ephe() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
}

/*     init read function    */

int32 init_rd_swepam_ephe(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  int32 vdata_ref;
  int32 retval=0;

  void swepam_ephe_error();

    if((sds_index1=SDnametoindex(sd_id, "DNSWE_SCid" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_SCid\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "DNSWE_FmtFC" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_FmtFC\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "DNSWE_FmtID" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_FmtID\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "DNSWE_EF" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_EF\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "DNSWE_CS" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_CS\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "DNSWE_DB" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_DB\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "DNSWE_CEMcnt" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_CEMcnt\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "DNSWE_Fill5" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DNSWE_Fill5\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "DNSWE"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, PhiLim, DQAlarm, CEMLev, Lmx, Fill1")) {
    swepam_ephe_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_swepam_ephe(struct DNSWE *DNSWE_struc, int32 recnum_rd)
{
int32 start[5], edges[5];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_swepam_ephe();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  start[4] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct DNSWE));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(DNSWE_struc->SCid ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SCid\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(DNSWE_struc->FmtFC ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FmtFC\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(DNSWE_struc->FmtID ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FmtID\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(DNSWE_struc->EF ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read EF\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(DNSWE_struc->CS ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read CS\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(DNSWE_struc->DB ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DB\n");
    retval = -1;
  }
  edges[1] = 5;
  edges[2] = 30;
  edges[3] = 4;
  edges[4] = 5;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(DNSWE_struc->CEMcnt ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read CEMcnt\n");
    retval = -1;
  }
  edges[1] = 5;
  edges[2] = 5;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(DNSWE_struc->Fill5 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Fill5\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_swepam_ephe(odata, DNSWE_struc);
  free(odata);
  return(retval);
}

void swepam_ephe_error(int8 *mess)
  { fprintf(stderr,"SWEPAM EPHE: %s\n",mess); }

void close_rd_swepam_ephe() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
}
/*   pack function    */

void pack_swepam_ephe(uint8 *data, struct DNSWE *DNSWE_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &DNSWE_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &DNSWE_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &DNSWE_ptr->QAC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DNSWE_ptr->PhiLim, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DNSWE_ptr->DQAlarm, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DNSWE_ptr->CEMLev, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DNSWE_ptr->Lmx, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DNSWE_ptr->Fill1, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_swepam_ephe(uint8 *data, struct DNSWE *DNSWE_ptr)
{
int32 ptr=0;

   memcpy(&DNSWE_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&DNSWE_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&DNSWE_ptr->QAC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DNSWE_ptr->PhiLim, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DNSWE_ptr->DQAlarm, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DNSWE_ptr->CEMLev, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DNSWE_ptr->Lmx, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DNSWE_ptr->Fill1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
