/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: swepam_ehskp.h,v 1.3 1997/02/13 01:17:20 jeff Exp $ */

#include "swepam_ehskp.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_swepam_ehskp(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void swepam_ehskp_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpswepam_ehskp");
    Vsetclass(vgrp_id, "CVgrpswepam_ehskp");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "EHskpSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     swepam_ehskp_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     swepam_ehskp_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SCid", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine SCid error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtFC", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine FmtFC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtID", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine FmtID error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EF", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine EF error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CS", DFNT_UINT16, (1) )) {
     swepam_ehskp_error("VSfdefine CS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DB", DFNT_UINT8, (1) )) {
     swepam_ehskp_error("VSfdefine DB error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB")){
    swepam_ehskp_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_swepam_ehskp(struct EHskpSet EHskpSet_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_swepam_ehskp();

  odata = (uint8 *) malloc(sizeof(struct EHskpSet));
  pack_swepam_ehskp(odata, &EHskpSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SWEPAM EHSKP data\n");
  } 
  memset(&EHskpSet_struc, 0, sizeof(struct EHskpSet));
  free(odata);
  return(retval);
}

void close_wr_swepam_ehskp() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_swepam_ehskp(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void swepam_ehskp_error();


  if ((vdata_ref = VSfind(hdf_fp, "EHskpSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB")) {
    swepam_ehskp_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_swepam_ehskp(struct EHskpSet *EHskpSet_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_swepam_ehskp();

  odata = (uint8 *) malloc(sizeof(struct EHskpSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_swepam_ehskp(odata, EHskpSet_struc);
  free(odata);
  return(retval);
}

void swepam_ehskp_error(int8 *mess)
  { fprintf(stderr,"SWEPAM EHSKP: %s\n",mess); }

void close_rd_swepam_ehskp() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_swepam_ehskp(uint8 *data, struct EHskpSet *EHskpSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EHskpSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->QAC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->SCid, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->FmtFC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->FmtID, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->EF, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->CS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &EHskpSet_ptr->DB, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_swepam_ehskp(uint8 *data, struct EHskpSet *EHskpSet_ptr)
{
int32 ptr=0;

   memcpy(&EHskpSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EHskpSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EHskpSet_ptr->QAC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&EHskpSet_ptr->SCid, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&EHskpSet_ptr->FmtFC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&EHskpSet_ptr->FmtID, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&EHskpSet_ptr->EF, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&EHskpSet_ptr->CS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&EHskpSet_ptr->DB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
