/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/*$Id: swepam_ecal.h,v 1.4 1997/05/07 22:45:05 jeff Exp $ */

#include "swepam_ecal.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5;


/****  init write function  ****/

int32 init_wr_swepam_ecal(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[5];
  int32 rank;

  void swepam_ecal_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpswepam_ecal");
    Vsetclass(vgrp_id, "CVgrpswepam_ecal");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "DCALE");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     swepam_ecal_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     swepam_ecal_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SCid", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine SCid error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtFC", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine FmtFC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FmtID", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine FmtID error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EF", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine EF error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CS", DFNT_UINT16, (1) )) {
     swepam_ecal_error("VSfdefine CS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DB", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine DB error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PhiLim", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine PhiLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DQAlarm", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine DQAlarm error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CEMLev", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine CEMLev error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Lmx", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine Lmx error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Fill1", DFNT_UINT8, (1) )) {
     swepam_ecal_error("VSfdefine Fill1 error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB, PhiLim, DQAlarm, CEMLev, Lmx, Fill1")){
    swepam_ecal_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 5;
  if((sds_id_w1=SDcreate(sd_id, "DCALE_RLmxs", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DCALE_RLmxs \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 5;
  if((sds_id_w2=SDcreate(sd_id, "DCALE_DCLmxs", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DCALE_DCLmxs \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 5;
  if((sds_id_w3=SDcreate(sd_id, "DCALE_PhiLmxs", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DCALE_PhiLmxs \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 5;
  dim_sizes[1] = 5;
  dim_sizes[2] = 51;
  dim_sizes[3] = 2;
  dim_sizes[4] = 7;
  if((sds_id_w4=SDcreate(sd_id, "DCALE_DiscThld", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DCALE_DiscThld \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 5;
  dim_sizes[2] = 12;
  if((sds_id_w5=SDcreate(sd_id, "DCALE_Fill12", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create DCALE_Fill12 \n");

  return(retval);
}

/****** write function ******/

int32 write_swepam_ecal(struct DCALE DCALE_struc)
{
int32 start[5], edges[5];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_swepam_ecal();

  odata = (uint8 *) malloc(sizeof(struct DCALE));
  pack_swepam_ecal(odata, &DCALE_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SWEPAM ECAL data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  start[4] = 0;
  edges[0] = 1;

  edges[1] = 5;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (DCALE_struc.RLmxs ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing RLmxs data.\n");
  }
  edges[1] = 5;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (DCALE_struc.DCLmxs ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DCLmxs data.\n");
  }
  edges[1] = 5;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (DCALE_struc.PhiLmxs ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PhiLmxs data.\n");
  }
  edges[1] = 5;
  edges[2] = 51;
  edges[3] = 2;
  edges[4] = 7;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (DCALE_struc.DiscThld ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DiscThld data.\n");
  }
  edges[1] = 5;
  edges[2] = 12;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (DCALE_struc.Fill12 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Fill12 data.\n");
  }
  memset(&DCALE_struc, 0, sizeof(struct DCALE));
  free(odata);
  return(retval);
}

void close_wr_swepam_ecal() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
}

/*     init read function    */

int32 init_rd_swepam_ecal(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  int32 vdata_ref;
  int32 retval=0;

  void swepam_ecal_error();

    if((sds_index1=SDnametoindex(sd_id, "DCALE_RLmxs" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DCALE_RLmxs\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "DCALE_DCLmxs" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DCALE_DCLmxs\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "DCALE_PhiLmxs" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DCALE_PhiLmxs\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "DCALE_DiscThld" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DCALE_DiscThld\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "DCALE_Fill12" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find DCALE_Fill12\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "DCALE"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, SCid, FmtFC, FmtID, EF, CS, DB, PhiLim, DQAlarm, CEMLev, Lmx, Fill1")) {
    swepam_ecal_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_swepam_ecal(struct DCALE *DCALE_struc, int32 recnum_rd)
{
int32 start[5], edges[5];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_swepam_ecal();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  start[4] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct DCALE));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 5;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(DCALE_struc->RLmxs ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read RLmxs\n");
    retval = -1;
  }
  edges[1] = 5;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(DCALE_struc->DCLmxs ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DCLmxs\n");
    retval = -1;
  }
  edges[1] = 5;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(DCALE_struc->PhiLmxs ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PhiLmxs\n");
    retval = -1;
  }
  edges[1] = 5;
  edges[2] = 51;
  edges[3] = 2;
  edges[4] = 7;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(DCALE_struc->DiscThld ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DiscThld\n");
    retval = -1;
  }
  edges[1] = 5;
  edges[2] = 12;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(DCALE_struc->Fill12 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Fill12\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_swepam_ecal(odata, DCALE_struc);
  free(odata);
  return(retval);
}

void swepam_ecal_error(int8 *mess)
  { fprintf(stderr,"SWEPAM ECAL: %s\n",mess); }

void close_rd_swepam_ecal() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
}
/*   pack function    */

void pack_swepam_ecal(uint8 *data, struct DCALE *DCALE_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &DCALE_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &DCALE_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &DCALE_ptr->QAC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->SCid, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->FmtFC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->FmtID, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->EF, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->CS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &DCALE_ptr->DB, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->PhiLim, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->DQAlarm, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->CEMLev, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->Lmx, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &DCALE_ptr->Fill1, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_swepam_ecal(uint8 *data, struct DCALE *DCALE_ptr)
{
int32 ptr=0;

   memcpy(&DCALE_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&DCALE_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&DCALE_ptr->QAC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->SCid, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->FmtFC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->FmtID, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->EF, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->CS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&DCALE_ptr->DB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->PhiLim, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->DQAlarm, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->CEMLev, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->Lmx, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&DCALE_ptr->Fill1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
