/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_sstatus.h,v 1.2 1997/05/06 19:13:01 jeff Exp $	     */

#include "s3_sstatus.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2;


/****  init write function  ****/

int32 init_wr_s3_sstatus(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void s3_sstatus_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_sstatus");
    Vsetclass(vgrp_id, "CVgrps3_sstatus");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "sstatus");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_sstatus_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_sstatus_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_sstatus_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    s3_sstatus_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 60;
  if((sds_id_w1=SDcreate(sd_id, "sstatus_STACMD", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create sstatus_STACMD \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 60;
  if((sds_id_w2=SDcreate(sd_id, "sstatus_STARET", DFNT_UINT32, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create sstatus_STARET \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_sstatus(struct sstatus sstatus_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_sstatus();

  odata = (uint8 *) malloc(sizeof(struct sstatus));
  pack_s3_sstatus(odata, &sstatus_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 SSTATUS data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = 60;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (sstatus_struc.STACMD ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing STACMD data.\n");
  }
  edges[1] = 60;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (sstatus_struc.STARET ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing STARET data.\n");
  }
  memset(&sstatus_struc, 0, sizeof(struct sstatus));
  free(odata);
  return(retval);
}

void close_wr_s3_sstatus() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
}

/*     init read function    */

int32 init_rd_s3_sstatus(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  int32 vdata_ref;
  int32 retval=0;

  void s3_sstatus_error();

    if((sds_index1=SDnametoindex(sd_id, "sstatus_STACMD" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find sstatus_STACMD\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "sstatus_STARET" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find sstatus_STARET\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "sstatus"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    s3_sstatus_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_sstatus(struct sstatus *sstatus_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_sstatus();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct sstatus));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 60;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(sstatus_struc->STACMD ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read STACMD\n");
    retval = -1;
  }
  edges[1] = 60;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(sstatus_struc->STARET ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read STARET\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_sstatus(odata, sstatus_struc);
  free(odata);
  return(retval);
}

void s3_sstatus_error(int8 *mess)
  { fprintf(stderr,"S3 SSTATUS: %s\n",mess); }

void close_rd_s3_sstatus() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
}
/*   pack function    */

void pack_s3_sstatus(uint8 *data, struct sstatus *sstatus_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &sstatus_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sstatus_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sstatus_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_s3_sstatus(uint8 *data, struct sstatus *sstatus_ptr)
{
int32 ptr=0;

   memcpy(&sstatus_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sstatus_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sstatus_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
