/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: mag_fft.h,v 1.7 1997/05/07 18:44:38 jeff Exp $ */

#include "mag_fft.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2;


/****  init write function  ****/

int32 init_wr_mag_fft(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void mag_fft_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpmag_fft");
    Vsetclass(vgrp_id, "CVgrpmag_fft");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "MagFFTSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     mag_fft_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     mag_fft_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     mag_fft_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    mag_fft_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = MJ_FFT_CYC;
  if((sds_id_w1=SDcreate(sd_id, "MagFFTSet_fft_statbits", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create MagFFTSet_fft_statbits \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 10;
  dim_sizes[2] = FFTBIN;
  if((sds_id_w2=SDcreate(sd_id, "MagFFTSet_fft_val", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create MagFFTSet_fft_val \n");

  return(retval);
}

/****** write function ******/

int32 write_mag_fft(struct MagFFTSet MagFFTSet_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_mag_fft();

  odata = (uint8 *) malloc(sizeof(struct MagFFTSet));
  pack_mag_fft(odata, &MagFFTSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing MAG FFT data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = MJ_FFT_CYC;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (MagFFTSet_struc.fft_statbits ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing fft_statbits data.\n");
  }
  edges[1] = 10;
  edges[2] = FFTBIN;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (MagFFTSet_struc.fft_val ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing fft_val data.\n");
  }
  memset(&MagFFTSet_struc, 0, sizeof(struct MagFFTSet));
  free(odata);
  return(retval);
}

void close_wr_mag_fft() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
}

/*     init read function    */

int32 init_rd_mag_fft(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  int32 vdata_ref;
  int32 retval=0;

  void mag_fft_error();

    if((sds_index1=SDnametoindex(sd_id, "MagFFTSet_fft_statbits" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find MagFFTSet_fft_statbits\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "MagFFTSet_fft_val" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find MagFFTSet_fft_val\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "MagFFTSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    mag_fft_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_mag_fft(struct MagFFTSet *MagFFTSet_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_mag_fft();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct MagFFTSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = MJ_FFT_CYC;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(MagFFTSet_struc->fft_statbits ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read fft_statbits\n");
    retval = -1;
  }
  edges[1] = 10;
  edges[2] = FFTBIN;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(MagFFTSet_struc->fft_val ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read fft_val\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_mag_fft(odata, MagFFTSet_struc);
  free(odata);
  return(retval);
}

void mag_fft_error(int8 *mess)
  { fprintf(stderr,"MAG FFT: %s\n",mess); }

void close_rd_mag_fft() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
}
/*   pack function    */

void pack_mag_fft(uint8 *data, struct MagFFTSet *MagFFTSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &MagFFTSet_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagFFTSet_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagFFTSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_mag_fft(uint8 *data, struct MagFFTSet *MagFFTSet_ptr)
{
int32 ptr=0;

   memcpy(&MagFFTSet_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagFFTSet_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagFFTSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
