/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: epam.h,v 1.5 1997/05/08 16:40:09 jeff Exp $ */

#include "epam.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8, sds_id_r9, sds_id_w9, sds_id_r10, sds_id_w10, sds_id_r11, sds_id_w11, sds_id_r12, sds_id_w12, sds_id_r13, sds_id_w13, sds_id_r14, sds_id_w14, sds_id_r15, sds_id_w15, sds_id_r16, sds_id_w16, sds_id_r17, sds_id_w17, sds_id_r18, sds_id_w18, sds_id_r19, sds_id_w19, sds_id_r20, sds_id_w20, sds_id_r21, sds_id_w21;


/****  init write function  ****/

int32 init_wr_epam_data(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void epam_data_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpepam_data");
    Vsetclass(vgrp_id, "CVgrpepam_data");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "EpamData");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     epam_data_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     epam_data_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     epam_data_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    epam_data_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = NUMFRM;
  dim_sizes[2] = BYTMIN;
  if((sds_id_w1=SDcreate(sd_id, "EpamData_data", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_data \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = NUMFRM;
  if((sds_id_w2=SDcreate(sd_id, "EpamData_PhaseAng", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_PhaseAng \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 2;
  dim_sizes[2] = 8;
  if((sds_id_w3=SDcreate(sd_id, "EpamData_SunPulLat", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_SunPulLat \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 2;
  dim_sizes[2] = 8;
  if((sds_id_w4=SDcreate(sd_id, "EpamData_SunPulDat", DFNT_UINT32, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_SunPulDat \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w5=SDcreate(sd_id, "EpamData_Cal", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Cal \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w6=SDcreate(sd_id, "EpamData_Ref10", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Ref10 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w7=SDcreate(sd_id, "EpamData_Mon10", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Mon10 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w8=SDcreate(sd_id, "EpamData_Mon6", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Mon6 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w9=SDcreate(sd_id, "EpamData_Bias", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Bias \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w10=SDcreate(sd_id, "EpamData_AmpTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_AmpTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w11=SDcreate(sd_id, "EpamData_MFSATemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_MFSATemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w12=SDcreate(sd_id, "EpamData_DetTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_DetTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w13=SDcreate(sd_id, "EpamData_YTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_YTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w14=SDcreate(sd_id, "EpamData_InCur", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_InCur \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w15=SDcreate(sd_id, "EpamData_E1Temp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_E1Temp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w16=SDcreate(sd_id, "EpamData_Sen2ATemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Sen2ATemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w17=SDcreate(sd_id, "EpamData_Sen2BTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Sen2BTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w18=SDcreate(sd_id, "EpamData_DeckTemp", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_DeckTemp \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w19=SDcreate(sd_id, "EpamData_Cur", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_Cur \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w20=SDcreate(sd_id, "EpamData_HtrCur", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_HtrCur \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w21=SDcreate(sd_id, "EpamData_PowBits", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create EpamData_PowBits \n");

  return(retval);
}

/****** write function ******/

int32 write_epam_data(struct EpamData EpamData_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_epam_data();

  odata = (uint8 *) malloc(sizeof(struct EpamData));
  pack_epam_data(odata, &EpamData_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing EPAM DATA data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = NUMFRM;
  edges[2] = BYTMIN;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (EpamData_struc.data ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data data.\n");
  }
  edges[1] = NUMFRM;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (EpamData_struc.PhaseAng ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PhaseAng data.\n");
  }
  edges[1] = 2;
  edges[2] = 8;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (EpamData_struc.SunPulLat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunPulLat data.\n");
  }
  edges[1] = 2;
  edges[2] = 8;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (EpamData_struc.SunPulDat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunPulDat data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (EpamData_struc.Cal ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Cal data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (EpamData_struc.Ref10 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Ref10 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (EpamData_struc.Mon10 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Mon10 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (EpamData_struc.Mon6 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Mon6 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w9,start,NULL,edges,(VOIDP) (EpamData_struc.Bias ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Bias data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w10,start,NULL,edges,(VOIDP) (EpamData_struc.AmpTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing AmpTemp data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w11,start,NULL,edges,(VOIDP) (EpamData_struc.MFSATemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing MFSATemp data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w12,start,NULL,edges,(VOIDP) (EpamData_struc.DetTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DetTemp data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w13,start,NULL,edges,(VOIDP) (EpamData_struc.YTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing YTemp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w14,start,NULL,edges,(VOIDP) (EpamData_struc.InCur ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing InCur data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w15,start,NULL,edges,(VOIDP) (EpamData_struc.E1Temp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing E1Temp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w16,start,NULL,edges,(VOIDP) (EpamData_struc.Sen2ATemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Sen2ATemp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w17,start,NULL,edges,(VOIDP) (EpamData_struc.Sen2BTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Sen2BTemp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w18,start,NULL,edges,(VOIDP) (EpamData_struc.DeckTemp ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DeckTemp data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w19,start,NULL,edges,(VOIDP) (EpamData_struc.Cur ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Cur data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w20,start,NULL,edges,(VOIDP) (EpamData_struc.HtrCur ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing HtrCur data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w21,start,NULL,edges,(VOIDP) (EpamData_struc.PowBits ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PowBits data.\n");
  }
  memset(&EpamData_struc, 0, sizeof(struct EpamData));
  free(odata);
  return(retval);
}

void close_wr_epam_data() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
  SDendaccess(sds_id_w9);
  SDendaccess(sds_id_w10);
  SDendaccess(sds_id_w11);
  SDendaccess(sds_id_w12);
  SDendaccess(sds_id_w13);
  SDendaccess(sds_id_w14);
  SDendaccess(sds_id_w15);
  SDendaccess(sds_id_w16);
  SDendaccess(sds_id_w17);
  SDendaccess(sds_id_w18);
  SDendaccess(sds_id_w19);
  SDendaccess(sds_id_w20);
  SDendaccess(sds_id_w21);
}

/*     init read function    */

int32 init_rd_epam_data(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  static int32 sds_index11;
  static int32 sds_index12;
  static int32 sds_index13;
  static int32 sds_index14;
  static int32 sds_index15;
  static int32 sds_index16;
  static int32 sds_index17;
  static int32 sds_index18;
  static int32 sds_index19;
  static int32 sds_index20;
  static int32 sds_index21;
  int32 vdata_ref;
  int32 retval=0;

  void epam_data_error();

    if((sds_index1=SDnametoindex(sd_id, "EpamData_data" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_data\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "EpamData_PhaseAng" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_PhaseAng\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "EpamData_SunPulLat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_SunPulLat\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "EpamData_SunPulDat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_SunPulDat\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "EpamData_Cal" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Cal\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "EpamData_Ref10" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Ref10\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "EpamData_Mon10" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Mon10\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "EpamData_Mon6" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Mon6\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }
    if((sds_index9=SDnametoindex(sd_id, "EpamData_Bias" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Bias\n");
      retval = -1;
    }
    if((sds_id_r9=SDselect(sd_id, sds_index9))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index9\n");
      retval = -1;
    }
    if((sds_index10=SDnametoindex(sd_id, "EpamData_AmpTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_AmpTemp\n");
      retval = -1;
    }
    if((sds_id_r10=SDselect(sd_id, sds_index10))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index10\n");
      retval = -1;
    }
    if((sds_index11=SDnametoindex(sd_id, "EpamData_MFSATemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_MFSATemp\n");
      retval = -1;
    }
    if((sds_id_r11=SDselect(sd_id, sds_index11))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index11\n");
      retval = -1;
    }
    if((sds_index12=SDnametoindex(sd_id, "EpamData_DetTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_DetTemp\n");
      retval = -1;
    }
    if((sds_id_r12=SDselect(sd_id, sds_index12))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index12\n");
      retval = -1;
    }
    if((sds_index13=SDnametoindex(sd_id, "EpamData_YTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_YTemp\n");
      retval = -1;
    }
    if((sds_id_r13=SDselect(sd_id, sds_index13))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index13\n");
      retval = -1;
    }
    if((sds_index14=SDnametoindex(sd_id, "EpamData_InCur" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_InCur\n");
      retval = -1;
    }
    if((sds_id_r14=SDselect(sd_id, sds_index14))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index14\n");
      retval = -1;
    }
    if((sds_index15=SDnametoindex(sd_id, "EpamData_E1Temp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_E1Temp\n");
      retval = -1;
    }
    if((sds_id_r15=SDselect(sd_id, sds_index15))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index15\n");
      retval = -1;
    }
    if((sds_index16=SDnametoindex(sd_id, "EpamData_Sen2ATemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Sen2ATemp\n");
      retval = -1;
    }
    if((sds_id_r16=SDselect(sd_id, sds_index16))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index16\n");
      retval = -1;
    }
    if((sds_index17=SDnametoindex(sd_id, "EpamData_Sen2BTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Sen2BTemp\n");
      retval = -1;
    }
    if((sds_id_r17=SDselect(sd_id, sds_index17))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index17\n");
      retval = -1;
    }
    if((sds_index18=SDnametoindex(sd_id, "EpamData_DeckTemp" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_DeckTemp\n");
      retval = -1;
    }
    if((sds_id_r18=SDselect(sd_id, sds_index18))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index18\n");
      retval = -1;
    }
    if((sds_index19=SDnametoindex(sd_id, "EpamData_Cur" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_Cur\n");
      retval = -1;
    }
    if((sds_id_r19=SDselect(sd_id, sds_index19))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index19\n");
      retval = -1;
    }
    if((sds_index20=SDnametoindex(sd_id, "EpamData_HtrCur" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_HtrCur\n");
      retval = -1;
    }
    if((sds_id_r20=SDselect(sd_id, sds_index20))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index20\n");
      retval = -1;
    }
    if((sds_index21=SDnametoindex(sd_id, "EpamData_PowBits" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find EpamData_PowBits\n");
      retval = -1;
    }
    if((sds_id_r21=SDselect(sd_id, sds_index21))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index21\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "EpamData"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    epam_data_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_epam_data(struct EpamData *EpamData_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_epam_data();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct EpamData));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = NUMFRM;
  edges[2] = BYTMIN;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(EpamData_struc->data ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data\n");
    retval = -1;
  }
  edges[1] = NUMFRM;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(EpamData_struc->PhaseAng ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PhaseAng\n");
    retval = -1;
  }
  edges[1] = 2;
  edges[2] = 8;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(EpamData_struc->SunPulLat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunPulLat\n");
    retval = -1;
  }
  edges[1] = 2;
  edges[2] = 8;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(EpamData_struc->SunPulDat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunPulDat\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(EpamData_struc->Cal ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Cal\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(EpamData_struc->Ref10 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Ref10\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(EpamData_struc->Mon10 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Mon10\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(EpamData_struc->Mon6 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Mon6\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r9,start,NULL,edges, (VOIDP)(EpamData_struc->Bias ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Bias\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r10,start,NULL,edges, (VOIDP)(EpamData_struc->AmpTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read AmpTemp\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r11,start,NULL,edges, (VOIDP)(EpamData_struc->MFSATemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read MFSATemp\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r12,start,NULL,edges, (VOIDP)(EpamData_struc->DetTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DetTemp\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r13,start,NULL,edges, (VOIDP)(EpamData_struc->YTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read YTemp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r14,start,NULL,edges, (VOIDP)(EpamData_struc->InCur ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read InCur\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r15,start,NULL,edges, (VOIDP)(EpamData_struc->E1Temp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read E1Temp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r16,start,NULL,edges, (VOIDP)(EpamData_struc->Sen2ATemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Sen2ATemp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r17,start,NULL,edges, (VOIDP)(EpamData_struc->Sen2BTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Sen2BTemp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r18,start,NULL,edges, (VOIDP)(EpamData_struc->DeckTemp ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DeckTemp\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r19,start,NULL,edges, (VOIDP)(EpamData_struc->Cur ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Cur\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r20,start,NULL,edges, (VOIDP)(EpamData_struc->HtrCur ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read HtrCur\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r21,start,NULL,edges, (VOIDP)(EpamData_struc->PowBits ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PowBits\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_epam_data(odata, EpamData_struc);
  free(odata);
  return(retval);
}

void epam_data_error(int8 *mess)
  { fprintf(stderr,"EPAM DATA: %s\n",mess); }

void close_rd_epam_data() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
  SDendaccess(sds_id_r9);
  SDendaccess(sds_id_r10);
  SDendaccess(sds_id_r11);
  SDendaccess(sds_id_r12);
  SDendaccess(sds_id_r13);
  SDendaccess(sds_id_r14);
  SDendaccess(sds_id_r15);
  SDendaccess(sds_id_r16);
  SDendaccess(sds_id_r17);
  SDendaccess(sds_id_r18);
  SDendaccess(sds_id_r19);
  SDendaccess(sds_id_r20);
  SDendaccess(sds_id_r21);
}
/*   pack function    */

void pack_epam_data(uint8 *data, struct EpamData *EpamData_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EpamData_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EpamData_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EpamData_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_epam_data(uint8 *data, struct EpamData *EpamData_ptr)
{
int32 ptr=0;

   memcpy(&EpamData_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EpamData_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EpamData_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
