       SUBROUTINE PHACT8(HPHA,NEVENT,IBXORB,HBXSUM,GAIN,IMP)             00000100
C***********************************************************************00000200
C  SUBROUTINE PHACT8 IS A SPECIALIZED VERSION OF PHACNT FOR IMP-8.      00000300
C  THIS SUBROUTINE EXAMINES THE PHA DATA PASSED TO IT IN THE            00000400
C  CALLING SEQUENCE. IT GAIN GAIN CORRECTS THE DATA AND SCREENS IT      00000500
C  FOR FURTHER PROCESSING. DATA WHICH MEETS THE EVENT REQUIREMENTS      00000600
C  ARE TESTED AGAINST CHANNEL LIMITS.                                   00000700
C                                                                       00000800
C   IBOX = 1 ---> EVENT TYPE A.^B.^C                                    00000900
C   IBOX = 2 ---> EVENT TYPE (A+B)1.^B.^C                               00001000
C   IBOX = 3 ---> EVENT TYPE (A+B)2.^B.^C                               00001100
C   IBOX = 4 ---> EVENT TYPE A.B.^C                                     00001200
C   IBOX = 5 ---> EVENT TYPE (A+B)1.B.^C                                00001300
C   IBOX = 6 ---> EVENT TYPE (A+B)2.B.^C                                00001400
C   IBOX = 7 ---> EVENT TYPE D1.E.F.G                                   00001500
C   IBOX = 8 ---> EVENT TYPE D1.E.^F.^G                                 00001600
C   IBOX = 9 ---> EVENT TYPE D1.E.F.^G                                  00001700
C   IBOX =10 ---> EVENT TYPE (D+E)1.E1.^F.^G                            00001800
C   IBOX =11 ---> EVENT TYPE (D+E)2.E1.^F.^G                            00001900
C                                                                       00002000
      IMPLICIT INTEGER*2(H),LOGICAL*1(Q)                                00002100
C                                                                       00002200
C  CALLING SEQUENCE                                                     00002300
C    ARGUMENT  I/O    TYPE             DESCRIPTION                      00002400
C    HPHA      I      I*2 (ARRAY 320)  PHA DATA                         00002500
C    NEVENT    I/O    I*4 (ARRAY 8)    RUNNING TOTAL OF EACH EVENT      00002600
C                                      COUNT FOR A 5 MIN. INTERVAL.     00002700
C                                      INITIALIZED IN FLX8PR.           00002800
C    IBXORB    I/O    I*4 (ARRAY 144)  RUNNING TOTAL FOR AN ORBIT       00002900
C                                      OF EACH BOX COUNT.  INITIALIZED  00003000
C                                      IN FLX8PR.                       00003100
C    HBXSUM    I/O    I*2 (ARRAY 144)  RUNNING TOTAL FOR EACH 5 MIN.    00003200
C                                      INTERVAL OF EACH BOX COUNT.      00003300
C                                      INITIALIZED IN FLX8PR            00003400
C    GAIN      I      R*4 (ARRAY 5)    GAIN CORRECTION FACTORS          00003500
C    IMP       I      I*4              = 8 FOR IMP-8                    00003600
C                                                                       00003700
C  COMMON BOX IS USED TO ACCESS THE BLOCK DATA WHICH CONTAINS TABLES.   00003800
C  1/11/78 - INCORPORATION OF NEW MED STOPPING P AND ALPHA BOXES.       00003850
C                                                                       00003860
C  THIS VERSION INTERCEPTS BAD MED EVENTS (THAT CAUSE 0C5 DUE TO        00003870
C  ILLEGAL EVENT TYPE), PRINTS DIAGNOSTICS AND SKIPS THE RECORD.        00003880
C  IF MORE THAN 50 SUCH OCCURRENCES PER RUN, AN ABEND(888) IS TAKEN.    00003890
C                                                                       00003900
C  PROGRAMMERS: J. CHILDS AND E. ENG, COMPUTER SCIENCES CORP., JAN. 77  00004000
C  SATELLITE: IMP-8                                                     00004100
C                                                                       00004200
c  6/94
c
c  replace CALL PDUMP by write out the bad med information to unit 10
c
c  replace argument S in RAND by integer*4 iS
c
C***********************************************************************00004300
C                                                                       00004400
c6/94
      integer*4 imednt
c     real*8 DRAND
c
      INTEGER HA,HB,HD,HE,HF                                            00004500
      INTEGER*2 IABA(3,163),IABP(3,42),IAA(170),IAP(41),ILCNO(56)       00004600
      INTEGER*2 IDEA(3,435),IDEP(3,97)                                  00004700
      INTEGER*2 IDFHA(3,48),HB43(2,10),IDFHG(3,44),HB49(2,31),          00004800
     *HB50(2,29),HB51(2,27),IDFHK(3,42),HB53(2,20),IDFHM(3,30),         00004900
     *IDFHN(3,32),IDFHO(3,34)                                           00005000
      INTEGER*2 HB44(2,16),HB45(2,13),HB64(2,14),HB65(2,7),HB72(2,9),   00005100
     *          HB73(2,7),HB74(2,6),HB75(2,7),HB76(2,10),               00005200
     *          HB67(2,23),HB68(2,11),HB69(2,7)                         00005250
      DIMENSION HAA(128),HBB(128),HDD(128),HEE(128),HFF(128),           00005300
     *HPRTY1(128),HPRTY2(128),HMEDNT(128),QLEDGN(128),QMEDGN(128),      00005400
     *QMEDMF(128),HT1234(128)                                           00005500
      DIMENSION HPHA(640),NEVENT(11),GAIN(5),IBXORB(144)                00005600
      DIMENSION HBXSUM(144),MYBNO(6)                                    00005700
C  NUMBER OF BAD MED EVENT OCCURRENCES, IBAD.                           00005740
      DATA IBAD/50/                                                     00005750
      DATA MYBNO/7,10,9,11,0,8/                                         00005800
C                                                                       00005900
      COMMON/BOX/ IAA,IAP,IABA,IABP,ILCNO,IDEA,IDEP,IDFHA,HB43,         00006000
     *            IDFHG,HB49,HB50,HB51,IDFHK,HB53,IDFHM,IDFHN,IDFHO,    00006100
     *            HB44,HB45,HB64,HB65,HB72,HB73,HB74,HB75,HB76,         00006200
     *            HB67,HB68,HB69                                        00006250
C                                                                       00006300
C***********************************************************************00006400
C   CALL SUBROUTINE TO EXTRACT OUT PHA INFORMATION FROM PHA RECORD.     00006500
C   HPHA IS INPUT PHA RECORD, HAA THRU HFF ARE DATA POINTS FOR          00006600
C   DETECTORS A,B,C,D,E,AND F; HPRTY1 AND HPRTY2 ARE PRIORITIES FOR     00006700
C   LED AND MED EVENTS, HMEDNT IS MED EVENT TYPE; QLEDGN AND QMEDGN     00006800
C   ARE MED AND LED GAIN FACTORS (0 OR 1); AND QMEDMF ARE MED           00006900
C   MULTIPLICATION FACTORS.                                             00007000
C***********************************************************************00007100
c6/94
c     write(6,127) gain
127   format(' GAIN = ',5f10.3)
c
c     write(6,227) HB76
227   format(10i5)
c
C                                                                       00007200
      CALL EXTRCJ(HPHA,HAA,HBB,HDD,HEE,HFF,HPRTY1,                      00007300
     *HPRTY2,HMEDNT,QLEDGN,QMEDGN,QMEDMF,HT1234)                        00007400
C                                                                       00007500
c6/94
c
c     do l=1,128
c     write(6,128)l,HAA(l),HBB(l),HDD(l),HEE(l),HFF(l),HPRTY1(l),
c    *            HPRTY2(l),HMEDNT(l),HT1234(l),QLEDGN(l),QMEDGN(l),
c    *            QMEDMF(l)
c     end do
128   format(10i5,5x,3l3)
c
c
C   LOOP OVER PHA RECORD.                                               00007600
C                                                                       00007700
      DO 999 I=1,128                                                    00007800
C***********************************************************************00007900
C           L E D   DATA POINT                                          00008000
C***********************************************************************00008100
c6/94
      NBOX = 0
c
      HA = HAA(I)                                                       00008200
C   SKIP IF INVALID POINT.                                              00008300
      IF(HA.EQ.0) GO TO 130                                             00008400
C     IF T4 FLAG ON, SKIP LED EVENT.                                    00008500
C                                                                       00008600
      IT1234 = HT1234(I) - 1                                            00008700
      ITS = MOD(IT1234,2)                                               00008800
      IF(ITS .EQ. 1) GO TO 130                                          00008900
C                                                                       00009000
      HB = HBB(I)                                                       00009100
C                                                                       00009200
C     IF 1.LE.B.LE.4, CHECK IF CORRECTIONS TO B ARE NEEDED.             00009300
C                                                                       00009400
c6/94
c
      IF(.NOT.((HB.GE.1).AND.(HB.LE.4))) GO TO 103                      00009500
c
c     if (HB.lt.1.or.HB.gt.4) goto 103
C                                                                       00009600
      ITS = MOD(IT1234,4)                                               00009700
      IF((.NOT.QLEDGN(I)).AND.((ITS.EQ.2).OR.(ITS.EQ.3)))               00009800
     *     GO TO 10                                                     00009900
C                                                                       00010000
      IF((HB.LE.3).AND.((HA.LT.28).OR.((HA.GE.42).AND.(HA.LE.144))      00010100
     *  .OR.(HA.GE.166))) GO TO 10                                      00010200
C                                                                       00010300
      IF((HB.LE.2).AND.((HA.GE.28).AND.(HA.LT.42))) GO TO 10            00010400
      IF((HB.LE.2).AND.((HA.GT.144).AND.(HA.LT.166))) GO TO 10          00010500
       GO TO 103                                                        00010600
   10 HB = 0                                                            00010700
C   EVENT TYPE A.-B.-C                                                  00010800
C                                                                       00010900
  103 CONTINUE                                                          00011000
      IBOX = 1                                                          00011100
      IF(HT1234(I) .GE. 9) IBOX = 3                                     00011200
      IF(HB.GT.0) IBOX = 4                                              00011300
      IF((HT1234(I) .GE. 9).AND.(IBOX .EQ. 4)) IBOX = 6                 00011400
C  GAIN CORRECT DATA POINT                                              00011500
C  IF A OR NON-ZERO B GETS SHIFTED TO 0, SET TO 1.                      00011550
c6/94
c     HA = (HA + RAND(S))*GAIN(1)
c6/94
c     write(6,710) HA
710   format(' before HA = ',i5)
c 
      HA = (HA + RAND(iS))*GAIN(1)
c6/94
c     write(6,711) HA
711   format(' after HA = ',i5)
c 
      IF (HA.EQ.0) HA = 1                                               00011650
c     IF (HB.NE.0) HB = (HB + RAND(S))*GAIN(2)                          00011700
c6/94
c     write(6,712) HB
712   format(' before HB = ',i5)
c 
      IF (HB.NE.0) HB = (HB + RAND(iS))*GAIN(2)
c6/94
c     write(6,713) HB
713   format(' after HB = ',i5)
c 
      IF (HBB(I).NE.0.AND.HB.EQ.0) HB = 1                               00011750
      IF (QLEDGN(I)) GOTO 140                                           00011800
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00011900
C***********************************************************************00012000
C      L E D ---  HIGH GAIN                                             00012100
C***********************************************************************00012200
      IF((IBOX .EQ. 1).OR.(IBOX .EQ. 3))GO TO 106                       00012300
      IF(HB.GT.42)  GO TO 105                                           00012400
C   CHECK STOPPING PROTONS  A.B.-C   (BOXES 12-15)                      00012500
      IF(HA.LT.IABP(1,HB).OR.HA.GT.IABP(2,HB)) GOTO 105                 00012600
      NBOX = IABP(3,HB)                                                 00012700
      GO TO 115                                                         00012800
C   CHECK ALPHA BOXES  A.B.-C        (BOXES 16-19)                      00012900
  105 IF(HB.GT.162) GO TO 130                                           00013000
      IF(HA.LT.IABA(1,HB).OR.HA.GT.IABA(2,HB)) GOTO 130                 00013100
      NBOX = IABA(3,HB)                                                 00013200
      GO TO 115                                                         00013300
C   STOPPING PROTONS   A.-B.-C       (BOXES 1-6)                        00013400
  106 IF(HA.LT.9)  GO TO 130                                            00013500
      IF(HA.GT.42)  GO TO 108                                           00013600
      IF(IAP(HA).EQ.0) GO TO 108                                        00013700
      NBOX = IAP(HA)                                                    00013800
      GO TO 115                                                         00013900
C   STOPPING ALPHAS    A.-B.-C       (BOXES 7-11)                       00014000
  108 IF(HA.GT.170) GO TO 130                                           00014100
      IF(IAA(HA).EQ.0) GO TO 130                                        00014200
      NBOX = IAA(HA)                                                    00014300
C                                                                       00014400
  115 CONTINUE                                                          00014500
C   ADJUST BOX NUMBERS FOR 'ALPHA-ONLY' SLANT THRESHOLDS.               00014650
C   BOXES 1-19 GO TO 80,98 AS  A  GOES TO  (A&B)2                       00014660
      IF((IBOX .EQ. 3).OR.(IBOX .EQ. 6))NBOX = NBOX + 79                00014700
C   BOXES 30-41 GO TO 99-110 AS D.E GOES TO (D&E)1.E                    00014710
      MBOX = NBOX                                                       00014715
      IF (IBOX.EQ.10.AND.MBOX.LE.41) NBOX = NBOX + 69                   00014720
C   BOXES 77-8 GO TO 131-2 FOR ABOVE REASON.                            00014730
      IF (IBOX.EQ.10.AND.MBOX.GT.41) NBOX = NBOX + 54                   00014740
C                                                                       00014900
C++++ HERE INCREMENT BOX COUNTS AND EVENT COUNT                         00015000
C                                                                       00015100
      HBXSUM(NBOX) = HBXSUM(NBOX) + 1                                   00015200
      IBXORB(NBOX) = IBXORB(NBOX) + 1                                   00015300
c6/94
c     write(6,890) NBOX,HBXSUM(NBOX),IBXORB(NBOX)
890   format(' NBOX HBXSUM IBXORB =',i3,2x,2i10)
c
      IF (IBOX.GT.6) GOTO 180                                           00015400
      GOTO 130                                                          00015500
C                                                                       00015600
C***********************************************************************00015700
C      L E D ---  LOW GAIN.                                             00015800
C***********************************************************************00015900
C  EVENT TYPE (A+B)1.^B.^C           (BOXES 20-23)                      00016000
  140 IBOX = 2                                                          00016100
C  EVENT TYPE (A+B)1.B.^C                                               00016200
      IF(HB.GT.0) IBOX = 5                                              00016300
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00016400
C   CALL ROUTINE TO PROCESS LED LOW GAIN BOXES.                         00016500
      CALL GETBX8(HA,HB,NBOX,IFLAG)                                     00016600
      IF (NBOX.EQ.0) GOTO 130                                           00016700
      IF (NBOX.NE.0) GOTO 115                                           00016800
C                                                                       00016900
C***********************************************************************00017000
C           M E D   DATA POINT                                          00017100
C***********************************************************************00017200
C                                                                       00017300
130   HD = HDD(I)                                                       00017400
C   SKIP IF INVALID EVENT.                                              00017500
      IF(HD.EQ.0) GO TO 180                                             00017600
      HE = HEE(I)                                                       00017700
      HF = HFF(I)                                                       00017800
C                                                                       00017805
C   CHECK FOR BAD MED DATA. IF FOUND, PDUMP AND SKIP RECORD.            00017810
      IF (HE.LE.1023.AND.HMEDNT(I).LE.6) GOTO 135                       00017815
      PRINT 13000,I,HD,HE,HF,HMEDNT(I)                                  00017825
13000 FORMAT(1X,'***** BAD MED EVENT ENCOUNTERED AND SKIPPED *****',    00017830
     */10X,5I10)                                                        00017835
c6/94
c
c     CALL PDUMP(HPHA(1),HPHA(320),0)                                   00017837
c
c     write(10,123) HPHA(1),HPHA(320)
123   format(2i15)
c
      IBAD = IBAD - 1                                                   00017840
      IF (IBAD.LE.0) CALL ABEND(888)                                    00017845
      GOTO 181                                                          00017847
135   CONTINUE                                                          00017850
C                                                                       00017855
c6/94
c     IBOX = MYBNO(HMEDNT(I))                                           00017900
      imednt=HMEDNT(I)
      IBOX = MYBNO(imednt)   
c
      IF (IBOX.EQ.11.AND..NOT.QMEDGN(I)) GOTO 180                       00018000
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00018100
C   SKIP IF MED LOW GAIN EVENT.                                         00018200
      IF (QMEDGN(I)) GOTO 180                                           00018300
C   IF STOPPING EVENT (I.E., IBOX .NE. 7 NOR 9), MUST                   00018305
C   NORMALIZE TO IMP-8 STANDARD, NOT IMP-6 (AS FROM GAIN ARRAY).        00018310
C   USING FACTORS D(IMP-6)/D(IMP-8)=.8522, E(IMP-6)/E(IMP-8)=.9386      00018315
      GAIND = GAIN(3)                                                   00018320
      GAINE = GAIN(4)                                                   00018325
      IF (IBOX.NE.7.AND.IBOX.NE.9) GAIND = GAIND/.8522                  00018330
      IF (IBOX.NE.7.AND.IBOX.NE.9) GAINE = GAINE/.9386                  00018335
C  GAIN CORRECT MED POINTS                                              00018400
C  IF D OR E SHIFTED TO 0, SET TO 1.                                    00018450
c6/94
c     HD = (HD + RAND(S))*GAIND                                         00018500
c6/94
c     write(6,714) HD
714   format(' before HD = ',i5)
c 
      HD = (HD + RAND(iS))*GAIND
c6/94
c     write(6,715) HD
715   format(' after  HD = ',i5)
c 
      IF (HD.EQ.0) HD = 1                                               00018550
c     HE = (HE + RAND(S))*GAINE
c6/94
c     write(6,716) HE
716   format(' before HE = ',i5)
c 
      HE = (HE + RAND(iS))*GAINE
c6/94
c     write(6,717) HE
717   format(' after  HE = ',i5)
c 
      IF (HE.EQ.0) HE = 1                                               00018650
C   GAIN CORRECT F AND MULTIPLY BY 2 (IF F NONZERO).                    00018700
c     IF (HFF(I).NE.0) HF = (HF + RAND(S))*GAIN(5)
c6/94
c     write(6,718) HF
718   format(' before HF = ',i5)
c 
      IF (HFF(I).NE.0) HF = (HF + RAND(iS))*GAIN(5)
c6/94
c     write(6,719) HF
719   format(' after  HF = ',i5)
c 
      IF (HFF(I).NE.0) HF = 2*HF                                        00018900
c6/94
c     write(6,720) IBOX,HD,HE,HF
720   format(' IBOX HD HE HF  = ',4i5)
c
c9/96 if (IBOX.eq.8) then
c9/96 write(22,222) IBOX,I,HDD(I),HEE(I),HFF(I),HD,HE,HF,NBOX
c9/96 end if
c
C  PROCESS DATA POINT                                                   00019000
      GO TO (180,180,180,180,180,180,180,146,150,146,180),IBOX          00019100
C                                                                       00019110
C   CHECK FOR MED ELECTRON BOXES.                                       00019120
146   IF (HD.GE.2.AND.HD.LE.35.AND.HE.GE.3.AND.HE.LE.16)                00019130
     *              CALL FLX8EL(HD,HE,HBXSUM,IBXORB)                    00019140
C                                                                       00019150
C   STOPPING PROTONS  D.E.-F.-G      (BOXES 30-35)                      00019200
      IF(HE.LT.4) GO TO 180                                             00019300
      IF(HE.GT.97) GO TO 147                                            00019400
c     write(22,222) IBOX,I,HDD(I),HEE(I),HFF(I),HD,HE,HF,NBOX
      IF(HD.LT.IDEP(1,HE).OR.HD.GT.IDEP(2,HE)) GOTO 147                 00019500
      NBOX = IDEP(3,HE)                                                 00019600
c6/94
c     write(22,222) IBOX,HD,HE,HF,NBOX
222   format(' IBOX I HDD HEE HFF HD HE HF NBOX = ',9i5)
c
      GO TO 115                                                         00019700
  147 CONTINUE                                                          00019800
      IF (HE.LT.16.OR.HE.GT.435) GO TO 180                              00019900
C   STOPPING ALPHAS   D.E.-F.-G      (BOXES 36-41)                      00020000
      IF(HD.LT.IDEA(1,HE).OR.HD.GT.IDEA(2,HE)) GOTO 180                 00020100
      NBOX = IDEA(3,HE)                                                 00020200
      GO TO 115                                                         00020300
C                                                                       00020400
C  PENETRATING PARTICLES -- D.E.F.^G                                    00020500
C                                                                       00020600
C   FIRST CHECK HELIUM BOXES (42-56) AND THEN PROTON BOXES (60-76).     00020700
C  LIMITS: 242<E<381  67<F<113 OR 151<F<369  (BOXES 42,43)              00020800
150   IF(HE.LT.243) GO TO 152                                           00020900
      IF(HE.GT.435) GO TO 165                                           00021000
      IF(HF.LT.68) GO TO 165                                            00021100
      IF(HF.GT.112) GO TO 151                                           00021200
      IF(HD.LT.IDFHA(1,HF-67).OR.HD.GT.IDFHA(2,HF-67)) GOTO 165         00021300
      NBOX = IDFHA(3,HF-67)                                             00021400
      GO TO 115                                                         00021500
C   FORWARD-MOVING PARTICLES IN THIS E-BAND.          (BOX 43)          00021600
151   IF (HD.LT.68.OR.HD.GT.107) GOTO 165                               00021680
      JHD = (HD-64)/4                                                   00021760
      IF (HF.LT.HB43(1,JHD).OR.HF.GT.HB43(2,JHD)) GOTO 165              00021840
      NBOX = 43                                                         00021920
      GO TO 115                                                         00022000
C                                                                       00022100
C  LIMITS: 205<E<243  66<F<99               (BOX 44)                    00022200
152   IF (HE.LT.206) GOTO 155                                           00022300
      IF (HF.LT.67) GOTO 165                                            00022400
      IF (HF.GT.98) GOTO 153                                            00022500
      L = (HF+1)/2 - 33                                                 00022600
      IF (HD.LT.HB44(1,L).OR.HD.GT.HB44(2,L)) GOTO 165                  00022700
      NBOX = 44                                                         00022800
      GOTO 115                                                          00022900
C                                                                       00023000
C  FORWARD MOVING PARTICLES IN SAME E-RANGE  (BOX 45)                   00023100
153   IF (HD.LT.64.OR.HD.GT.89) GOTO 165                                00023200
      L = HD/2 - 31                                                     00023300
      IF (HF.LT.HB45(1,L).OR.HF.GT.HB45(2,L)) GOTO 165                  00023400
      NBOX = 45                                                         00023500
      GOTO 115                                                          00023600
C                                                                       00023700
C  LIMITS: 168<E<206  53<F<97 OR 79<F<141    (BOX 48)                   00023800
155   IF(HE.LT.169) GO TO 158                                           00023900
      IF(HE.GT.205) GO TO 165                                           00024000
      IF(HF.LT.54) GO TO 165                                            00024100
      IF(HF.GT.96) GO TO 157                                            00024200
      IF(HD.LT.IDFHG(1,HF-53).OR.HD.GT.IDFHG(2,HF-53)) GOTO 157         00024300
      NBOX = IDFHG(3,HF-53)                                             00024400
      GO TO 115                                                         00024500
C  FORWARD MOVING PARTICLES IN THIS E-BAND            (BOX 49)          00024600
  157 IF(HF.LT.80.OR.HF.GT.141) GOTO 165                                00024700
      L = HF/2 - 39                                                     00024775
      IF (HD.LT.HB49(1,L).OR.HD.GT.HB49(2,L)) GOTO 165                  00024850
      NBOX = 49                                                         00024925
      GO TO 115                                                         00025000
C                                                                       00025100
C  LIMITS: 145<E<169  AND  51<F<109          (BOX 50)                   00025200
  158 IF(HE.LT.146) GO TO 159                                           00025300
      IF(HE.GT.168) GO TO 165                                           00025400
      IF(HF.LT.52.OR.HF.GT.109) GOTO 165                                00025480
      L = HF/2 - 25                                                     00025560
      IF (HD.LT.HB50(1,L).OR.HD.GT.HB50(2,L)) GOTO 165                  00025640
      NBOX = 50                                                         00025720
      GO TO 115                                                         00025800
C                                                                       00025900
C  LIMITS: 117<E<146  AND  39<F<93           (BOX 51)                   00026000
  159 IF(HE.LT.118) GO TO 160                                           00026100
      IF(HE.GT.145) GO TO 165                                           00026200
      IF(HF.LT.40.OR.HF.GT.93) GOTO 165                                 00026300
      L = HF/2 - 19                                                     00026375
      IF (HD.LT.HB51(1,L).OR.HD.GT.HB51(2,L)) GOTO 165                  00026450
      NBOX = 51                                                         00026525
      GO TO 115                                                         00026600
C                                                                       00026700
C  LIMITS: 102<E<118  AND  33<F<75           (BOX 52)                   00026800
  160 IF(HE.LT.103) GO TO 161                                           00026900
      IF(HE.GT.117) GO TO 165                                           00027000
      IF(HF.LT.34.OR.HF.GT.75) GOTO 165                                 00027100
      IF(HD.LT.IDFHK(1,HF-33).OR.HD.GT.IDFHK(2,HF-33)) GOTO 165         00027200
      NBOX = IDFHK(3,HF-33)                                             00027300
      GO TO 115                                                         00027400
C                                                                       00027500
C  LIMITS: 86<E<103  AND  29<F<69            (BOX 53)                   00027600
  161 IF(HE.LT.87) GO TO 162                                            00027700
      IF(HE.GT.102) GO TO 165                                           00027800
      IF(HF.LT.30.OR.HF.GT.69) GOTO 165                                 00027900
      L = HF/2 - 14                                                     00027950
      IF(HD.LT.HB53(1,L).OR.HD.GT.HB53(2,L)) GOTO 165                   00028000
      NBOX = 53                                                         00028100
      GO TO 115                                                         00028200
C                                                                       00028300
C  LIMITS: 75<E<87  AND  25<F<55              (BOX 54)                  00028400
  162 IF(HE.LT.76) GO TO 163                                            00028500
      IF(HE.GT.86) GO TO 165                                            00028600
      IF(HF.LT.26.OR.HF.GT.55) GOTO 165                                 00028700
      IF(HD.LT.IDFHM(1,HF-25).OR.HD.GT.IDFHM(2,HF-25)) GOTO 165         00028800
      NBOX = IDFHM(3,HF-25)                                             00028900
      GO TO 115                                                         00029000
C                                                                       00029100
C  LIMITS: 66<E<76  AND  21<F<53             (BOX 55)                   00029200
  163 IF(HE.LT.67) GO TO 164                                            00029300
      IF(HE.GT.75) GO TO 165                                            00029400
      IF(HF.LT.22.OR.HF.GT.53) GOTO 165                                 00029500
      IF(HD.LT.IDFHN(1,HF-21).OR.HD.GT.IDFHN(2,HF-21)) GOTO 165         00029600
      NBOX = IDFHN(3,HF-21)                                             00029700
      GO TO 115                                                         00029800
C                                                                       00029900
C  LIMITS: 60<E<67  AND  17<F<51             (BOX 56)                   00030000
  164 IF(HE.LT.61) GO TO 165                                            00030100
      IF(HE.GT.66) GO TO 165                                            00030200
      IF(HF.LT.18.OR.HF.GT.51) GOTO 165                                 00030300
      IF(HD.LT.IDFHO(1,HF-17).OR.HD.GT.IDFHO(2,HF-17)) GOTO 165         00030400
      NBOX = IDFHO(3,HF-17)                                             00030500
      GO TO 115                                                         00030600
C                                                                       00030700
C***********************************************************************00030800
C   PENETRATING PROTON BOXES    D.E.F.-G                                00030900
C***********************************************************************00031000
C                                                                       00031100
165   CONTINUE                                                          00031200
C                                                                       00031300
C  LIMITS:  E:76-91, D:57-240, F:17-38          (BOX 60)                00031400
      IF (HE.LT.76) GOTO 167                                            00031500
      IF (HE.GT.97) GOTO 180                                            00031600
      IF (HD.LT.57.OR.HD.GT.240) GOTO 166                               00031700
      IF (HF.LT.17.OR.HF.GT.38)  GOTO 166                               00031800
      NBOX = 60                                                         00031900
      GOTO 115                                                          00032000
C                                                                       00032100
C  LIMITS:  E:76-91, D:14-27, F:72-161           (BOX 61)               00032200
166   IF (HD.LT.14.OR.HD.GT.27) GOTO 180                                00032240
      IF (HF.LT.72.OR.HF.GT.161) GOTO 180                               00032280
      NBOX = 61                                                         00032320
      GOTO 115                                                          00032360
C                                                                       00032400
C   LIMITS:   E:66-75, D:59-178, F:13-32         (BOX 62)               00032500
167   IF (HE.LT.66) GOTO 170                                            00032600
      IF (HD.LT.59.OR.HD.GT.178) GOTO 169                               00032700
      IF (HF.LT.13.OR.HF.GT.32) GOTO 169                                00032800
      NBOX = 62                                                         00032900
      GOTO 115                                                          00033000
C                                                                       00033100
C  FORWARD, SAME E,  D:13-26, F:73-178           (BOX 63)               00033200
169   IF (HD.LT.14.OR.HD.GT.27) GOTO 180                                00033300
      IF (HF.LT.74.OR.HF.GT.179) GOTO 180                               00033400
      NBOX = 63                                                         00033500
      GOTO 115                                                          00033600
C                                                                       00033700
C   LIMITS:  E:57-65, F:11<38, D:39<200           (BOX 64)              00033800
170   IF (HE.LT.57) GOTO 172                                            00033900
      IF (HF.LT.11) GOTO 180                                            00034000
      IF (HF.GT.38) GOTO 171                                            00034100
      L = (HF+1)/2 - 5                                                  00034200
      IF (HD.LT.HB64(1,L).OR.HD.GT.HB64(2,L)) GOTO 180                  00034300
      NBOX = 64                                                         00034400
      GOTO 115                                                          00034500
C                                                                       00034600
C  FORWARD, SAME E,  D:11<24, F:51<166            (BOX 65)              00034700
171   IF (HD.LT.12.OR.HD.GT.25) GOTO 180                                00034800
      L = (HD+1)/2 - 5                                                  00034900
      IF (HF.LT.HB65(1,L).OR.HF.GT.HB65(2,L)) GOTO 180                  00035000
      NBOX = 65                                                         00035100
      GOTO 115                                                          00035200
C                                                                       00035207
C  LIMITS E: 49-56, F: 16-37, D<37            (BOX 67)                  00035214
  172 IF(HE.LT.49) GO TO 1721                                           00035221
      IF (HD.LT.14.OR.HD.GT.36) GOTO 180                                00035228
      IF (HF.LT.HB67(1,HD-13).OR.HF.GT.HB67(2,HD-13)) GOTO 180          00035235
      NBOX = 67                                                         00035242
      GO TO 115                                                         00035249
C                                                                       00035256
C  LIMITS E: 40-48, F: 14-34, D<31           (BOX 68)                   00035263
 1721 IF(HE.LT.40) GO TO 1722                                           00035270
      IF (HF.LT.14.OR.HF.GT.34) GOTO 180                                00035277
      L = HF/2 - 6                                                      00035284
      IF (HD.LT.HB68(1,L).OR.HD.GT.HB68(2,L)) GOTO 180                  00035291
      NBOX = 68                                                         00035298
      GO TO 115                                                         00035305
C                                                                       00035312
C  LIMITS E: 35-39, F: 12-24                 (BOX 69)                   00035319
 1722 IF(HE.LT.35) GO TO 1723                                           00035326
      IF (HF.LT.12.OR.HF.GT.24) GOTO 180                                00035333
      L = HF/2 - 5                                                      00035340
      IF (HD.LT.HB69(1,L).OR.HD.GT.HB69(2,L)) GOTO 180                  00035347
      NBOX = 69                                                         00035361
      GO TO 115                                                         00035368
C                                                                       00035400
C   LIMITS:  E:28-34, F:7<24, D:8<23              (BOX 72)              00035500
1723  IF (HE.LT.28) GOTO 173                                            00035600
      IF (HF.LT.8.OR.HF.GT.24) GOTO 180                                 00035700
      L = (HF+1)/2 - 3                                                  00035800
      IF (HD.LT.HB72(1,L).OR.HD.GT.HB72(2,L)) GOTO 180                  00035900
      NBOX = 72                                                         00036000
      GOTO 115                                                          00036100
C                                                                       00036200
C   LIMITS:  E:25-27,  F:7<20,  D:7<18            (BOX 73)              00036300
173   IF (HE.LT.25) GOTO 174                                            00036400
      IF (HF.LT.8.OR.HF.GT.20) GOTO 180                                 00036500
      L = (HF+1)/2 - 3                                                  00036600
      IF (HD.LT.HB73(1,L).OR.HD.GT.HB73(2,L)) GOTO 180                  00036700
      NBOX = 73                                                         00036800
      GOTO 115                                                          00036900
C                                                                       00037000
C   LIMITS:  E:21-24,  F:7<18,  D:6<17            (BOX 74)              00037100
174   IF (HE.LT.21) GOTO 175                                            00037200
      IF (HF.LT.8.OR.HF.GT.18) GOTO 180                                 00037300
      L = (HF+1)/2 - 3                                                  00037400
      IF (HD.LT.HB74(1,L).OR.HD.GT.HB74(2,L)) GOTO 180                  00037500
      NBOX = 74                                                         00037600
      GOTO 115                                                          00037700
C                                                                       00037800
C   LIMITS:  E:17-20,  F:3<16,  D:3<15             (BOX 75)             00037900
175   IF (HE.LT.17) GOTO 176                                            00038000
      IF (HF.LT.4.OR.HF.GT.16) GOTO 180                                 00038100
      L = (HF+1)/2 - 1                                                  00038200
      IF (HD.LT.HB75(1,L).OR.HD.GT.HB75(2,L)) GOTO 180                  00038300
      NBOX = 75                                                         00038400
      GOTO 115                                                          00038500
C                                                                       00038600
C   LIMITS:  E:14-16,  F:1<20,  D:3<16             (BOX 76)             00038700
c176   write(6,850) HD,HE,HF
850   format(' PASS 176 HD HE HF = ',3i5)
c
176   IF (HE.LT.14) GOTO 177                                            00038800
      IF (HF.LT.2.OR.HF.GT.20) GOTO 180                                 00038900
      L = (HF+1)/2                                                      00039000
c     write(6,852) L,HB76(1,L),HB76(2,L)
852   format(' PASS 176 L HB76(1,L) HB76(2,L)  = ',3i5)
c
      IF (HD.LT.HB76(1,L).OR.HD.GT.HB76(2,L)) GOTO 180                  00039100
      NBOX = 76                                                         00039200
c     write(6,851) NBOX
851   format(' PASS 176 NBOX = ',i5)
c
      GOTO 115                                                          00039300
C                                                                       00039400
177   CONTINUE                                                          00039500
  180 CONTINUE                                                          00039600
C                                                                       00039605
c     write(6,251) I,NBOX
251   format(2i10)
999   continue
c
  181 CONTINUE                                                          00039610
      RETURN                                                            00040000
      END                                                               00040100
