      SUBROUTINE FLXGMD(IMP,IORB,IYR,ISTART,GAINTB,IADDR,QP,QBAD)       00000010
C                                                                       00000020
C***********************************************************************00000030
C                                                                       00000040
C   THIS SUBROUTINE RETURNS THE IMP   MED GAIN FACTORS (D, E, AND F)    00000050
C     GIVEN EITHER THE ORBIT OR THE YEAR AND DECISECONDS OF YEAR.       00000060
C   THE GAIN TABLE SHOULD BE ON FORTRAN UNIT NUMBER 36.                 00000070
C   TABLE ENTRIES OF ZERO OR -1.0 WILL YIELD THE ALTERNATE              00000080
C     RETURNS NUMBER 1 OR 2, RESPECTIVELY.                              00000090
C   RENORMALIZATION IS POSSIBLE WITH THE VARIABLES XNORM BELOW.         00000100
C   THE GAIN TABLE VALUES ARE PRINTED OUT IF QP IS TRUE.                00000110
C                                                                       00000120
C   MODIFIED BY HENRY LO ON MARCH 1989 TO CONFORM TO                            
C   VS-FORTRAN COMPILER SYNTAX                                                  
C                                                                               
c     5/94
c
c     replace DREAD by read
c
C***********************************************************************00000130
C                                                                       00000140
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000150
      REAL*4 XNORM(3,3)/3*1.0,1.0  ,1.0  ,1.0  ,3*1.0/                  00000160
      INTEGER*4 IGNUNT(3)/36,37,38/                                     00000170
      DIMENSION ARRAY(8,50),IRRAY(8,50),HRRAY(2,8,50),GAINTB(3),        00000180
     * BRRAY(4,50),IBRAY(4,50),HBRAY(2,4,50)                            00000190
      EQUIVALENCE (ARRAY(1,1),IRRAY(1,1),HRRAY(1,1,1)),                 00000200
     *            (BRRAY(1,1),IBRAY(1,1),HBRAY(1,1,1))                  00000210
C                                                                       00000220
C                                                                       00000230
      QBAD = .FALSE.                                                    00000240
      GAINTB(1) = 1.0                                                   00000250
      GAINTB(2) = 1.0                                                   00000260
      GAINTB(3) = 1.0                                                   00000270
      IF(IMP .GT. 6) GO TO 200                                          00000280
      IF (IORB.EQ.0) GOTO 10                                            00000290
C   HERE, USE ORBIT FOR TABLE LOOKUP.                                   00000300
      IRECRD = (IORB-1)/50 + 1                                          00000310
      ILOC = IORB - (IRECRD-1)*50                                       00000320
C   FETCH GAIN SHIFT TABLE RECORD.
c5/94
c
c     CALL DREAD(36,IRECRD,ARRAY,*100)
c
      read(unit=36,rec=IRECRD,err=100) ARRAY
c
      GOTO 30                                                           00000350
C   HERE, USE TIMES FOR TABLE LOOKUP.                                   00000360
 10   IDAY = ISTART/864000 + 1                                          00000370
      MSEC = 100*(ISTART - 864000*(IDAY-1))                             00000380
      DO 20 IBLK=1,7
c5/94
c
c       CALL DREAD(36,IBLK,ARRAY,*100)
c
        read(unit=36,rec=IBLK,err=100) ARRAY
c
        DO 20 IREC = 1,50                                               00000410
             KYR = HRRAY(1,4,IREC)                                      00000420
           IF (IYR.GT.KYR) GOTO 20                                      00000430
           IF (IYR.LT.KYR) GOTO 15                                      00000440
             KDAY = HRRAY(2,4,IREC)                                     00000450
           IF (IDAY.GT.KDAY) GOTO 20                                    00000460
           IF (IDAY.LT.KDAY) GOTO 15                                    00000470
           IF (MSEC.GE.IRRAY(5,IREC)) GOTO 20                           00000480
 15        ILOC = IREC                                                  00000490
           GOTO 30                                                      00000500
 20        CONTINUE                                                     00000510
      GOTO 1000                                                         00000520
 30   GD = ARRAY(6,ILOC)                                                00000530
      GE = ARRAY(7,ILOC)                                                00000540
      GF = ARRAY(8,ILOC)                                                00000550
      IADDR = HRRAY(1,1,ILOC)                                           00000555
      GO TO 35                                                          00000560
  200 CONTINUE                                                          00000570
C   IMP7 OR 8 GAIN TABLE LOOK-UP                                        00000580
      IF(IORB .NE. 0) GO TO 300                                         00000590
C   HERE, USE TIMES FOR TABLE LOOK-UP                                   00000600
      IDAY = ISTART/864000 + 1                                          00000610
      NDAYS = JDAYS(IYR,IDAY)                                           00000620
      ISORB = (NDAYS/4) + 1                                             00000630
C     IF(ISORB .GT. 700) GO TO 1000                                     00000640
      IF((IMP .EQ. 7) .AND. (ISORB .LT. 1)) GO TO 1000                  00000650
      IF((IMP.EQ.7) .AND. (ISORB.GT.700)) GO TO 1000                    00000651
      IF((IMP .EQ. 8) .AND. (ISORB. LT. 101)) GO TO 1000                00000660
  300 CONTINUE                                                          00000670
C   HERE, USE ORBIT NO. FOR TABLE LOOK-UP                               00000680
      IF(IORB .NE. 0) ISORB = IORB                                      00000690
      IRECRD = (ISORB - 1)/50 + 1                                       00000700
      ILOC = (ISORB) - (IRECRD - 1)*50                                  00000710
c5/94
c
c     CALL DREAD(IGNUNT(IMP-5),IRECRD,BRRAY,*100)                       00000720
c
      read(unit=IGNUNT(IMP-5),rec=IRECRD,err=100) BRRAY
c
c     write(16,125) ILOC,BRRAY(2,ILOC),BRRAY(3,ILOC),BRRAY(4,ILOC)
125   format(i5,3f7.3)
c
      GD = BRRAY(2,ILOC)                                                00000730
      GE = BRRAY(3,ILOC)                                                00000740
      GF = BRRAY(4,ILOC)                                                00000750
      IADDR = HBRAY(1,1,ILOC)                                           00000755
   35 CONTINUE                                                          00000760
C   TEST FOR ENTRIES OF 0.0 (UNKNOWN) OR -1.0 (BAD VALUE).              00000770
      IF (GD.EQ.0.0.OR.GE.EQ.0.0.OR.GF.EQ.0.0) QBAD = .TRUE.            00000780
      IF (GD.EQ.-1..OR.GE.EQ.-1..OR.GF.EQ.-1.) QBAD = .TRUE.            00000790
C   SET GAIN FACTORS.                                                   00000800
      GAINTB(1) = GD*XNORM(1,IMP-5)                                     00000810
      GAINTB(2) = GE*XNORM(2,IMP-5)                                     00000820
      GAINTB(3) = GF*XNORM(3,IMP-5)                                     00000830
      IF (QP) PRINT 40,IORB,IYR,ISTART,GAINTB                           00000840
 40   FORMAT(' ****FLXGMD: ',3I10,3F15.5)                               00000850
      RETURN                                                            00000860
C                                                                       00000870
100   PRINT 101,IMP                                                     00000880
101   FORMAT('1*****FLXGMD: IO ERROR READING IMP-',                     00000890
     * I1,' GAIN SHIFT TABLE.')                                         00000900
      STOP                                                              00000910
C                                                                       00000920
1000  PRINT 1001,IMP,IYR,ISTART                                         00000930
1001  FORMAT('1*****FLXGMD: PROBLEM WITH LOCATING ORBIT IN IMP-',I1,1X, 00000940
     *'GAIN TABLE WITH YEAR AND DECISECONDS -',2I12)                    00000950
      STOP                                                              00000960
      END                                                               00000970
