CH1   SUBROUTINE  FLXPAA                                                00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   ROUTINE TO CHECK IF IMP-6 IS CROSSING PERIGEE ALTITUDE.           00000040
CH THIS MODULE CALCULATES THE TIMES THAT IMP-6 GOES THROUGH             00000050
CH THE PERIGEE ALTITUDE.                                                00000060
CH INPUT IS AN ALTITUDE (XPERIG). A FLUX RECORD (IFLUX(I,1)),           00000070
CH AND A START TIME (ISTART).                                           00000080
CH OUTPUT ARE TWO ARRAYS CONTAINING DECISECONDS RELATIVE TO             00000090
CH IYR1 WHICH CORRESPOND TO THE PASSAGE THRU XPERIG.  EITHER GOING      00000100
CH UP (IUP(I)) OR DOWN (IDN(I)).  JUP AND JDN ARE THE NUMBER            00000110
CH OF ENTRIES IN EACH ARRAY.                                            00000120
CH3  CALLING ROUTINES:  FLXPSS                                          00000130
CH                                                                      00000140
CH4  SUBROUTINES CALLED:  NONE                                          00000150
CH                                                                      00000160
CH5  VARIABLE CROSS REFERENCE:                                          00000170
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000180
CH                                                                      00000190
CH6  METHOD:                                                            00000200
CH                                                                      00000210
CH7  PROGRAMMER:  J. CHILDS, 2/77.                                      00000220
CH                                                                      00000230
CH8   MODIFICATION:  P. SCHUSTER, 10/86 ; IMPLEMENT MCGUIRE             00000231
CH8                  CHANGES ;  NEW COMMON/FRAME/ ONLY CHANGE           00000232
CH                                                                      00000233
CH9  IMP-6/7/8, FLUX PLOT,  FLXPAA, V2.                                 00000240
CH**********************************************************************00000250
CP  FLXPAA ***************                                              00000260
      SUBROUTINE FLXPAA                                                 00000270
      IMPLICIT INTEGER*2(H),LOGICAL*1(Q)                                00000280
      DIMENSION RFLUX(150,3),HFLUX(2,150,3)                             00000290
      DATA ALTOLD/0.0/                                                  00000300
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00000317
C          TO 50 (FRAMES)                                               00000318
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00000319
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00000320
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00000321
C                                                                       00000322
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 00000323
      COMMON /REKORD/ IFLUX(150,3)                                      00000330
      EQUIVALENCE (IFLUX(1,1),HFLUX(1,1,1),RFLUX(1,1))                  00000340
CP                                                                      00000350
      ALTNEW = RFLUX(5,1)                                               00000360
      I1 = IFLUX(1,1)                                                   00000370
      I2 = HFLUX(1,2,1)                                                 00000380
      IF (ALTNEW.EQ.0.0) GO TO 70                                       00000390
      IF (ALTOLD.EQ.0.0) GO TO 60                                       00000400
      IF (ALTNEW-ALTOLD) 40,70,50                                       00000410
CP                                                                      00000420
40    IF (.NOT.(ALTOLD.GE.XPERIG.AND.ALTNEW.LT.XPERIG)) GO TO 60        00000430
      JDN = JDN + 1                                                     00000440
      ITEMP = ((XPERIG-ALTNEW)/(ALTOLD-ALTNEW))*IDIFF(I1,I2,J1,J2)      00000450
      IDN(JDN) = ISTART + IDIFF(I1,I2,ISTART,IYR1) - ITEMP              00000460
      GO TO 60                                                          00000470
CP                                                                      00000480
50    IF (.NOT.(ALTNEW.GE.XPERIG.AND.ALTOLD.LT.XPERIG)) GO TO 60        00000490
      JUP = JUP + 1                                                     00000500
      ITEMP = ((ALTNEW-XPERIG)/(ALTNEW-ALTOLD))*IDIFF(I1,I2,J1,J2)      00000510
      IUP(JUP) = ISTART + IDIFF(I1,I2,ISTART,IYR1) - ITEMP              00000520
CP                                                                      00000530
60    ALTOLD = ALTNEW                                                   00000540
CP                                                                      00000550
70    J1 = I1                                                           00000560
      J2 = I2                                                           00000570
      RETURN                                                            00000580
      END                                                               00000590
