CH1   SUBROUTINE FLXPA                                                  00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   CALCULATES FLUX FOR A PLOT FRAME.                                 00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPMN                                          00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  FLXPSS, FLXPST, FLXPAB                        00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5  DELJAY(500,3)   R*4    I,O   'FLUX' ERROR                          00000120
CH5  ELOBN(100)      R*4     I    LOWER BIN ENERGY, MEV                 00000130
CH5  EUPBN(100)      R*4     I    UPPER BIN ENERGY, MEV                 00000140
CH5  GEOM(100)       R*4     I    GEOMETRY FACTOR, STER*CM**2           00000150
CH5  IAVLEN          I*4     I    AVERAGING INTERVAL, DECISEC           00000160
CH5  IMP(100)        I*4     I    IMP NUMBER (1=6,2=7,3=8)              00000170
CH5  IPTS            I*4    I,O   NUMBER OF POINTS PER FRAME            00000180
CH5  JAVER           I*4     I    PLOT POINT SIZE, DECISECONDS          00000190
CH5  JKEY            I*4     I    INPUT KEY PARAMETER                   00000200
CH5  JOLD            I*4     I    PERVIOUS INPUT KEY PARAMETER          00000210
CH5  JRANGE          I*4     I    FRAME RANGE SIZE, DECISEC             00000220
CH5  NOREC(500,3)    I*4     O    NUMBER OF AVERAGING INTERVALS PROC'D  00000230
CH5  NORM2           I*4     I    END FRAME TIME, WRT IYR1              00000240
CH5  NSTAT(10,500)   I*4     O    STATISTICS ACCUMULATION ARRAYS        00000250
CH5  NUMBIN          I*4     I    NUMBER OF REQUESTED BINS              00000260
CH5  QBOX(500,3)     L*1     I    BOX REQUEST FLAG ARRAY                00000270
CH5  QDAT(3)         L*1     I    SATELLITE REQUEST FLAG ARRAY          00000280
CH5  QDEBUG          L*1     I    DEBUG REQUEST FLAG                    00000290
CH5  QFB(100)        L*1     I    PENETRATING BOX GEOM FACTOR FLAGS     00000300
CH5  QSTAT           L*1     I    STATISTICS PRINTOUT REQUEST FLAG      00000310
CH5  QTHIST          L*1     I    T=TIME HIST; F=SPECTRAL               00000320
CH5  RJAY(500,3)     R*4     O    'FLUX' FOR AVERAGING PERIOD           00000330
CH5  S(100)          R*4    I,O   SPECTRAL FLUX                         00000340
CH5  SDEL(100)       R*4    I,O   SPECTRAL FLUX ERROR                   00000350
CH5  XNORM(100)      R*4     I    BIN NORMALIZATION FACTOR              00000360
CH5  Y(250)          R*4    I,O   TIME HISTORY FLUX                     00000370
CH5  YDEL(250)       R*4    I,O   TIME HISTORY FLUX ERROR               00000380
CH                                                                      00000390
CH6  METHOD:                                                            00000400
CH                                                                      00000410
CH7  PROGRAMMER:  J. CHILDS AND E. ENG, 2/77.                           00000420
CH                                                                      00000430
CH8  MODIFICATION:  J. CHILDS, 10/77 -- USES VARIABLE TIME AVERAGING    00000440
CH8                 CALCULATIONS, USING FLXPSS.                         00000450
CH8                 J. CHILDS, 5.79 -- PRINTS OUT DEBUG DATA, AND       00000460
CH8                 CORRECTLY HANDLES SPECTRAL PLOTS OF MANY TIME       00000470
CH8                 PERIODS.                                            00000480
CH                                                                      00000490
CH8   MODIFICATION BEGUN 10/86 BY PAS                                   00000500
CH8   AS PER R. MCGUIRE SPECIFICATIONS                                  00000510
CH                                                                      00000520
CH9  IMP-6/7/8, FLUX PLOT, FLXPA, V2.                                   00000530
CH**********************************************************************00000540
C                                                                       00000550
      SUBROUTINE FLXPA                                                  00000560
C                                                                       00000570
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000580
      REAL*4 DELFLX,DELSUM,DELJAY(500,3)                                00000590
      DIMENSION RJAY(500,3),NOREC(500,3)                                00000600
      DIMENSION NSTAT(10,500)                                           00000610
      COMMON /AVE/    IAVLEN,QSTAT                                      00000620
C*******  25 -> 100   144 -> 500                                        00000630
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00000640
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00000650
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00000660
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00000670
C          TO 50 (FRAMES)                                               00000680
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00000690
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00000700
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00000710
      COMMON /GAP/    JOLD                                              00000720
C*******     144 -> 500                                                 00000730
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   00000740
     *                KEVENT(500,3),HMP8ST(500)                         00000750
C*******  LOOP INDEX BECOMES I144 VARIABLE FROM NEW COMMON BLOCK LOOPS  00000760
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6,IFR80                     00000770
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          00000780
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00000790
     *                ITIME(250),IPTS,JKEY,QTHIST                       00000800
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000810
      COMMON /TREND/  TCFACT,QTC,QDEBUG                                 00000820
C                                                                       00000830
C   QSTAT DETERMINES WHETHER STATISTICS GET PRINTED FOR SPECTRAL PLOTS  00000840
C   IAVLEN IS LENGTH OF AVERAGING INTERVAL IN DECISECONDS               00000850
C                                                                       00000860
CP  DO FOR EACH OF THE IMPS REQUESTED                                   00000870
      DO 500 KIMP=1,3                                                   00000880
         IF (.NOT.QDAT(KIMP)) GOTO 500                                  00000890
C                                                                       00000900
CP     IF (SPECTRAL PLOT) SET NUMBER OF POINTS TO 1                     00000910
      IF (.NOT.QTHIST) IPTS = 1                                         00000920
C                                                                       00000930
C   LOOP OVER DATA POINTS;  IF SPECTRAL PLOT, ONCE THRU LOOP.           00000940
CP     DO FOR ALL POINTS TO PROCESS                                     00000950
      DO 400 IDAT=1,IPTS                                                00000960
CP        CALCULATE UPPER PLOT POINT TIME                               00000970
      IF (QTHIST)                    IUPPER = ITIME(IDAT) + JAVER/2     00000980
      IF (.NOT.QTHIST.AND.JKEY.EQ.2) IUPPER = ISTART + JRANGE           00000990
      IF (.NOT.QTHIST.AND.JKEY.NE.2) IUPPER = NORM2                     00001000
      IF(.NOT.QDEBUG) GO TO 6003                                        00001010
        PRINT 6000                                                      00001020
 6000   FORMAT(1H )                                                     00001030
        PRINT 6001,IUPPER,ISTART,JRANGE                                 00001040
        PRINT 6002,ISTART,IYR1,ISTOP,IYR2,NORM2,JRANUN,JAVER,NOAVU,IAVU 00001050
 6001   FORMAT(1H ,'FLXPA - TIMES ',3I15)                               00001060
 6002   FORMAT(1H ,'FLXPA - COMMON/FRAME/ VARIABLES:  ',2(I15,2X,I5),   00001070
     X   1X/10X,I15,5X,I5,3I10)                                         00001080
        PRINT 6000                                                      00001090
 6003   CONTINUE                                                        00001100
C                                                                       00001110
C   RESET POINT TIME ARRAYS, UNLESS SOME SPECTRAL DATA ALREADY          00001120
C   ACCUMULATED.                                                        00001130
CP        IF (SOME DATA NOT ALREADY ACCUMULATED)                        00001140
      IF (JOLD.EQ.1) GOTO 10                                            00001150
CP           ZERO OUT ACCUMULATION ARRAYS                               00001160
      DO 5 I=1,I144                                                     00001170
        RJAY(I,KIMP)   = 0.0                                            00001180
        NOREC(I,KIMP)  = 0                                              00001190
        DELJAY(I,KIMP) = 0.0                                            00001200
  5     CONTINUE                                                        00001210
CP        FI                                                            00001220
10    CONTINUE                                                          00001230
C                                                                       00001240
C   CALL ROUTINE TO ACCUMULATE FLUX FOR THE POINT-TIME                  00001250
C   DELIMITED BY THE TIME 'IUPPER'                                      00001260
C                                                                       00001270
CP        ACCUMULATE FLUX PARAMETERS FOR PLOT POINT TIME                00001280
      CALL FLXPSS(DELJAY(1,KIMP),RJAY(1,KIMP),NOREC(1,KIMP),IUPPER,     00001290
     *            IAVLEN,NSTAT,KIMP,IDAT)                               00001300
C                                                                       00001310
CP        PRINT OUT STATISTICS, IF REQUESTED                            00001320
      IF (QSTAT) CALL FLXPST(NSTAT,IAVLEN,KIMP,QBOX)                    00001330
C                                                                       00001340
CP        IF MORE SPECTRAL DATA TO BE ACCUMULATED, EXIT FOR MORE        00001350
      IF (.NOT.QTHIST.AND.JKEY.EQ.1) GOTO 500                           00001360
C                                                                       00001370
CP        PRINT DEBUG INFO IF REQUESTED                                 00001380
      IF (.NOT.QDEBUG) GOTO 201                                         00001390
C********* DEBUG PRINTOUT                                               00001400
      PRINT 5000                                                        00001410
5000  FORMAT('  BOX      RJAY           DELJAY       NOREC')            00001420
      DO 200 I=1,I144                                                   00001430
         IF (.NOT.QBOX(I,KIMP)) GOTO 200                                00001440
         PRINT 5002,I,RJAY(I,KIMP),DELJAY(I,KIMP),NOREC(I,KIMP)         00001450
5002     FORMAT(1X,I4,1P2G15.5,I10)                                     00001460
200      CONTINUE                                                       00001470
C ********* END DEBUG PRINTOUT                                          00001480
201   CONTINUE                                                          00001490
C                                                                       00001500
CP        DO FOR EACH BOX REQUESTED                                     00001510
      DO 305 I=1,I144                                                   00001520
        IF(.NOT.QBOX(I,KIMP))GO TO 305                                  00001530
C                                                                       00001540
C   'FLUX' IS CALCULATED FROM AVERAGES OF 5-MINUTE 'FLUXS'.             00001550
C                                                                       00001560
        IF (NOREC(I,KIMP).EQ.0) GOTO 305                                00001570
CP           TAKE AVERAGE OF 'FLUX' AND 'FLUX' ERRORS                   00001580
        RJAY(I,KIMP)   = RJAY(I,KIMP)/NOREC(I,KIMP)                     00001590
        DELJAY(I,KIMP) = SQRT(DELJAY(I,KIMP))/NOREC(I,KIMP)             00001600
CP        OD                                                            00001610
  305 CONTINUE                                                          00001620
C                                                                       00001630
      IF (KIMP.NE.2) GOTO 306                                           00001640
CP        ADJUST IMP-7 BOX 7 DUE TO AM-241 CONTAMINATION                00001650
      IF (QBOX(7,2).AND.(RJAY(7,2).LE..00183)) RJAY(7,2) = 0.0          00001660
      IF (QBOX(7,2).AND.(RJAY(7,2).GT..00183))                          00001670
     *                             RJAY(7,2) = RJAY(7,2) - .00183       00001680
306   CONTINUE                                                          00001690
C                                                                       00001700
C   FOR IMP-8, COMBINE THE ALPHA BOXES AND MODIFY BOX 8                 00001710
      IF (KIMP.NE.3) GOTO 307                                           00001720
CP        COMBINE IMP-8 ALPHA BOXES                                     00001730
      CALL FLXPAB(RJAY(1,3),DELJAY(1,3))                                00001740
CP        ADJUST IMP-8 BOX 8 DUE TO AM-241 CONTAMINATION                00001750
C      BOX 8, IF USED, MUST HAVE ITS COUNTS/SEC ADJUSTED DUE TO         00001760
C         CONTAMINATION. (2.5 X 10-4 COUNTS/SEC)                        00001770
      IF(QBOX(8,3).AND.(RJAY(8,3).LE. .00025)) RJAY(8,3) = 0.0          00001780
      IF(QBOX(8,3).AND.(RJAY(8,3).GT. .00025))                          00001790
     *                      RJAY(8,3) = RJAY(8,3) - .00025              00001800
307   CONTINUE                                                          00001810
CP        PRINT DEBUG INFO IF REQUESTED                                 00001820
C                                                                       00001830
      IF (.NOT.QDEBUG) GOTO 251                                         00001840
C *********DEBUG PRINTOUT                                               00001850
      DO 250 I=1,I144                                                   00001860
         IF (.NOT.QBOX(I,KIMP)) GOTO 250                                00001870
         PRINT 5002,I,RJAY(I,KIMP),DELJAY(I,KIMP),NOREC(I,KIMP)         00001880
250      CONTINUE                                                       00001890
      PRINT 5003                                                        00001900
5003  FORMAT('0 BIN BOX   GEOM FACTOR        RJAY           XSUM     ', 00001910
     *'      DELJAY         DELSUM          EUP      ELOW   JRDOT')     00001920
C ********* END DEBUG PRINTOUT                                          00001930
251   CONTINUE                                                          00001940
C                                                                       00001950
C   CLOSE UP DATA POINT, WITH ERROR.                                    00001960
CP        DO FOR EACH BIN REQUESTED                                     00001970
      DO 350 LBIN=1,NUMBIN                                              00001980
        IF (IMP(LBIN).NE.KIMP) GOTO 350                                 00001990
C                                                                       00002000
        XSUM = 0.0                                                      00002010
        DELSUM = 0.0                                                    00002020
        JRDOT = 0                                                       00002030
CP           DO FOR EACH BOX IN BIN                                     00002040
        DO 310 LBOX=1,10                                                00002050
CP              CALCULATE TERMS FOR FLUX AND ERROR                      00002060
          K = JBOX(LBOX,LBIN)                                           00002070
          IF (K.EQ.0) GOTO 311                                          00002080
C   FNORM FACTOR IS 2 IF BOTH FORWARD AND BACKWARD PENETRATING BOXES.   00002090
          FNORM = 1.0                                                   00002100
          IF (QFB(LBOX,LBIN)) FNORM = 2.0                               00002110
          XSUMD = GEOM(K,KIMP)*FNORM                                    00002120
          XSUM = XSUM + RJAY(K,KIMP)/XSUMD                              00002130
          DELSUM = DELSUM + (DELJAY(K,KIMP)*DELJAY(K,KIMP))/            00002140
     *                                              (XSUMD*XSUMD)       00002150
          JRDOT = JRDOT + NOREC(K,KIMP)                                 00002160
CP              PRINT DEBUG INFO IF REQUESTED                           00002170
C ********* DEBUG PRINTOUT                                              00002180
      IF (QDEBUG) PRINT 5001,LBIN,K,GEOM(K,KIMP),RJAY(K,KIMP),XSUM,     00002190
     *                       DELJAY(K,KIMP),DELSUM,EUPBN(LBIN),         00002200
     *                       ELOBN(LBIN),JRDOT                          00002210
5001  FORMAT(1X,I3,I4,1P7G15.5,I5)                                      00002220
CP           OD                                                         00002230
C ********* END DEBUG PRINTOUT                                          00002240
310       CONTINUE                                                      00002250
C   IF NO RATE READOUTS, THEN ASSUME NO FLUX.                           00002260
CP           CALCULATE FLUX                                             00002270
311     IF (JRDOT.LE.0) GOTO 350                                        00002280
        FLUX = XSUM/(EUPBN(LBIN) - ELOBN(LBIN))                         00002290
        IF (QTHIST) Y(IDAT,LBIN) = FLUX*XNORM(LBIN)                     00002300
        IF (.NOT.QTHIST) S(LBIN) = FLUX*XNORM(LBIN)                     00002310
CP           CALCULATE FLUX ERROR                                       00002320
C   ERROR ANALYSIS ASSUMED: SQRT OF SUM OF SQUARES OF (1/SQRT(N))       00002330
        DELFLX = SQRT(DELSUM)/(EUPBN(LBIN) - ELOBN(LBIN))               00002340
          IF(QTHIST) YDEL(IDAT,LBIN) = DELFLX*XNORM(LBIN)               00002350
        IF (.NOT.QTHIST) SDEL(LBIN) = DELFLX*XNORM(LBIN)                00002360
CP        OD           (END OF BIN LOOP)                                00002370
350     CONTINUE                                                        00002380
CP        CLEAR ACCUMULATORS                                            00002390
      DO 360 K=1,I144                                                   00002400
        RJAY(K,KIMP)   = 0.0                                            00002410
        NOREC(K,KIMP)  = 0                                              00002420
        DELJAY(K,KIMP) = 0.0                                            00002430
  360 CONTINUE                                                          00002440
      IF (.NOT.QDAT(KIMP)) GOTO 500                                     00002450
CP        IF (NO MORE DATA) EXIT                                        00002460
CP     OD              (END OF PLOT POINT LOOP)                         00002470
400   CONTINUE                                                          00002480
CP  OD                 (END OF IMP LOOP)                                00002490
500   CONTINUE                                                          00002500
      RETURN                                                            00002510
      END                                                               00002520
