/* swepam_level2_data_ion.h */

#include "hdfi.h"

struct SWEPAM_ion {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  /* SWEPAM data */
  float32 proton_density;
  float32 proton_temp;
  float32 He4toprotons;
  float32 proton_speed;
  float32 x_dot_GSE;
  float32 y_dot_GSE;
  float32 z_dot_GSE;
  float32 x_dot_RTN;
  float32 y_dot_RTN;
  float32 z_dot_RTN;
  float32 x_dot_GSM;
  float32 y_dot_GSM;
  float32 z_dot_GSM;
  float32 pos_gse_x;
  float32 pos_gse_y;
  float32 pos_gse_z;
  float32 pos_gsm_x;
  float32 pos_gsm_y;
  float32 pos_gsm_z;
};
