#ifndef	__SWEPAM_DSWI_LEVEL2_H
#define	__SWEPAM_DSWI_LEVEL2_H 1

#include "hdfi.h"

struct swepam_dswi_level2 {

  uint16   year;		/* Full four-digit year, eg, 1998	*/
  uint16   yday;		/* Day of year, 1-365 (or -366)		*/
  uint8    mon;			/* Month, 1-12				*/
  uint8    mday;		/* Day of month, 1-31			*/
  uint8    hour;		/* Hour, 0-23				*/
  uint8    min;			/* Minutes past the hour, 0-59		*/
  uint8    sec;			/* Seconds, 0-59			*/

  uint32   sct;			/* Spacecraft time			*/

  float32  proton_density;	/* Proton density, cm-3			*/
  float32  alpha_density_to_proton_density; /* Alpha ratio		*/
  float32  proton_temp;		/* Temperature, Kelvins			*/

  float32  proton_speed;	/* Proton speed, km/s			*/
  float32  proton_speed_gse[3]; /* GSE components of proton speeds	*/
  float32  proton_speed_rtn[3]; /* RTN components of proton speeds	*/
};

#endif 	/* __SWEPAM_DSWI_LEVEL2_H */










