
#include "hdfi.h"

struct SEPICA_data_1day {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 H1;
  float32 H2;
  float32 H3;
  float32 H4;
  float32 H5;

  float32 He1;
  float32 He2;
  float32 He3;
  float32 He4;
  float32 He5;
  float32 He6;

  float32 C1;
  float32 C2;
  float32 C3;

  float32 O1;
  float32 O2;
  float32 O3;
  float32 O4;

  float32 Fe1;
  float32 Fe2;
  float32 Fe3;
  float32 Fe4;

  float32 unc_H1;
  float32 unc_H2;
  float32 unc_H3;
  float32 unc_H4;
  float32 unc_H5;

  float32 unc_He1;
  float32 unc_He2;
  float32 unc_He3;
  float32 unc_He4;
  float32 unc_He5;
  float32 unc_He6;

  float32 unc_C1;
  float32 unc_C2;
  float32 unc_C3;

  float32 unc_O1;
  float32 unc_O2;
  float32 unc_O3;
  float32 unc_O4;

  float32 unc_Fe1;
  float32 unc_Fe2;
  float32 unc_Fe3;
  float32 unc_Fe4;

  float32 up_time_fraction; 
  int32   number_of_records_120s;
  int32   number_of_records_1hr;

};
