#include "hdfi.h"
#include "cris_sizes.h"

/* rare elements */
struct CRIS_data_rare_1024s {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 flux_rare_B[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_F[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Na[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Al[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_P[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Cl[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Ar[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_K[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Ca[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Sc[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Ti[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_V[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Cr[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Mn[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Co[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_rare_Ni[NUMBER_OF_ENERGY_LEVELS]; 

  float32 cnt_rare_B[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_F[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Na[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Al[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_P[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Cl[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Ar[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_K[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Ca[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Sc[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Ti[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_V[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Cr[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Mn[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Co[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_rare_Ni[NUMBER_OF_ENERGY_LEVELS]; 

  float32 livetime;

};







