#include "hdfi.h"
#include "cris_sizes.h"

struct CRIS_data_1hr {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 flux_B[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_C[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_N[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_O[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_F[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Ne[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_Na[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Mg[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_Al[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Si[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_P[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_S[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_Cl[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Ar[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_K[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Ca[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Sc[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Ti[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_V[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Cr[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Mn[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Fe[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_Co[NUMBER_OF_ENERGY_LEVELS]; 
  float32 flux_Ni[NUMBER_OF_ENERGY_LEVELS]; 

  float32 cnt_B[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_C[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_N[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_O[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_F[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Ne[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_Na[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Mg[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_Al[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Si[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_P[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_S[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_Cl[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Ar[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_K[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Ca[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Sc[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Ti[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_V[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Cr[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Mn[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Fe[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_Co[NUMBER_OF_ENERGY_LEVELS]; 
  float32 cnt_Ni[NUMBER_OF_ENERGY_LEVELS]; 

  float32 livetime;

};

