/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "swics_swims_level2_data_1day.h"
#include "df.h"

int32 vgrp_id_swics_swims_level2_data_1day;
static int32 vdata_id_swics_swims_level2_data_1day;

  /* 1181 is the size of swics_swims_level2_data_1day.h + 1 added line */
char Vgrp_descrp_SWICS_SWIMS_data_1day[1181];

/****----  init create function  ----****/

int32 init_cr_swics_swims_level2_data_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_swics_swims_level2_data_1day();

  void print_swics_swims_level2_data_1day_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_swics_swims_level2_data_1day = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_swics_swims_level2_data_1day, "VG_SWICS_SWIMS_data_1day"); 
  Vsetclass(vgrp_id_swics_swims_level2_data_1day, "VG_SWICS_SWIMS_LEVEL2_DATA_1DAY");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SWICS_SWIMS_data_1day" )) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_swics_swims_level2_data_1day(Vgrp_descrp_SWICS_SWIMS_data_1day);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SWICS_SWIMS_data_1day, sizeof(Vgrp_descrp_SWICS_SWIMS_data_1day))) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_swics_swims_level2_data_1day = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_swics_swims_level2_data_1day, "SWICS_SWIMS_data_1day");
  VSsetclass(vdata_id_swics_swims_level2_data_1day, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_swics_swims_level2_data_1day, vdata_id_swics_swims_level2_data_1day)) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "year", DFNT_INT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "day", DFNT_INT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "hr", DFNT_INT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "min", DFNT_INT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "sec", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "fp_year", DFNT_FLOAT64, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vH", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vH");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vthH", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vthH");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vHe", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vHe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vthHe", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vthHe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vO6", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vO6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vthO6", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vthO6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vMg", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vthMg", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vthMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vFe", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vFe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "vthFe", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define vthFe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "HetoO", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define HetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "NetoO", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define NetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "MgtoO", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define MgtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "FetoO", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define FetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "He3to4", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define He3to4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "Ne22to20", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define Ne22to20");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "Mg24to26", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define Mg24to26");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "C5to6", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define C5to6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "O7to6", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define O7to6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "Fe11to9", DFNT_FLOAT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define Fe11to9");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swics_swims_level2_data_1day, "Record_number_vHe", DFNT_INT32, (1) )) {
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSfdefine: Couldn't define Record_number_vHe");
    retval = -1;
  }

  if (VSsetfields(vdata_id_swics_swims_level2_data_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, vH, vthH, vHe, vthHe, vO6, vthO6, vMg, vthMg, vFe, vthFe, HetoO, NetoO, MgtoO, FetoO, He3to4, Ne22to20, Mg24to26, C5to6, O7to6, Fe11to9, Record_number_vHe")){
    print_swics_swims_level2_data_1day_error("init_cr_swics_swims_level2_data_1day -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_swics_swims_level2_data_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_swics_swims_level2_data_1day(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_swics_swims_level2_data_1day(struct SWICS_SWIMS_data_1day SWICS_SWIMS_data_1day_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_swics_swims_level2_data_1day_error();
void pack_swics_swims_level2_data_1day();

  odata = (uint8 *) malloc(sizeof(struct SWICS_SWIMS_data_1day));
  pack_swics_swims_level2_data_1day(odata, &SWICS_SWIMS_data_1day_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_swics_swims_level2_data_1day, recnum)==-1) {
		print_swics_swims_level2_data_1day_error("write_swics_swims_level2_data_1day -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_swics_swims_level2_data_1day, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_swics_swims_level2_data_1day_error("write_swics_swims_level2_data_1day -> VSwrite: Couldn't write data.");

  memset(&SWICS_SWIMS_data_1day_struc, 0, sizeof(struct SWICS_SWIMS_data_1day));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_swics_swims_level2_data_1day()
{
  VSdetach(vdata_id_swics_swims_level2_data_1day);
  Vdetach(vgrp_id_swics_swims_level2_data_1day);
}

/*----     init access function    ----*/

int32 init_acc_swics_swims_level2_data_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_swics_swims_level2_data_1day_error();


  if ((vdata_ref = VSfind(hdf_fp, "SWICS_SWIMS_data_1day")) <= 0 ) {
    print_swics_swims_level2_data_1day_error("init_acc_swics_swims_level2_data_1day -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_swics_swims_level2_data_1day = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_swics_swims_level2_data_1day_error("init_acc_swics_swims_level2_data_1day -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_swics_swims_level2_data_1day, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_swics_swims_level2_data_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, vH, vthH, vHe, vthHe, vO6, vthO6, vMg, vthMg, vFe, vthFe, HetoO, NetoO, MgtoO, FetoO, He3to4, Ne22to20, Mg24to26, C5to6, O7to6, Fe11to9, Record_number_vHe")) {
      print_swics_swims_level2_data_1day_error("init_acc_swics_swims_level2_data_1day -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_swics_swims_level2_data_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_swics_swims_level2_data_1day(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_swics_swims_level2_data_1day(struct SWICS_SWIMS_data_1day *SWICS_SWIMS_data_1day_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_swics_swims_level2_data_1day_error();
void unpack_swics_swims_level2_data_1day();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SWICS_SWIMS_data_1day));
  VSinquire(vdata_id_swics_swims_level2_data_1day, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_swics_swims_level2_data_1day, recnum_rd)==FAIL) {
          print_swics_swims_level2_data_1day_error("read_swics_swims_level2_data_1day -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_swics_swims_level2_data_1day, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_swics_swims_level2_data_1day_error("read_swics_swims_level2_data_1day -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_swics_swims_level2_data_1day(odata, SWICS_SWIMS_data_1day_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_swics_swims_level2_data_1day()
{
  VSdetach(vdata_id_swics_swims_level2_data_1day);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_swics_swims_level2_data_1day(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_swics_swims_level2_data_1day_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SWICS_SWIMS_data_1day" )) ==FAIL)
    print_swics_swims_level2_data_1day_error("rd_Vgrp_swics_swims_level2_data_1day -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_swics_swims_level2_data_1day_error("rd_Vgrp_swics_swims_level2_data_1day -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_swics_swims_level2_data_1day_error("rd_Vgrp_swics_swims_level2_data_1day -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_swics_swims_level2_data_1day_error("rd_Vgrp_swics_swims_level2_data_1day -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SWICS_SWIMS_data_1day, HDstrlen(Vgrp_descrp_SWICS_SWIMS_data_1day)) ==FAIL)
    print_swics_swims_level2_data_1day_error("rd_Vgrp_swics_swims_level2_data_1day -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SWICS_SWIMS_data_1day);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_swics_swims_level2_data_1day_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_swics_swims_level2_data_1day.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_swics_swims_level2_data_1day(uint8 *data, struct SWICS_SWIMS_data_1day *SWICS_SWIMS_data_1day_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vH, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vthH, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vHe, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vthHe, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vO6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vthO6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vMg, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vthMg, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vFe, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->vthFe, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->HetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->NetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->MgtoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->FetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->He3to4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->Ne22to20, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->Mg24to26, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->C5to6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->O7to6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->Fe11to9, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWICS_SWIMS_data_1day_ptr->Record_number_vHe, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_swics_swims_level2_data_1day(uint8 *data, struct SWICS_SWIMS_data_1day *SWICS_SWIMS_data_1day_ptr)
{
int32 ptr=0;

   memcpy(&SWICS_SWIMS_data_1day_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vH, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vthH, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vHe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vthHe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vO6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vthO6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vMg, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vthMg, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vFe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->vthFe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->HetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->NetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->MgtoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->FetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->He3to4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->Ne22to20, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->Mg24to26, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->C5to6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->O7to6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->Fe11to9, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWICS_SWIMS_data_1day_ptr->Record_number_vHe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_swics_swims_level2_data_1day() {return(vgrp_id_swics_swims_level2_data_1day);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_swics_swims_level2_data_1day(char *wr_strval)
{
  strcpy(wr_strval, "The file 'swics_swims_level2_data_1day.h' is shown below, it was used to create the data in the Vgroup named 'VG_SWICS_SWIMS_data_1day'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SWICS_SWIMS_data_1day {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 vH;\n");
  strcat(wr_strval,"  float32 vthH;\n");
  strcat(wr_strval,"  float32 vHe;\n");
  strcat(wr_strval,"  float32 vthHe;\n");
  strcat(wr_strval,"  float32 vO6;\n");
  strcat(wr_strval,"  float32 vthO6;\n");
  strcat(wr_strval,"  float32 vMg;\n");
  strcat(wr_strval,"  float32 vthMg;\n");
  strcat(wr_strval,"  float32 vFe;\n");
  strcat(wr_strval,"  float32 vthFe;\n");
  strcat(wr_strval,"  float32 HetoO;\n");
  strcat(wr_strval,"  float32 NetoO;\n");
  strcat(wr_strval,"  float32 MgtoO;\n");
  strcat(wr_strval,"  float32 FetoO;\n");
  strcat(wr_strval,"  float32 He3to4;\n");
  strcat(wr_strval,"  float32 Ne22to20;\n");
  strcat(wr_strval,"  float32 Mg24to26;\n");
  strcat(wr_strval,"  float32 C5to6;\n");
  strcat(wr_strval,"  float32 O7to6;\n");
  strcat(wr_strval,"  float32 Fe11to9;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32   Record_number_vHe; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  return(0);
}
