/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "swepam_dswi_level2.h"
#include "df.h"

int32 vgrp_id_swepam_dswi_level2;
static int32 vdata_id_swepam_dswi_level2;

  /* 1098 is the size of swepam_dswi_level2.h + 1 added line */
char Vgrp_descrp_swepam_dswi_level2[1098];

/****----  init create function  ----****/

int32 init_cr_swepam_dswi_level2(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_swepam_dswi_level2();

  void print_swepam_dswi_level2_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_swepam_dswi_level2 = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_swepam_dswi_level2, "VG_swepam_dswi_level2"); 
  Vsetclass(vgrp_id_swepam_dswi_level2, "VG_SWEPAM_DSWI_LEVEL2");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_swepam_dswi_level2" )) ==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_swepam_dswi_level2(Vgrp_descrp_swepam_dswi_level2);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_swepam_dswi_level2, sizeof(Vgrp_descrp_swepam_dswi_level2))) ==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_swepam_dswi_level2 = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_swepam_dswi_level2, "swepam_dswi_level2");
  VSsetclass(vdata_id_swepam_dswi_level2, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_swepam_dswi_level2, vdata_id_swepam_dswi_level2)) ==FAIL) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_swepam_dswi_level2, "year", DFNT_UINT16, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "yday", DFNT_UINT16, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define yday");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "mon", DFNT_UINT8, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define mon");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "mday", DFNT_UINT8, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define mday");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "hour", DFNT_UINT8, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define hour");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "min", DFNT_UINT8, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "sec", DFNT_UINT8, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "sct", DFNT_UINT32, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define sct");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "proton_density", DFNT_FLOAT32, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define proton_density");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "alpha_density_to_proton_density", DFNT_FLOAT32, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define alpha_density_to_proton_density");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "proton_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define proton_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "proton_speed", DFNT_FLOAT32, (1) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define proton_speed");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "proton_speed_gse", DFNT_FLOAT32, (3) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define proton_speed_gse");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_dswi_level2, "proton_speed_rtn", DFNT_FLOAT32, (3) )) {
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSfdefine: Couldn't define proton_speed_rtn");
    retval = -1;
  }

  if (VSsetfields(vdata_id_swepam_dswi_level2,"year, yday, mon, mday, hour, min, sec, sct, proton_density, alpha_density_to_proton_density, proton_temp, proton_speed, proton_speed_gse, proton_speed_rtn")){
    print_swepam_dswi_level2_error("init_cr_swepam_dswi_level2 -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_swepam_dswi_level2(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_swepam_dswi_level2(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_swepam_dswi_level2(struct swepam_dswi_level2 swepam_dswi_level2_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_swepam_dswi_level2_error();
void pack_swepam_dswi_level2();

  odata = (uint8 *) malloc(sizeof(struct swepam_dswi_level2));
  pack_swepam_dswi_level2(odata, &swepam_dswi_level2_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_swepam_dswi_level2, recnum)==-1) {
		print_swepam_dswi_level2_error("write_swepam_dswi_level2 -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_swepam_dswi_level2, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_swepam_dswi_level2_error("write_swepam_dswi_level2 -> VSwrite: Couldn't write data.");

  memset(&swepam_dswi_level2_struc, 0, sizeof(struct swepam_dswi_level2));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_swepam_dswi_level2()
{
  VSdetach(vdata_id_swepam_dswi_level2);
  Vdetach(vgrp_id_swepam_dswi_level2);
}

/*----     init access function    ----*/

int32 init_acc_swepam_dswi_level2(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_swepam_dswi_level2_error();


  if ((vdata_ref = VSfind(hdf_fp, "swepam_dswi_level2")) <= 0 ) {
    print_swepam_dswi_level2_error("init_acc_swepam_dswi_level2 -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_swepam_dswi_level2 = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_swepam_dswi_level2_error("init_acc_swepam_dswi_level2 -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_swepam_dswi_level2, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_swepam_dswi_level2,"year, yday, mon, mday, hour, min, sec, sct, proton_density, alpha_density_to_proton_density, proton_temp, proton_speed, proton_speed_gse, proton_speed_rtn")) {
      print_swepam_dswi_level2_error("init_acc_swepam_dswi_level2 -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_swepam_dswi_level2(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_swepam_dswi_level2(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_swepam_dswi_level2(struct swepam_dswi_level2 *swepam_dswi_level2_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_swepam_dswi_level2_error();
void unpack_swepam_dswi_level2();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct swepam_dswi_level2));
  VSinquire(vdata_id_swepam_dswi_level2, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_swepam_dswi_level2, recnum_rd)==FAIL) {
          print_swepam_dswi_level2_error("read_swepam_dswi_level2 -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_swepam_dswi_level2, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_swepam_dswi_level2_error("read_swepam_dswi_level2 -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_swepam_dswi_level2(odata, swepam_dswi_level2_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_swepam_dswi_level2()
{
  VSdetach(vdata_id_swepam_dswi_level2);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_swepam_dswi_level2(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_swepam_dswi_level2_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_swepam_dswi_level2" )) ==FAIL)
    print_swepam_dswi_level2_error("rd_Vgrp_swepam_dswi_level2 -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_swepam_dswi_level2_error("rd_Vgrp_swepam_dswi_level2 -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_swepam_dswi_level2_error("rd_Vgrp_swepam_dswi_level2 -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_swepam_dswi_level2_error("rd_Vgrp_swepam_dswi_level2 -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_swepam_dswi_level2, HDstrlen(Vgrp_descrp_swepam_dswi_level2)) ==FAIL)
    print_swepam_dswi_level2_error("rd_Vgrp_swepam_dswi_level2 -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_swepam_dswi_level2);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_swepam_dswi_level2_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_swepam_dswi_level2.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_swepam_dswi_level2(uint8 *data, struct swepam_dswi_level2 *swepam_dswi_level2_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &swepam_dswi_level2_ptr->year, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->yday, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->mon, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->mday, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->hour, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->min, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->sec, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->sct, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->proton_density, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->alpha_density_to_proton_density, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->proton_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->proton_speed, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->proton_speed_gse[0], ((4)*(3)) );
   ptr+= ((4)*(3));
   memcpy(data+ptr, &swepam_dswi_level2_ptr->proton_speed_rtn[0], ((4)*(3)) );
   ptr+= ((4)*(3));
}

/*----   unpack function    ----*/

void unpack_swepam_dswi_level2(uint8 *data, struct swepam_dswi_level2 *swepam_dswi_level2_ptr)
{
int32 ptr=0;

   memcpy(&swepam_dswi_level2_ptr->year, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&swepam_dswi_level2_ptr->yday, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&swepam_dswi_level2_ptr->mon, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&swepam_dswi_level2_ptr->mday, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&swepam_dswi_level2_ptr->hour, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&swepam_dswi_level2_ptr->min, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&swepam_dswi_level2_ptr->sec, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&swepam_dswi_level2_ptr->sct, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&swepam_dswi_level2_ptr->proton_density, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&swepam_dswi_level2_ptr->alpha_density_to_proton_density, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&swepam_dswi_level2_ptr->proton_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&swepam_dswi_level2_ptr->proton_speed, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&swepam_dswi_level2_ptr->proton_speed_gse[0], data+ptr,  ((4)*(3)) );
   ptr+= ((4)*(3));
   memcpy(&swepam_dswi_level2_ptr->proton_speed_rtn[0], data+ptr,  ((4)*(3)) );
   ptr+= ((4)*(3));
}
int32 get_vgrp_id_swepam_dswi_level2() {return(vgrp_id_swepam_dswi_level2);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_swepam_dswi_level2(char *wr_strval)
{
  strcpy(wr_strval, "The file 'swepam_dswi_level2.h' is shown below, it was used to create the data in the Vgroup named 'VG_swepam_dswi_level2'.\n\n");
  strcat(wr_strval,"#ifndef	__SWEPAM_DSWI_LEVEL2_H\n");
  strcat(wr_strval,"#define	__SWEPAM_DSWI_LEVEL2_H 1\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct swepam_dswi_level2 {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  uint16   year;		/* Full four-digit year, eg, 1998	*/\n");
  strcat(wr_strval,"  uint16   yday;		/* Day of year, 1-365 (or -366)		*/\n");
  strcat(wr_strval,"  uint8    mon;			/* Month, 1-12				*/\n");
  strcat(wr_strval,"  uint8    mday;		/* Day of month, 1-31			*/\n");
  strcat(wr_strval,"  uint8    hour;		/* Hour, 0-23				*/\n");
  strcat(wr_strval,"  uint8    min;			/* Minutes past the hour, 0-59		*/\n");
  strcat(wr_strval,"  uint8    sec;			/* Seconds, 0-59			*/\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  uint32   sct;			/* Spacecraft time			*/\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32  proton_density;	/* Proton density, cm-3			*/\n");
  strcat(wr_strval,"  float32  alpha_density_to_proton_density; /* Alpha ratio		*/\n");
  strcat(wr_strval,"  float32  proton_temp;		/* Temperature, Kelvins			*/\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32  proton_speed;	/* Proton speed, km/s			*/\n");
  strcat(wr_strval,"  float32  proton_speed_gse[3]; /* GSE components of proton speeds	*/\n");
  strcat(wr_strval,"  float32  proton_speed_rtn[3]; /* RTN components of proton speeds	*/\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#endif 	/* __SWEPAM_DSWI_LEVEL2_H */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
