/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "sis_level2_data_1hr.h"
#include "df.h"

int32 vgrp_id_sis_level2_all_1hr;
static int32 vdata_id_sis_level2_all_1hr;

  /* 1773 is the size of sis_level2_data_1hr.h + 1 added line */
char Vgrp_descrp_SIS_data_1hr[1773];

/****----  init create function  ----****/

int32 init_cr_sis_level2_all_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_sis_level2_all_1hr();

  void print_sis_level2_all_1hr_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_sis_level2_all_1hr = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_sis_level2_all_1hr, "VG_SIS_data_1hr"); 
  Vsetclass(vgrp_id_sis_level2_all_1hr, "VG_SIS_LEVEL2_DATA_1HR");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SIS_data_1hr" )) ==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_sis_level2_all_1hr(Vgrp_descrp_SIS_data_1hr);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SIS_data_1hr, sizeof(Vgrp_descrp_SIS_data_1hr))) ==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_sis_level2_all_1hr = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_sis_level2_all_1hr, "SIS_data_1hr");
  VSsetclass(vdata_id_sis_level2_all_1hr, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_sis_level2_all_1hr, vdata_id_sis_level2_all_1hr)) ==FAIL) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "year", DFNT_INT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "day", DFNT_INT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "hr", DFNT_INT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "min", DFNT_INT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "sec", DFNT_FLOAT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "fp_year", DFNT_FLOAT64, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_He", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_He");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_C", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_C");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_N", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_N");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_O", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_O");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_Ne", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_Ne");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_Mg", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_Mg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_Si", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_Si");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_S", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_S");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "flux_Fe", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define flux_Fe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_He", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_He");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_C", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_C");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_N", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_N");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_O", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_O");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_Ne", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_Ne");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_Mg", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_Mg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_Si", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_Si");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_S", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_S");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "cnt_Fe", DFNT_FLOAT32, (NUMBER_OF_ENERGY_BANDS) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define cnt_Fe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "up_time_fraction", DFNT_FLOAT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define up_time_fraction");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sis_level2_all_1hr, "solar_activity_flag", DFNT_INT32, (1) )) {
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSfdefine: Couldn't define solar_activity_flag");
    retval = -1;
  }

  if (VSsetfields(vdata_id_sis_level2_all_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, flux_He, flux_C, flux_N, flux_O, flux_Ne, flux_Mg, flux_Si, flux_S, flux_Fe, cnt_He, cnt_C, cnt_N, cnt_O, cnt_Ne, cnt_Mg, cnt_Si, cnt_S, cnt_Fe, up_time_fraction, solar_activity_flag")){
    print_sis_level2_all_1hr_error("init_cr_sis_level2_all_1hr -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_sis_level2_all_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_sis_level2_all_1hr(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_sis_level2_all_1hr(struct SIS_data_1hr SIS_data_1hr_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_sis_level2_all_1hr_error();
void pack_sis_level2_all_1hr();

  odata = (uint8 *) malloc(sizeof(struct SIS_data_1hr));
  pack_sis_level2_all_1hr(odata, &SIS_data_1hr_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_sis_level2_all_1hr, recnum)==-1) {
		print_sis_level2_all_1hr_error("write_sis_level2_all_1hr -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_sis_level2_all_1hr, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_sis_level2_all_1hr_error("write_sis_level2_all_1hr -> VSwrite: Couldn't write data.");

  memset(&SIS_data_1hr_struc, 0, sizeof(struct SIS_data_1hr));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_sis_level2_all_1hr()
{
  VSdetach(vdata_id_sis_level2_all_1hr);
  Vdetach(vgrp_id_sis_level2_all_1hr);
}

/*----     init access function    ----*/

int32 init_acc_sis_level2_all_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_sis_level2_all_1hr_error();


  if ((vdata_ref = VSfind(hdf_fp, "SIS_data_1hr")) <= 0 ) {
    print_sis_level2_all_1hr_error("init_acc_sis_level2_all_1hr -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_sis_level2_all_1hr = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_sis_level2_all_1hr_error("init_acc_sis_level2_all_1hr -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_sis_level2_all_1hr, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_sis_level2_all_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, flux_He, flux_C, flux_N, flux_O, flux_Ne, flux_Mg, flux_Si, flux_S, flux_Fe, cnt_He, cnt_C, cnt_N, cnt_O, cnt_Ne, cnt_Mg, cnt_Si, cnt_S, cnt_Fe, up_time_fraction, solar_activity_flag")) {
      print_sis_level2_all_1hr_error("init_acc_sis_level2_all_1hr -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_sis_level2_all_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_sis_level2_all_1hr(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_sis_level2_all_1hr(struct SIS_data_1hr *SIS_data_1hr_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_sis_level2_all_1hr_error();
void unpack_sis_level2_all_1hr();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SIS_data_1hr));
  VSinquire(vdata_id_sis_level2_all_1hr, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_sis_level2_all_1hr, recnum_rd)==FAIL) {
          print_sis_level2_all_1hr_error("read_sis_level2_all_1hr -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_sis_level2_all_1hr, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_sis_level2_all_1hr_error("read_sis_level2_all_1hr -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_sis_level2_all_1hr(odata, SIS_data_1hr_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_sis_level2_all_1hr()
{
  VSdetach(vdata_id_sis_level2_all_1hr);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_sis_level2_all_1hr(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_sis_level2_all_1hr_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SIS_data_1hr" )) ==FAIL)
    print_sis_level2_all_1hr_error("rd_Vgrp_sis_level2_all_1hr -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_sis_level2_all_1hr_error("rd_Vgrp_sis_level2_all_1hr -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_sis_level2_all_1hr_error("rd_Vgrp_sis_level2_all_1hr -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_sis_level2_all_1hr_error("rd_Vgrp_sis_level2_all_1hr -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SIS_data_1hr, HDstrlen(Vgrp_descrp_SIS_data_1hr)) ==FAIL)
    print_sis_level2_all_1hr_error("rd_Vgrp_sis_level2_all_1hr -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SIS_data_1hr);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_sis_level2_all_1hr_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sis_level2_all_1hr.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_sis_level2_all_1hr(uint8 *data, struct SIS_data_1hr *SIS_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SIS_data_1hr_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_He[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_C[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_N[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_O[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_Ne[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_Mg[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_Si[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_S[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->flux_Fe[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_He[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_C[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_N[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_O[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_Ne[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_Mg[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_Si[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_S[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->cnt_Fe[0], ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(data+ptr, &SIS_data_1hr_ptr->up_time_fraction, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SIS_data_1hr_ptr->solar_activity_flag, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_sis_level2_all_1hr(uint8 *data, struct SIS_data_1hr *SIS_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(&SIS_data_1hr_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SIS_data_1hr_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SIS_data_1hr_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SIS_data_1hr_ptr->flux_He[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_C[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_N[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_O[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_Ne[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_Mg[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_Si[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_S[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->flux_Fe[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_He[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_C[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_N[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_O[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_Ne[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_Mg[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_Si[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_S[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->cnt_Fe[0], data+ptr,  ((4)*(NUMBER_OF_ENERGY_BANDS)) );
   ptr+= ((4)*(NUMBER_OF_ENERGY_BANDS));
   memcpy(&SIS_data_1hr_ptr->up_time_fraction, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SIS_data_1hr_ptr->solar_activity_flag, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_sis_level2_all_1hr() {return(vgrp_id_sis_level2_all_1hr);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_sis_level2_all_1hr(char *wr_strval)
{
  strcpy(wr_strval, "The file 'sis_level2_data_1hr.h' is shown below, it was used to create the data in the Vgroup named 'VG_SIS_data_1hr'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"#include \"sis_sizes.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SIS_data_1hr {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32  flux_He[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_C[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_N[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_O[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_Ne[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_Mg[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_Si[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_S[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  flux_Fe[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32  cnt_He[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_C[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_N[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_O[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_Ne[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_Mg[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_Si[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_S[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"  float32  cnt_Fe[NUMBER_OF_ENERGY_BANDS];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 up_time_fraction;        \n");
  strcat(wr_strval,"  int32   solar_activity_flag;  /* = 0 less than threshold    */\n");
  strcat(wr_strval,"                                /* = 1 greater than threshold */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
