/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "sepica_level2_data_120s.h"
#include "df.h"

int32 vgrp_id_sepica_level2_data_120s;
static int32 vdata_id_sepica_level2_data_120s;

  /* 1271 is the size of sepica_level2_data_120s.h + 1 added line */
char Vgrp_descrp_SEPICA_data_120s[1271];

/****----  init create function  ----****/

int32 init_cr_sepica_level2_data_120s(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_sepica_level2_data_120s();

  void print_sepica_level2_data_120s_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_sepica_level2_data_120s = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_sepica_level2_data_120s, "VG_SEPICA_data_120s"); 
  Vsetclass(vgrp_id_sepica_level2_data_120s, "VG_SEPICA_LEVEL2_DATA_120S");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SEPICA_data_120s" )) ==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_sepica_level2_data_120s(Vgrp_descrp_SEPICA_data_120s);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SEPICA_data_120s, sizeof(Vgrp_descrp_SEPICA_data_120s))) ==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_sepica_level2_data_120s = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_sepica_level2_data_120s, "SEPICA_data_120s");
  VSsetclass(vdata_id_sepica_level2_data_120s, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_sepica_level2_data_120s, vdata_id_sepica_level2_data_120s)) ==FAIL) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "year", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "day", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "hr", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "min", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "sec", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "fp_year", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "H1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define H1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "H2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define H2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "H3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define H3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "H4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define H4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "H5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define H5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "He6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define He6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_H1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_H1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_H2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_H2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_H3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_H3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_H4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_H4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_H5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_H5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "unc_He6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define unc_He6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "up_time_fraction", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define up_time_fraction");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "number_of_records_120s", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define number_of_records_120s");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_120s, "number_of_records_1hr", DFNT_INT32, (1) )) {
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSfdefine: Couldn't define number_of_records_1hr");
    retval = -1;
  }

  if (VSsetfields(vdata_id_sepica_level2_data_120s,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H1, H2, H3, H4, H5, He1, He2, He3, He4, He5, He6, unc_H1, unc_H2, unc_H3, unc_H4, unc_H5, unc_He1, unc_He2, unc_He3, unc_He4, unc_He5, unc_He6, up_time_fraction, number_of_records_120s, number_of_records_1hr")){
    print_sepica_level2_data_120s_error("init_cr_sepica_level2_data_120s -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_sepica_level2_data_120s(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_sepica_level2_data_120s(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_sepica_level2_data_120s(struct SEPICA_data_120s SEPICA_data_120s_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_sepica_level2_data_120s_error();
void pack_sepica_level2_data_120s();

  odata = (uint8 *) malloc(sizeof(struct SEPICA_data_120s));
  pack_sepica_level2_data_120s(odata, &SEPICA_data_120s_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_sepica_level2_data_120s, recnum)==-1) {
		print_sepica_level2_data_120s_error("write_sepica_level2_data_120s -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_sepica_level2_data_120s, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_sepica_level2_data_120s_error("write_sepica_level2_data_120s -> VSwrite: Couldn't write data.");

  memset(&SEPICA_data_120s_struc, 0, sizeof(struct SEPICA_data_120s));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_sepica_level2_data_120s()
{
  VSdetach(vdata_id_sepica_level2_data_120s);
  Vdetach(vgrp_id_sepica_level2_data_120s);
}

/*----     init access function    ----*/

int32 init_acc_sepica_level2_data_120s(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_sepica_level2_data_120s_error();


  if ((vdata_ref = VSfind(hdf_fp, "SEPICA_data_120s")) <= 0 ) {
    print_sepica_level2_data_120s_error("init_acc_sepica_level2_data_120s -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_sepica_level2_data_120s = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_sepica_level2_data_120s_error("init_acc_sepica_level2_data_120s -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_sepica_level2_data_120s, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_sepica_level2_data_120s,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H1, H2, H3, H4, H5, He1, He2, He3, He4, He5, He6, unc_H1, unc_H2, unc_H3, unc_H4, unc_H5, unc_He1, unc_He2, unc_He3, unc_He4, unc_He5, unc_He6, up_time_fraction, number_of_records_120s, number_of_records_1hr")) {
      print_sepica_level2_data_120s_error("init_acc_sepica_level2_data_120s -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_sepica_level2_data_120s(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_sepica_level2_data_120s(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_sepica_level2_data_120s(struct SEPICA_data_120s *SEPICA_data_120s_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_sepica_level2_data_120s_error();
void unpack_sepica_level2_data_120s();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SEPICA_data_120s));
  VSinquire(vdata_id_sepica_level2_data_120s, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_sepica_level2_data_120s, recnum_rd)==FAIL) {
          print_sepica_level2_data_120s_error("read_sepica_level2_data_120s -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_sepica_level2_data_120s, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_sepica_level2_data_120s_error("read_sepica_level2_data_120s -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_sepica_level2_data_120s(odata, SEPICA_data_120s_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_sepica_level2_data_120s()
{
  VSdetach(vdata_id_sepica_level2_data_120s);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_sepica_level2_data_120s(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_sepica_level2_data_120s_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SEPICA_data_120s" )) ==FAIL)
    print_sepica_level2_data_120s_error("rd_Vgrp_sepica_level2_data_120s -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_sepica_level2_data_120s_error("rd_Vgrp_sepica_level2_data_120s -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_sepica_level2_data_120s_error("rd_Vgrp_sepica_level2_data_120s -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_sepica_level2_data_120s_error("rd_Vgrp_sepica_level2_data_120s -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SEPICA_data_120s, HDstrlen(Vgrp_descrp_SEPICA_data_120s)) ==FAIL)
    print_sepica_level2_data_120s_error("rd_Vgrp_sepica_level2_data_120s -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SEPICA_data_120s);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_sepica_level2_data_120s_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sepica_level2_data_120s.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_sepica_level2_data_120s(uint8 *data, struct SEPICA_data_120s *SEPICA_data_120s_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SEPICA_data_120s_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->H1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->H2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->H3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->H4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->H5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->He6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_H1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_H2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_H3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_H4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_H5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->unc_He6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->up_time_fraction, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->number_of_records_120s, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_120s_ptr->number_of_records_1hr, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_sepica_level2_data_120s(uint8 *data, struct SEPICA_data_120s *SEPICA_data_120s_ptr)
{
int32 ptr=0;

   memcpy(&SEPICA_data_120s_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_120s_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_120s_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_120s_ptr->H1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->H2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->H3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->H4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->H5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->He6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_H1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_H2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_H3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_H4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_H5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->unc_He6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->up_time_fraction, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->number_of_records_120s, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_120s_ptr->number_of_records_1hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_sepica_level2_data_120s() {return(vgrp_id_sepica_level2_data_120s);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_sepica_level2_data_120s(char *wr_strval)
{
  strcpy(wr_strval, "The file 'sepica_level2_data_120s.h' is shown below, it was used to create the data in the Vgroup named 'VG_SEPICA_data_120s'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SEPICA_data_120s {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 H1;\n");
  strcat(wr_strval,"  float32 H2;\n");
  strcat(wr_strval,"  float32 H3;\n");
  strcat(wr_strval,"  float32 H4;\n");
  strcat(wr_strval,"  float32 H5;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 He1;\n");
  strcat(wr_strval,"  float32 He2;\n");
  strcat(wr_strval,"  float32 He3;\n");
  strcat(wr_strval,"  float32 He4;\n");
  strcat(wr_strval,"  float32 He5;\n");
  strcat(wr_strval,"  float32 He6;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_H1;\n");
  strcat(wr_strval,"  float32 unc_H2;\n");
  strcat(wr_strval,"  float32 unc_H3;\n");
  strcat(wr_strval,"  float32 unc_H4;\n");
  strcat(wr_strval,"  float32 unc_H5;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_He1;\n");
  strcat(wr_strval,"  float32 unc_He2;\n");
  strcat(wr_strval,"  float32 unc_He3;\n");
  strcat(wr_strval,"  float32 unc_He4;\n");
  strcat(wr_strval,"  float32 unc_He5;\n");
  strcat(wr_strval,"  float32 unc_He6;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 up_time_fraction; \n");
  strcat(wr_strval,"  int32   number_of_records_120s;\n");
  strcat(wr_strval,"  int32   number_of_records_1hr;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  return(0);
}
