/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "epam_level2_lefs60_lems120.h"
#include "df.h"

int32 vgrp_id_epam_level2_lefs60_lems120;
static int32 vdata_id_epam_level2_lefs60_lems120;

  /* 1431 is the size of epam_level2_lefs60_lems120.h + 1 added line */
char Vgrp_descrp_EPAM_data_lefs60_lems120[1431];

/****----  init create function  ----****/

int32 init_cr_epam_level2_lefs60_lems120(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_lefs60_lems120();

  void print_epam_level2_lefs60_lems120_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_lefs60_lems120 = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_lefs60_lems120, "VG_EPAM_data_lefs60_lems120"); 
  Vsetclass(vgrp_id_epam_level2_lefs60_lems120, "VG_EPAM_LEVEL2_LEFS60_LEMS120");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_data_lefs60_lems120" )) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_lefs60_lems120(Vgrp_descrp_EPAM_data_lefs60_lems120);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_data_lefs60_lems120, sizeof(Vgrp_descrp_EPAM_data_lefs60_lems120))) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_lefs60_lems120 = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_lefs60_lems120, "EPAM_data_lefs60_lems120");
  VSsetclass(vdata_id_epam_level2_lefs60_lems120, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_lefs60_lems120, vdata_id_epam_level2_lefs60_lems120)) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "year", DFNT_INT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "day", DFNT_INT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "hr", DFNT_INT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "min", DFNT_INT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "sec", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "fp_year", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "unc_P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define unc_P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs60_lems120, "Data_Quality", DFNT_INT32, (1) )) {
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSfdefine: Couldn't define Data_Quality");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_lefs60_lems120,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, Data_Quality")){
    print_epam_level2_lefs60_lems120_error("init_cr_epam_level2_lefs60_lems120 -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_lefs60_lems120(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_lefs60_lems120(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_lefs60_lems120(struct EPAM_data_lefs60_lems120 EPAM_data_lefs60_lems120_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_lefs60_lems120_error();
void pack_epam_level2_lefs60_lems120();

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_lefs60_lems120));
  pack_epam_level2_lefs60_lems120(odata, &EPAM_data_lefs60_lems120_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_lefs60_lems120, recnum)==-1) {
		print_epam_level2_lefs60_lems120_error("write_epam_level2_lefs60_lems120 -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_lefs60_lems120, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_lefs60_lems120_error("write_epam_level2_lefs60_lems120 -> VSwrite: Couldn't write data.");

  memset(&EPAM_data_lefs60_lems120_struc, 0, sizeof(struct EPAM_data_lefs60_lems120));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_lefs60_lems120()
{
  VSdetach(vdata_id_epam_level2_lefs60_lems120);
  Vdetach(vgrp_id_epam_level2_lefs60_lems120);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_lefs60_lems120(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_lefs60_lems120_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_data_lefs60_lems120")) <= 0 ) {
    print_epam_level2_lefs60_lems120_error("init_acc_epam_level2_lefs60_lems120 -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_lefs60_lems120 = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("init_acc_epam_level2_lefs60_lems120 -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_lefs60_lems120, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_lefs60_lems120,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, Data_Quality")) {
      print_epam_level2_lefs60_lems120_error("init_acc_epam_level2_lefs60_lems120 -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_lefs60_lems120(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_lefs60_lems120(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_lefs60_lems120(struct EPAM_data_lefs60_lems120 *EPAM_data_lefs60_lems120_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_lefs60_lems120_error();
void unpack_epam_level2_lefs60_lems120();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_lefs60_lems120));
  VSinquire(vdata_id_epam_level2_lefs60_lems120, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_lefs60_lems120, recnum_rd)==FAIL) {
          print_epam_level2_lefs60_lems120_error("read_epam_level2_lefs60_lems120 -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_lefs60_lems120, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_lefs60_lems120_error("read_epam_level2_lefs60_lems120 -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_lefs60_lems120(odata, EPAM_data_lefs60_lems120_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_lefs60_lems120()
{
  VSdetach(vdata_id_epam_level2_lefs60_lems120);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_lefs60_lems120(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_lefs60_lems120_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_data_lefs60_lems120" )) ==FAIL)
    print_epam_level2_lefs60_lems120_error("rd_Vgrp_epam_level2_lefs60_lems120 -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_lefs60_lems120_error("rd_Vgrp_epam_level2_lefs60_lems120 -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_lefs60_lems120_error("rd_Vgrp_epam_level2_lefs60_lems120 -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_lefs60_lems120_error("rd_Vgrp_epam_level2_lefs60_lems120 -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_data_lefs60_lems120, HDstrlen(Vgrp_descrp_EPAM_data_lefs60_lems120)) ==FAIL)
    print_epam_level2_lefs60_lems120_error("rd_Vgrp_epam_level2_lefs60_lems120 -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_data_lefs60_lems120);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_lefs60_lems120_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_lefs60_lems120.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_lefs60_lems120(uint8 *data, struct EPAM_data_lefs60_lems120 *EPAM_data_lefs60_lems120_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->unc_P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs60_lems120_ptr->Data_Quality, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_epam_level2_lefs60_lems120(uint8 *data, struct EPAM_data_lefs60_lems120 *EPAM_data_lefs60_lems120_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_data_lefs60_lems120_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->unc_P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs60_lems120_ptr->Data_Quality, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_epam_level2_lefs60_lems120() {return(vgrp_id_epam_level2_lefs60_lems120);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_lefs60_lems120(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_lefs60_lems120.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_data_lefs60_lems120'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_data_lefs60_lems120 {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 E1p;\n");
  strcat(wr_strval,"  float32 E2p; \n");
  strcat(wr_strval,"  float32 E3p; \n");
  strcat(wr_strval,"  float32 E4p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 FP5p; \n");
  strcat(wr_strval,"  float32 FP6p; \n");
  strcat(wr_strval,"  float32 FP7p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 P1p; \n");
  strcat(wr_strval,"  float32 P2p; \n");
  strcat(wr_strval,"  float32 P3p; \n");
  strcat(wr_strval,"  float32 P4p; \n");
  strcat(wr_strval,"  float32 P5p; \n");
  strcat(wr_strval,"  float32 P6p; \n");
  strcat(wr_strval,"  float32 P7p; \n");
  strcat(wr_strval,"  float32 P8p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_E1p;\n");
  strcat(wr_strval,"  float32 unc_E2p; \n");
  strcat(wr_strval,"  float32 unc_E3p; \n");
  strcat(wr_strval,"  float32 unc_E4p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_FP5p; \n");
  strcat(wr_strval,"  float32 unc_FP6p; \n");
  strcat(wr_strval,"  float32 unc_FP7p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_P1p; \n");
  strcat(wr_strval,"  float32 unc_P2p; \n");
  strcat(wr_strval,"  float32 unc_P3p; \n");
  strcat(wr_strval,"  float32 unc_P4p; \n");
  strcat(wr_strval,"  float32 unc_P5p; \n");
  strcat(wr_strval,"  float32 unc_P6p; \n");
  strcat(wr_strval,"  float32 unc_P7p; \n");
  strcat(wr_strval,"  float32 unc_P8p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32   Data_Quality;                 /* 0=good,1=fill data */ \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  return(0);
}
