/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "epam_level2_header.h"
#include "df.h"

int32 vgrp_id_epam_level2_header;
static int32 vdata_id_epam_level2_header;

  /* 1822 is the size of epam_level2_header.h + 1 added line */
char Vgrp_descrp_EPAM_header[1822];

/****----  init create function  ----****/

int32 init_cr_epam_level2_header(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_header();

  void print_epam_level2_header_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_header = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_header, "VG_EPAM_header"); 
  Vsetclass(vgrp_id_epam_level2_header, "VG_EPAM_LEVEL2_HEADER");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_header" )) ==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_header(Vgrp_descrp_EPAM_header);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_header, sizeof(Vgrp_descrp_EPAM_header))) ==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_header = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_header, "EPAM_header");
  VSsetclass(vdata_id_epam_level2_header, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_header, vdata_id_epam_level2_header)) ==FAIL) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_header, "Num", DFNT_INT32, (1) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define Num");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W3", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W4", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W5", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W6", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W7", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "W8", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "Z2", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "Z2A", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "Z3", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "Z4", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "DE1", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "DE2", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "DE3", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "DE4", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E1", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E2", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E3", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E4", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP5", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP6", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP7", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P1", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P2", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P3", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P4", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P5", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P6", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P7", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P8", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E1p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E2p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E3p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "E4p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP5p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP6p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "FP7p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P1p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P2p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P3p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P4p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P5p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P6p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P7p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_header, "P8p", DFNT_UINT8, (NUMBER_OF_CHARACTORS) )) {
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSfdefine: Couldn't define P8p");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_header,"Num, W3, W4, W5, W6, W7, W8, Z2, Z2A, Z3, Z4, DE1, DE2, DE3, DE4, E1, E2, E3, E4, FP5, FP6, FP7, P1, P2, P3, P4, P5, P6, P7, P8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p")){
    print_epam_level2_header_error("init_cr_epam_level2_header -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_header(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_header(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_header(struct EPAM_header EPAM_header_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_header_error();
void pack_epam_level2_header();

  odata = (uint8 *) malloc(sizeof(struct EPAM_header));
  pack_epam_level2_header(odata, &EPAM_header_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_header, recnum)==-1) {
		print_epam_level2_header_error("write_epam_level2_header -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_header, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_header_error("write_epam_level2_header -> VSwrite: Couldn't write data.");

  memset(&EPAM_header_struc, 0, sizeof(struct EPAM_header));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_header()
{
  VSdetach(vdata_id_epam_level2_header);
  Vdetach(vgrp_id_epam_level2_header);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_header(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_header_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_header")) <= 0 ) {
    print_epam_level2_header_error("init_acc_epam_level2_header -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_header = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_header_error("init_acc_epam_level2_header -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_header, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_header,"Num, W3, W4, W5, W6, W7, W8, Z2, Z2A, Z3, Z4, DE1, DE2, DE3, DE4, E1, E2, E3, E4, FP5, FP6, FP7, P1, P2, P3, P4, P5, P6, P7, P8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p")) {
      print_epam_level2_header_error("init_acc_epam_level2_header -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_header(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_header(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_header(struct EPAM_header *EPAM_header_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_header_error();
void unpack_epam_level2_header();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_header));
  VSinquire(vdata_id_epam_level2_header, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_header, recnum_rd)==FAIL) {
          print_epam_level2_header_error("read_epam_level2_header -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_header, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_header_error("read_epam_level2_header -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_header(odata, EPAM_header_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_header()
{
  VSdetach(vdata_id_epam_level2_header);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_header(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_header_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_header" )) ==FAIL)
    print_epam_level2_header_error("rd_Vgrp_epam_level2_header -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_header_error("rd_Vgrp_epam_level2_header -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_header_error("rd_Vgrp_epam_level2_header -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_header_error("rd_Vgrp_epam_level2_header -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_header, HDstrlen(Vgrp_descrp_EPAM_header)) ==FAIL)
    print_epam_level2_header_error("rd_Vgrp_epam_level2_header -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_header);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_header_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_header.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_header(uint8 *data, struct EPAM_header *EPAM_header_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_header_ptr->Num, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_header_ptr->W3[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->W4[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->W5[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->W6[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->W7[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->W8[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->Z2[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->Z2A[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->Z3[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->Z4[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->DE1[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->DE2[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->DE3[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->DE4[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E1[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E2[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E3[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E4[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP5[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP6[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP7[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P1[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P2[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P3[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P4[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P5[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P6[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P7[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P8[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E1p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E2p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E3p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->E4p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP5p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP6p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->FP7p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P1p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P2p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P3p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P4p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P5p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P6p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P7p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(data+ptr, &EPAM_header_ptr->P8p[0], ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
}

/*----   unpack function    ----*/

void unpack_epam_level2_header(uint8 *data, struct EPAM_header *EPAM_header_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_header_ptr->Num, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_header_ptr->W3[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->W4[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->W5[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->W6[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->W7[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->W8[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->Z2[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->Z2A[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->Z3[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->Z4[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->DE1[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->DE2[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->DE3[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->DE4[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E1[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E2[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E3[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E4[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP5[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP6[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP7[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P1[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P2[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P3[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P4[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P5[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P6[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P7[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P8[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E1p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E2p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E3p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->E4p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP5p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP6p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->FP7p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P1p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P2p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P3p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P4p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P5p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P6p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P7p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
   memcpy(&EPAM_header_ptr->P8p[0], data+ptr,  ((1)*(NUMBER_OF_CHARACTORS)) );
   ptr+= ((1)*(NUMBER_OF_CHARACTORS));
}
int32 get_vgrp_id_epam_level2_header() {return(vgrp_id_epam_level2_header);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_header(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_header.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_header'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#define NUMBER_OF_CHARACTORS 100\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_header {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32 Num;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  uint8 W3[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 W4[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 W5[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 W6[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 W7[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 W8[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 Z2[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 Z2A[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 Z3[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 Z4[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 DE1[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 DE2[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 DE3[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 DE4[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  uint8 E1[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E2[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E3[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E4[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP5[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP6[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP7[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P1[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P2[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P3[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P4[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P5[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P6[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P7[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P8[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  uint8 E1p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E2p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E3p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 E4p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP5p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP6p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 FP7p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P1p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P2p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P3p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P4p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P5p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P6p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P7p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"  uint8 P8p[NUMBER_OF_CHARACTORS];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
