/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "epam_level2_ca_wartd_de.h"
#include "df.h"

int32 vgrp_id_epam_level2_ca_wartd_de;
static int32 vdata_id_epam_level2_ca_wartd_de;

  /* 1369 is the size of epam_level2_ca_wartd_de.h + 1 added line */
char Vgrp_descrp_EPAM_data_ca_wartd_de[1369];

/****----  init create function  ----****/

int32 init_cr_epam_level2_ca_wartd_de(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_ca_wartd_de();

  void print_epam_level2_ca_wartd_de_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_ca_wartd_de = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_ca_wartd_de, "VG_EPAM_data_ca_wartd_de"); 
  Vsetclass(vgrp_id_epam_level2_ca_wartd_de, "VG_EPAM_LEVEL2_CA_WARTD_DE");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_data_ca_wartd_de" )) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_ca_wartd_de(Vgrp_descrp_EPAM_data_ca_wartd_de);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_data_ca_wartd_de, sizeof(Vgrp_descrp_EPAM_data_ca_wartd_de))) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_ca_wartd_de = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_ca_wartd_de, "EPAM_data_ca_wartd_de");
  VSsetclass(vdata_id_epam_level2_ca_wartd_de, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_ca_wartd_de, vdata_id_epam_level2_ca_wartd_de)) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "year", DFNT_INT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "day", DFNT_INT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "hr", DFNT_INT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "min", DFNT_INT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "sec", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "fp_year", DFNT_FLOAT64, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "unc_DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define unc_DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_ca_wartd_de, "Data_Quality", DFNT_INT32, (1) )) {
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSfdefine: Couldn't define Data_Quality");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_ca_wartd_de,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, W3, W4, W5, W6, W7, W8, Z2, Z2A, Z3, Z4, DE1, DE2, DE3, DE4, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, Data_Quality")){
    print_epam_level2_ca_wartd_de_error("init_cr_epam_level2_ca_wartd_de -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_ca_wartd_de(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_ca_wartd_de(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_ca_wartd_de(struct EPAM_data_ca_wartd_de EPAM_data_ca_wartd_de_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_ca_wartd_de_error();
void pack_epam_level2_ca_wartd_de();

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_ca_wartd_de));
  pack_epam_level2_ca_wartd_de(odata, &EPAM_data_ca_wartd_de_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_ca_wartd_de, recnum)==-1) {
		print_epam_level2_ca_wartd_de_error("write_epam_level2_ca_wartd_de -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_ca_wartd_de, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_ca_wartd_de_error("write_epam_level2_ca_wartd_de -> VSwrite: Couldn't write data.");

  memset(&EPAM_data_ca_wartd_de_struc, 0, sizeof(struct EPAM_data_ca_wartd_de));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_ca_wartd_de()
{
  VSdetach(vdata_id_epam_level2_ca_wartd_de);
  Vdetach(vgrp_id_epam_level2_ca_wartd_de);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_ca_wartd_de(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_ca_wartd_de_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_data_ca_wartd_de")) <= 0 ) {
    print_epam_level2_ca_wartd_de_error("init_acc_epam_level2_ca_wartd_de -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_ca_wartd_de = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("init_acc_epam_level2_ca_wartd_de -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_ca_wartd_de, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_ca_wartd_de,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, W3, W4, W5, W6, W7, W8, Z2, Z2A, Z3, Z4, DE1, DE2, DE3, DE4, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, Data_Quality")) {
      print_epam_level2_ca_wartd_de_error("init_acc_epam_level2_ca_wartd_de -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_ca_wartd_de(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_ca_wartd_de(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_ca_wartd_de(struct EPAM_data_ca_wartd_de *EPAM_data_ca_wartd_de_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_ca_wartd_de_error();
void unpack_epam_level2_ca_wartd_de();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_ca_wartd_de));
  VSinquire(vdata_id_epam_level2_ca_wartd_de, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_ca_wartd_de, recnum_rd)==FAIL) {
          print_epam_level2_ca_wartd_de_error("read_epam_level2_ca_wartd_de -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_ca_wartd_de, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_ca_wartd_de_error("read_epam_level2_ca_wartd_de -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_ca_wartd_de(odata, EPAM_data_ca_wartd_de_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_ca_wartd_de()
{
  VSdetach(vdata_id_epam_level2_ca_wartd_de);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_ca_wartd_de(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_ca_wartd_de_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_data_ca_wartd_de" )) ==FAIL)
    print_epam_level2_ca_wartd_de_error("rd_Vgrp_epam_level2_ca_wartd_de -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_ca_wartd_de_error("rd_Vgrp_epam_level2_ca_wartd_de -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_ca_wartd_de_error("rd_Vgrp_epam_level2_ca_wartd_de -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_ca_wartd_de_error("rd_Vgrp_epam_level2_ca_wartd_de -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_data_ca_wartd_de, HDstrlen(Vgrp_descrp_EPAM_data_ca_wartd_de)) ==FAIL)
    print_epam_level2_ca_wartd_de_error("rd_Vgrp_epam_level2_ca_wartd_de -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_data_ca_wartd_de);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_ca_wartd_de_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_ca_wartd_de.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_ca_wartd_de(uint8 *data, struct EPAM_data_ca_wartd_de *EPAM_data_ca_wartd_de_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->unc_DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_ca_wartd_de_ptr->Data_Quality, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_epam_level2_ca_wartd_de(uint8 *data, struct EPAM_data_ca_wartd_de *EPAM_data_ca_wartd_de_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_data_ca_wartd_de_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->unc_DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_ca_wartd_de_ptr->Data_Quality, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_epam_level2_ca_wartd_de() {return(vgrp_id_epam_level2_ca_wartd_de);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_ca_wartd_de(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_ca_wartd_de.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_data_ca_wartd_de'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_data_ca_wartd_de {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 W3; \n");
  strcat(wr_strval,"  float32 W4; \n");
  strcat(wr_strval,"  float32 W5; \n");
  strcat(wr_strval,"  float32 W6; \n");
  strcat(wr_strval,"  float32 W7; \n");
  strcat(wr_strval,"  float32 W8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Z2; \n");
  strcat(wr_strval,"  float32 Z2A; \n");
  strcat(wr_strval,"  float32 Z3; \n");
  strcat(wr_strval,"  float32 Z4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 DE1; \n");
  strcat(wr_strval,"  float32 DE2; \n");
  strcat(wr_strval,"  float32 DE3; \n");
  strcat(wr_strval,"  float32 DE4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_W3; \n");
  strcat(wr_strval,"  float32 unc_W4; \n");
  strcat(wr_strval,"  float32 unc_W5; \n");
  strcat(wr_strval,"  float32 unc_W6; \n");
  strcat(wr_strval,"  float32 unc_W7; \n");
  strcat(wr_strval,"  float32 unc_W8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Z2; \n");
  strcat(wr_strval,"  float32 unc_Z2A; \n");
  strcat(wr_strval,"  float32 unc_Z3; \n");
  strcat(wr_strval,"  float32 unc_Z4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_DE1; \n");
  strcat(wr_strval,"  float32 unc_DE2; \n");
  strcat(wr_strval,"  float32 unc_DE3; \n");
  strcat(wr_strval,"  float32 unc_DE4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32   Data_Quality;                 /* 0=good,1=fill data */ \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  return(0);
}
