/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "epam_level2_data_1day.h"
#include "df.h"

int32 vgrp_id_epam_level2_all_1day;
static int32 vdata_id_epam_level2_all_1day;

  /* 2381 is the size of epam_level2_data_1day.h + 1 added line */
char Vgrp_descrp_EPAM_data_1day[2381];

/****----  init create function  ----****/

int32 init_cr_epam_level2_all_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_all_1day();

  void print_epam_level2_all_1day_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_all_1day = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_all_1day, "VG_EPAM_data_1day"); 
  Vsetclass(vgrp_id_epam_level2_all_1day, "VG_EPAM_LEVEL2_DATA_1DAY");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_data_1day" )) ==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_all_1day(Vgrp_descrp_EPAM_data_1day);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_data_1day, sizeof(Vgrp_descrp_EPAM_data_1day))) ==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_all_1day = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_all_1day, "EPAM_data_1day");
  VSsetclass(vdata_id_epam_level2_all_1day, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_all_1day, vdata_id_epam_level2_all_1day)) ==FAIL) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_all_1day, "year", DFNT_INT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "day", DFNT_INT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "hr", DFNT_INT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "min", DFNT_INT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "sec", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "fp_year", DFNT_FLOAT64, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "unc_FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define unc_FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_all_1day, "livetime", DFNT_FLOAT32, (1) )) {
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSfdefine: Couldn't define livetime");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_all_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, P1, P2, P3, P4, P5, P6, P7, P8, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, DE1, DE2, DE3, DE4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, W3, W4, W5, W6, W7, W8, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, Z2, Z2A, Z3, Z4, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, E1, E2, E3, E4, FP5, FP6, FP7, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, livetime")){
    print_epam_level2_all_1day_error("init_cr_epam_level2_all_1day -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_all_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_all_1day(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_all_1day(struct EPAM_data_1day EPAM_data_1day_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_all_1day_error();
void pack_epam_level2_all_1day();

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_1day));
  pack_epam_level2_all_1day(odata, &EPAM_data_1day_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_all_1day, recnum)==-1) {
		print_epam_level2_all_1day_error("write_epam_level2_all_1day -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_all_1day, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_all_1day_error("write_epam_level2_all_1day -> VSwrite: Couldn't write data.");

  memset(&EPAM_data_1day_struc, 0, sizeof(struct EPAM_data_1day));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_all_1day()
{
  VSdetach(vdata_id_epam_level2_all_1day);
  Vdetach(vgrp_id_epam_level2_all_1day);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_all_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_all_1day_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_data_1day")) <= 0 ) {
    print_epam_level2_all_1day_error("init_acc_epam_level2_all_1day -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_all_1day = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_all_1day_error("init_acc_epam_level2_all_1day -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_all_1day, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_all_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, P1, P2, P3, P4, P5, P6, P7, P8, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, DE1, DE2, DE3, DE4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, W3, W4, W5, W6, W7, W8, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, Z2, Z2A, Z3, Z4, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, E1, E2, E3, E4, FP5, FP6, FP7, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, livetime")) {
      print_epam_level2_all_1day_error("init_acc_epam_level2_all_1day -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_all_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_all_1day(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_all_1day(struct EPAM_data_1day *EPAM_data_1day_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_all_1day_error();
void unpack_epam_level2_all_1day();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_1day));
  VSinquire(vdata_id_epam_level2_all_1day, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_all_1day, recnum_rd)==FAIL) {
          print_epam_level2_all_1day_error("read_epam_level2_all_1day -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_all_1day, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_all_1day_error("read_epam_level2_all_1day -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_all_1day(odata, EPAM_data_1day_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_all_1day()
{
  VSdetach(vdata_id_epam_level2_all_1day);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_all_1day(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_all_1day_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_data_1day" )) ==FAIL)
    print_epam_level2_all_1day_error("rd_Vgrp_epam_level2_all_1day -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_all_1day_error("rd_Vgrp_epam_level2_all_1day -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_all_1day_error("rd_Vgrp_epam_level2_all_1day -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_all_1day_error("rd_Vgrp_epam_level2_all_1day -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_data_1day, HDstrlen(Vgrp_descrp_EPAM_data_1day)) ==FAIL)
    print_epam_level2_all_1day_error("rd_Vgrp_epam_level2_all_1day -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_data_1day);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_all_1day_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_all_1day.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_all_1day(uint8 *data, struct EPAM_data_1day *EPAM_data_1day_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_data_1day_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->unc_FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_1day_ptr->livetime, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_epam_level2_all_1day(uint8 *data, struct EPAM_data_1day *EPAM_data_1day_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_data_1day_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_1day_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_1day_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_1day_ptr->P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->unc_FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_1day_ptr->livetime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_epam_level2_all_1day() {return(vgrp_id_epam_level2_all_1day);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_all_1day(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_data_1day.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_data_1day'.\n\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_data_1day {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 P1; \n");
  strcat(wr_strval,"  float32 P2; \n");
  strcat(wr_strval,"  float32 P3; \n");
  strcat(wr_strval,"  float32 P4; \n");
  strcat(wr_strval,"  float32 P5; \n");
  strcat(wr_strval,"  float32 P6; \n");
  strcat(wr_strval,"  float32 P7; \n");
  strcat(wr_strval,"  float32 P8; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_P1; \n");
  strcat(wr_strval,"  float32 unc_P2; \n");
  strcat(wr_strval,"  float32 unc_P3; \n");
  strcat(wr_strval,"  float32 unc_P4; \n");
  strcat(wr_strval,"  float32 unc_P5; \n");
  strcat(wr_strval,"  float32 unc_P6; \n");
  strcat(wr_strval,"  float32 unc_P7; \n");
  strcat(wr_strval,"  float32 unc_P8; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 DE1; \n");
  strcat(wr_strval,"  float32 DE2; \n");
  strcat(wr_strval,"  float32 DE3; \n");
  strcat(wr_strval,"  float32 DE4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_DE1; \n");
  strcat(wr_strval,"  float32 unc_DE2; \n");
  strcat(wr_strval,"  float32 unc_DE3; \n");
  strcat(wr_strval,"  float32 unc_DE4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 W3; \n");
  strcat(wr_strval,"  float32 W4; \n");
  strcat(wr_strval,"  float32 W5; \n");
  strcat(wr_strval,"  float32 W6;\n");
  strcat(wr_strval,"  float32 W7; \n");
  strcat(wr_strval,"  float32 W8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_W3; \n");
  strcat(wr_strval,"  float32 unc_W4; \n");
  strcat(wr_strval,"  float32 unc_W5; \n");
  strcat(wr_strval,"  float32 unc_W6; \n");
  strcat(wr_strval,"  float32 unc_W7; \n");
  strcat(wr_strval,"  float32 unc_W8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 E1p;\n");
  strcat(wr_strval,"  float32 E2p; \n");
  strcat(wr_strval,"  float32 E3p; \n");
  strcat(wr_strval,"  float32 E4p; \n");
  strcat(wr_strval,"  float32 FP5p; \n");
  strcat(wr_strval,"  float32 FP6p; \n");
  strcat(wr_strval,"  float32 FP7p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_E1p;\n");
  strcat(wr_strval,"  float32 unc_E2p; \n");
  strcat(wr_strval,"  float32 unc_E3p; \n");
  strcat(wr_strval,"  float32 unc_E4p; \n");
  strcat(wr_strval,"  float32 unc_FP5p; \n");
  strcat(wr_strval,"  float32 unc_FP6p; \n");
  strcat(wr_strval,"  float32 unc_FP7p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Z2; \n");
  strcat(wr_strval,"  float32 Z2A; \n");
  strcat(wr_strval,"  float32 Z3; \n");
  strcat(wr_strval,"  float32 Z4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Z2; \n");
  strcat(wr_strval,"  float32 unc_Z2A; \n");
  strcat(wr_strval,"  float32 unc_Z3; \n");
  strcat(wr_strval,"  float32 unc_Z4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 P1p; \n");
  strcat(wr_strval,"  float32 P2p; \n");
  strcat(wr_strval,"  float32 P3p; \n");
  strcat(wr_strval,"  float32 P4p; \n");
  strcat(wr_strval,"  float32 P5p; \n");
  strcat(wr_strval,"  float32 P6p; \n");
  strcat(wr_strval,"  float32 P7p; \n");
  strcat(wr_strval,"  float32 P8p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_P1p; \n");
  strcat(wr_strval,"  float32 unc_P2p; \n");
  strcat(wr_strval,"  float32 unc_P3p; \n");
  strcat(wr_strval,"  float32 unc_P4p; \n");
  strcat(wr_strval,"  float32 unc_P5p; \n");
  strcat(wr_strval,"  float32 unc_P6p; \n");
  strcat(wr_strval,"  float32 unc_P7p; \n");
  strcat(wr_strval,"  float32 unc_P8p; \n");
  strcat(wr_strval," \n");
  strcat(wr_strval,"  float32 E1;\n");
  strcat(wr_strval,"  float32 E2; \n");
  strcat(wr_strval,"  float32 E3; \n");
  strcat(wr_strval,"  float32 E4; \n");
  strcat(wr_strval,"  float32 FP5; \n");
  strcat(wr_strval,"  float32 FP6; \n");
  strcat(wr_strval,"  float32 FP7; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_E1;\n");
  strcat(wr_strval,"  float32 unc_E2; \n");
  strcat(wr_strval,"  float32 unc_E3; \n");
  strcat(wr_strval,"  float32 unc_E4; \n");
  strcat(wr_strval,"  float32 unc_FP5; \n");
  strcat(wr_strval,"  float32 unc_FP6; \n");
  strcat(wr_strval,"  float32 unc_FP7; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 livetime;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  return(0);
}
